/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.properties.editor.reconciling;

import java.util.regex.Pattern;
import org.springframework.ide.eclipse.boot.properties.editor.util.Type;
import org.springframework.ide.eclipse.boot.properties.editor.util.TypeUtil;
import org.springframework.ide.eclipse.editor.support.reconcile.IProblemCollector;
import org.springframework.ide.eclipse.editor.support.util.DocumentRegion;

public class DelimitedListReconciler {
    private final TypeBasedReconciler valueReconciler;
    private final Pattern delimiter;

    public DelimitedListReconciler(Pattern delimiter, TypeBasedReconciler valueReconciler) {
        this.valueReconciler = valueReconciler;
        this.delimiter = delimiter;
    }

    public void reconcile(DocumentRegion region, Type listType, IProblemCollector problems) {
        Type elType = this.getElementType(listType);
        if (elType != null) {
            DocumentRegion[] pieces = region.split(this.delimiter);
            int i = 0;
            while (i < pieces.length) {
                this.valueReconciler.reconcile(pieces[i], elType, problems);
                ++i;
            }
        }
    }

    private Type getElementType(Type listType) {
        Type elType = TypeUtil.getDomainType(listType);
        if (elType != null) {
            Type nestedElType = this.getElementType(elType);
            if (nestedElType != null) {
                return nestedElType;
            }
            return elType;
        }
        return null;
    }

    static interface TypeBasedReconciler {
        public void reconcile(DocumentRegion var1, Type var2, IProblemCollector var3);
    }
}

