/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.properties.editor.reconciling;

import java.util.HashMap;
import java.util.Map;
import org.springframework.ide.eclipse.boot.properties.editor.reconciling.SpringPropertiesProblemType;
import org.springframework.ide.eclipse.boot.properties.editor.reconciling.SpringPropertyProblem;
import org.springframework.ide.eclipse.editor.support.reconcile.IProblemCollector;
import org.springframework.ide.eclipse.editor.support.reconcile.ReconcileProblem;
import org.springframework.ide.eclipse.editor.support.util.DocumentRegion;

public class DuplicateNameChecker {
    private Map<String, DocumentRegion> seen = new HashMap<String, DocumentRegion>();
    IProblemCollector problems;

    public DuplicateNameChecker(IProblemCollector problems) {
        this.problems = problems;
    }

    public void check(DocumentRegion nameRegion) {
        if (!nameRegion.isEmpty()) {
            String name = nameRegion.toString();
            if (this.seen.containsKey(name)) {
                DocumentRegion pending = this.seen.get(name);
                if (pending != null) {
                    this.reportDuplicate(pending);
                    this.seen.put(name, null);
                }
                this.reportDuplicate(nameRegion);
            } else {
                this.seen.put(name, nameRegion);
            }
        }
    }

    private void reportDuplicate(DocumentRegion nameRegion) {
        this.problems.accept((ReconcileProblem)SpringPropertyProblem.problem(SpringPropertiesProblemType.PROP_DUPLICATE_KEY, "Duplicate property '" + nameRegion + "'", nameRegion));
    }
}

