/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.properties.editor.reconciling;

import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.springframework.ide.eclipse.boot.properties.editor.reconciling.SpringPropertiesProblemType;
import org.springframework.ide.eclipse.boot.properties.editor.reconciling.SpringPropertyProblem;
import org.springframework.ide.eclipse.boot.properties.editor.util.Type;
import org.springframework.ide.eclipse.boot.properties.editor.util.TypeUtil;
import org.springframework.ide.eclipse.boot.properties.editor.util.TypedProperty;
import org.springframework.ide.eclipse.editor.support.reconcile.IProblemCollector;
import org.springframework.ide.eclipse.editor.support.reconcile.ReconcileProblem;
import org.springframework.ide.eclipse.editor.support.util.StringUtil;
import org.springframework.ide.eclipse.editor.support.util.ValueParser;

public class PropertyNavigator {
    private static final char EOF = '\u0000';
    private IProblemCollector problemCollector;
    private IDocument doc;
    private TypeUtil typeUtil;
    private IRegion region;
    private String regionText;

    public PropertyNavigator(IDocument doc, IProblemCollector problemCollector, TypeUtil typeUtil, IRegion region) throws BadLocationException {
        this.doc = doc;
        this.problemCollector = problemCollector == null ? IProblemCollector.NULL : problemCollector;
        this.typeUtil = typeUtil;
        this.region = region;
        this.regionText = doc.get(region.getOffset(), region.getLength());
    }

    public Type navigate(int offset, Type type) {
        if (type != null) {
            if (offset < this.getEnd(this.region)) {
                char navOp = this.getChar(offset);
                if (navOp == '.') {
                    if (this.typeUtil.isDotable(type)) {
                        return this.dotNavigate(offset, type);
                    }
                    this.problemCollector.accept((ReconcileProblem)SpringPropertyProblem.problem(SpringPropertiesProblemType.PROP_INVALID_BEAN_NAVIGATION, "Can't use '.' navigation for property '" + this.textBetween(this.region.getOffset(), offset) + "' of type " + type, offset, this.getEnd(this.region) - offset));
                } else if (navOp == '[') {
                    if (TypeUtil.isBracketable(type)) {
                        return this.bracketNavigate(offset, type);
                    }
                    this.problemCollector.accept((ReconcileProblem)SpringPropertyProblem.problem(SpringPropertiesProblemType.PROP_INVALID_INDEXED_NAVIGATION, "Can't use '[..]' navigation for property '" + this.textBetween(this.region.getOffset(), offset) + "' of type " + type, offset, this.getEnd(this.region) - offset));
                } else {
                    this.problemCollector.accept((ReconcileProblem)SpringPropertyProblem.problem(SpringPropertiesProblemType.PROP_EXPECTED_DOT_OR_LBRACK, "Expecting either a '.' or '['", offset, this.getEnd(this.region) - offset));
                }
            } else {
                return type;
            }
        }
        return null;
    }

    private String textBetween(int start, int end) {
        try {
            if (end > start) {
                return this.doc.get(start, end - start);
            }
        }
        catch (BadLocationException badLocationException) {}
        return "";
    }

    private int indexOf(char c, int from) {
        int offset = this.region.getOffset();
        int found = this.regionText.indexOf(c, from - offset);
        if (found >= 0) {
            return found + offset;
        }
        return -1;
    }

    private Type bracketNavigate(int offset, Type type) {
        int lbrack = offset;
        int rbrack = this.indexOf(']', lbrack);
        if (rbrack >= 0) {
            String indexStr = this.textBetween(lbrack + 1, rbrack);
            if (!indexStr.contains("${")) {
                try {
                    Integer.parseInt(indexStr);
                }
                catch (Exception exception) {
                    this.problemCollector.accept((ReconcileProblem)SpringPropertyProblem.problem(SpringPropertiesProblemType.PROP_NON_INTEGER_IN_BRACKETS, "Expecting 'Integer' for '[...]' notation '" + this.textBetween(this.region.getOffset(), lbrack) + "'", lbrack + 1, rbrack - lbrack - 1));
                }
            }
            Type domainType = TypeUtil.getDomainType(type);
            return this.navigate(rbrack + 1, domainType);
        }
        this.problemCollector.accept((ReconcileProblem)SpringPropertyProblem.problem(SpringPropertiesProblemType.PROP_NO_MATCHING_RBRACK, "No matching ']'", offset, 1));
        return null;
    }

    private Type dotNavigate(int offset, Type type) {
        if (TypeUtil.isMap(type)) {
            ValueParser keyParser;
            int keyStart = offset + 1;
            Type domainType = TypeUtil.getDomainType(type);
            int keyEnd = -1;
            keyEnd = this.typeUtil.isDotable(domainType) ? this.nextNavOp(".[", offset + 1) : this.nextNavOp("[", offset + 1);
            String key = this.textBetween(keyStart, keyEnd);
            Type keyType = this.typeUtil.getKeyType(type);
            if (keyType != null && (keyParser = this.typeUtil.getValueParser(keyType)) != null) {
                try {
                    keyParser.parse(key);
                }
                catch (Exception exception) {
                    this.problemCollector.accept((ReconcileProblem)SpringPropertyProblem.problem(SpringPropertiesProblemType.PROP_VALUE_TYPE_MISMATCH, "Expecting " + this.typeUtil.niceTypeName(keyType), keyStart, keyEnd - keyStart));
                }
            }
            return this.navigate(keyEnd, domainType);
        }
        int keyStart = offset + 1;
        int keyEnd = this.nextNavOp(".[", offset + 1);
        if (keyEnd < 0) {
            keyEnd = this.getEnd(this.region);
        }
        String key = StringUtil.camelCaseToHyphens((String)this.textBetween(keyStart, keyEnd));
        List<TypedProperty> properties = this.typeUtil.getProperties(type, TypeUtil.EnumCaseMode.ALIASED, TypeUtil.BeanPropertyNameMode.ALIASED);
        if (properties != null) {
            TypedProperty prop = null;
            for (TypedProperty p : properties) {
                if (!p.getName().equals(key)) continue;
                prop = p;
                break;
            }
            if (prop == null) {
                this.problemCollector.accept((ReconcileProblem)SpringPropertyProblem.problem(SpringPropertiesProblemType.PROP_INVALID_BEAN_PROPERTY, "Type '" + this.typeUtil.niceTypeName(type) + "' has no property '" + key + "'", keyStart, keyEnd - keyStart));
            } else {
                if (prop.isDeprecated()) {
                    this.problemCollector.accept(this.problemDeprecated(type, prop, keyStart, keyEnd - keyStart));
                }
                return this.navigate(keyEnd, prop.getType());
            }
        }
        return null;
    }

    private ReconcileProblem problemDeprecated(Type contextType, TypedProperty prop, int offset, int len) {
        SpringPropertyProblem p = SpringPropertyProblem.problem(SpringPropertiesProblemType.PROP_DEPRECATED, TypeUtil.deprecatedPropertyMessage(prop.getName(), this.typeUtil.niceTypeName(contextType), prop.getDeprecationReplacement(), prop.getDeprecationReason()), offset, len);
        p.setPropertyName(prop.getName());
        return p;
    }

    private int nextNavOp(String navops, int pos) {
        int end = this.getEnd(this.region);
        while (pos < end && navops.indexOf(this.getChar(pos)) < 0) {
            ++pos;
        }
        return Math.min(pos, end);
    }

    private char getChar(int offset) {
        try {
            return this.doc.getChar(offset);
        }
        catch (BadLocationException badLocationException) {
            return '\u0000';
        }
    }

    private int getEnd(IRegion region) {
        return region.getOffset() + region.getLength();
    }
}

