/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.properties.editor.reconciling;

import java.util.ArrayList;
import org.springframework.ide.eclipse.boot.properties.editor.preferences.EditorType;
import org.springframework.ide.eclipse.editor.support.reconcile.ProblemSeverity;
import org.springframework.ide.eclipse.editor.support.reconcile.ProblemType;

public enum SpringPropertiesProblemType implements ProblemType
{
    PROP_INVALID_BEAN_NAVIGATION("Accessing a 'bean property' in a type that doesn't have properties (e.g. like String or Integer)"),
    PROP_INVALID_INDEXED_NAVIGATION("Accessing a property using [] in a type that doesn't support that"),
    PROP_EXPECTED_DOT_OR_LBRACK("Unexpected character found where a '.' or '[' was expected"),
    PROP_NO_MATCHING_RBRACK("Found a '[' but no matching ']'"),
    PROP_NON_INTEGER_IN_BRACKETS("Use of [..] navigation with non-integer value"),
    PROP_VALUE_TYPE_MISMATCH("Expecting a value of a certain type, but value doesn't parse as such"),
    PROP_INVALID_BEAN_PROPERTY("Accessing a named property in a type that doesn't provide a property accessor with that name"),
    PROP_UNKNOWN_PROPERTY(ProblemSeverity.WARNING, "Property-key not found in any configuration metadata on the project's classpath"),
    PROP_DEPRECATED(ProblemSeverity.WARNING, "Property is marked as Deprecated"),
    PROP_DUPLICATE_KEY("Multiple assignments to the same property value"),
    YAML_SYNTAX_ERROR("Error parsing the input using snakeyaml"),
    YAML_UNKNOWN_PROPERTY(ProblemSeverity.WARNING, "Property-key not found in the configuration metadata on the project's classpath"),
    YAML_VALUE_TYPE_MISMATCH("Expecting a value of a certain type, but value doesn't parse as such"),
    YAML_EXPECT_SCALAR("Expecting a 'scalar' value but found something more complex."),
    YAML_EXPECT_TYPE_FOUND_SEQUENCE("Found a 'sequence' node where a non 'list-like' type is expected"),
    YAML_EXPECT_TYPE_FOUND_MAPPING("Found a 'mapping' node where a type that can't be treated as a 'property map' is expected"),
    YAML_EXPECT_MAPPING("Expecting a 'mapping' node but found something else"),
    YAML_EXPECT_BEAN_PROPERTY_NAME("Expecting a 'bean property' name but found something more complex"),
    YAML_INVALID_BEAN_PROPERTY("Accessing a named property in a type that doesn't provide a property accessor with that name"),
    YAML_DEPRECATED(ProblemSeverity.WARNING, "Property is marked as Deprecated"),
    YAML_DUPLICATE_KEY("A mapping node contains multiple entries for the same key");

    private final ProblemSeverity defaultSeverity;
    private String description;
    private String label;
    public static final SpringPropertiesProblemType[] FOR_YAML;
    public static final SpringPropertiesProblemType[] FOR_PROPERTIES;

    static {
        FOR_YAML = SpringPropertiesProblemType.FOR(EditorType.YAML);
        FOR_PROPERTIES = SpringPropertiesProblemType.FOR(EditorType.PROP);
    }

    private SpringPropertiesProblemType(ProblemSeverity defaultSeverity, String description, String label) {
        this.description = description;
        this.defaultSeverity = defaultSeverity;
        this.label = label;
    }

    private SpringPropertiesProblemType(ProblemSeverity defaultSeverity, String description) {
        this(defaultSeverity, description, null);
    }

    private SpringPropertiesProblemType(String description) {
        this(ProblemSeverity.ERROR, description);
    }

    public ProblemSeverity getDefaultSeverity() {
        return this.defaultSeverity;
    }

    public static SpringPropertiesProblemType[] forProperties() {
        return SpringPropertiesProblemType.withPrefix("PROP_");
    }

    public static SpringPropertiesProblemType[] FOR(EditorType et) {
        return SpringPropertiesProblemType.withPrefix(et.getProblemTypePrefix());
    }

    private static SpringPropertiesProblemType[] withPrefix(String prefix) {
        SpringPropertiesProblemType[] allValues = SpringPropertiesProblemType.values();
        ArrayList<SpringPropertiesProblemType> values = new ArrayList<SpringPropertiesProblemType>(allValues.length);
        SpringPropertiesProblemType[] springPropertiesProblemTypeArray = allValues;
        int n = allValues.length;
        int n2 = 0;
        while (n2 < n) {
            SpringPropertiesProblemType v = springPropertiesProblemTypeArray[n2];
            if (v.toString().startsWith(prefix)) {
                values.add(v);
            }
            ++n2;
        }
        return values.toArray(new SpringPropertiesProblemType[values.size()]);
    }

    public String getLabel() {
        if (this.label == null) {
            this.label = this.createDefaultLabel();
        }
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    private String createDefaultLabel() {
        String label = this.toString().substring(5).toLowerCase().replace('_', ' ');
        return String.valueOf(Character.toUpperCase(label.charAt(0))) + label.substring(1);
    }

    public EditorType getEditorType() {
        String string = this.toString();
        EditorType[] editorTypeArray = EditorType.values();
        int n = editorTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            EditorType et = editorTypeArray[n2];
            String prefix = et.getProblemTypePrefix();
            if (string.startsWith(prefix)) {
                return et;
            }
            ++n2;
        }
        throw new IllegalStateException("Bug: unknown editor type for " + (Object)((Object)this));
    }
}

