/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.properties.editor.reconciling;

import java.util.regex.Pattern;
import javax.inject.Provider;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.internal.ui.propertiesfileeditor.PropertiesFileEscapes;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextUtilities;
import org.springframework.ide.eclipse.boot.properties.editor.FuzzyMap;
import org.springframework.ide.eclipse.boot.properties.editor.SpringPropertiesCompletionEngine;
import org.springframework.ide.eclipse.boot.properties.editor.SpringPropertiesEditorPlugin;
import org.springframework.ide.eclipse.boot.properties.editor.metadata.PropertyInfo;
import org.springframework.ide.eclipse.boot.properties.editor.quickfix.ReplaceDeprecatedPropertyQuickfix;
import org.springframework.ide.eclipse.boot.properties.editor.reconciling.DelimitedListReconciler;
import org.springframework.ide.eclipse.boot.properties.editor.reconciling.DuplicateNameChecker;
import org.springframework.ide.eclipse.boot.properties.editor.reconciling.PropertyNavigator;
import org.springframework.ide.eclipse.boot.properties.editor.reconciling.SpringPropertiesProblemType;
import org.springframework.ide.eclipse.boot.properties.editor.reconciling.SpringPropertyProblem;
import org.springframework.ide.eclipse.boot.properties.editor.util.Type;
import org.springframework.ide.eclipse.boot.properties.editor.util.TypeParser;
import org.springframework.ide.eclipse.boot.properties.editor.util.TypeUtil;
import org.springframework.ide.eclipse.editor.support.reconcile.IProblemCollector;
import org.springframework.ide.eclipse.editor.support.reconcile.IReconcileEngine;
import org.springframework.ide.eclipse.editor.support.reconcile.ReconcileProblem;
import org.springframework.ide.eclipse.editor.support.util.DocumentRegion;
import org.springframework.ide.eclipse.editor.support.util.DocumentUtil;
import org.springframework.ide.eclipse.editor.support.util.StringUtil;
import org.springframework.ide.eclipse.editor.support.util.ValueParser;

public class SpringPropertiesReconcileEngine
implements IReconcileEngine {
    private static final Pattern COMMA = Pattern.compile("(\\s|\\\\\\s)*,(\\s|\\\\\\s)*");
    private static final Pattern SPACES = Pattern.compile("(\\s|\\\\\\s)*");
    private static final Pattern ASSIGN = SpringPropertiesCompletionEngine.ASSIGN;
    private Provider<FuzzyMap<PropertyInfo>> fIndexProvider;
    private TypeUtil typeUtil;
    private final DelimitedListReconciler commaListReconciler = new DelimitedListReconciler(COMMA, this::reconcileType);

    public SpringPropertiesReconcileEngine(Provider<FuzzyMap<PropertyInfo>> provider, TypeUtil typeUtil) {
        this.fIndexProvider = provider;
        this.typeUtil = typeUtil;
    }

    public void reconcile(IDocument doc, IProblemCollector problemCollector, IProgressMonitor mon) {
        block14: {
            FuzzyMap<PropertyInfo> index = this.getIndex();
            if (index == null || index.isEmpty()) {
                return;
            }
            problemCollector.beginCollecting();
            try {
                try {
                    DuplicateNameChecker duplicateNameChecker = new DuplicateNameChecker(problemCollector);
                    ITypedRegion[] regions = TextUtilities.computePartitioning((IDocument)doc, (String)"___pf_partitioning", (int)0, (int)doc.getLength(), (boolean)true);
                    if (regions == null || regions.length <= 0) break block14;
                    mon.beginTask("Reconciling Spring Properties", regions.length);
                    int i = 0;
                    while (i < regions.length) {
                        ITypedRegion r = regions[i];
                        try {
                            DocumentRegion fullName;
                            String type = r.getType();
                            if ("__dftl_partition_content_type".equals(type) && (!(fullName = new DocumentRegion(doc, (IRegion)r).trim()).isEmpty() || this.isAssigned(doc, (IRegion)r))) {
                                duplicateNameChecker.check(fullName);
                                PropertyInfo validProperty = SpringPropertiesCompletionEngine.findLongestValidProperty(index, fullName.toString());
                                if (validProperty != null) {
                                    int offset;
                                    PropertyNavigator navigator;
                                    Type valueType;
                                    IRegion trimmedRegion = fullName.asRegion();
                                    if (validProperty.isDeprecated()) {
                                        problemCollector.accept((ReconcileProblem)this.problemDeprecated(fullName, validProperty));
                                    }
                                    if ((valueType = (navigator = new PropertyNavigator(doc, problemCollector, this.typeUtil, trimmedRegion)).navigate(offset = validProperty.getId().length() + trimmedRegion.getOffset(), TypeParser.parse(validProperty.getType()))) != null) {
                                        this.reconcileType(doc, valueType, regions, i, problemCollector);
                                    }
                                } else {
                                    PropertyInfo similarEntry = index.findLongestCommonPrefixEntry(fullName.toString());
                                    String validPrefix = StringUtil.commonPrefix((CharSequence)similarEntry.getId(), (CharSequence)fullName);
                                    problemCollector.accept((ReconcileProblem)this.problemUnkownProperty(fullName, similarEntry, validPrefix));
                                }
                            }
                        }
                        catch (Exception e) {
                            SpringPropertiesEditorPlugin.log(e);
                        }
                        ++i;
                    }
                }
                catch (Throwable e2) {
                    SpringPropertiesEditorPlugin.log(e2);
                    problemCollector.endCollecting();
                }
            }
            finally {
                problemCollector.endCollecting();
            }
        }
    }

    protected SpringPropertyProblem problemDeprecated(DocumentRegion trimmedRegion, PropertyInfo property) {
        SpringPropertyProblem p = SpringPropertyProblem.problem(SpringPropertiesProblemType.PROP_DEPRECATED, TypeUtil.deprecatedPropertyMessage(property.getId(), null, property.getDeprecationReplacement(), property.getDeprecationReason()), trimmedRegion);
        p.setPropertyName(property.getId());
        p.setMetadata(property);
        p.setProblemFixer(ReplaceDeprecatedPropertyQuickfix.FIXER);
        return p;
    }

    protected SpringPropertyProblem problemUnkownProperty(DocumentRegion fullNameRegion, PropertyInfo similarEntry, CharSequence validPrefix) {
        String fullName = fullNameRegion.toString();
        SpringPropertyProblem p = SpringPropertyProblem.problem(SpringPropertiesProblemType.PROP_UNKNOWN_PROPERTY, "'" + fullName + "' is an unknown property." + this.suggestSimilar(similarEntry, validPrefix, fullName), fullNameRegion.subSequence(validPrefix.length()));
        p.setPropertyName(fullName);
        return p;
    }

    private FuzzyMap<PropertyInfo> getIndex() {
        return (FuzzyMap)this.fIndexProvider.get();
    }

    private void reconcileType(IDocument doc, Type expectType, ITypedRegion[] regions, int i, IProblemCollector problems) {
        DocumentRegion escapedValue = this.getAssignedValue(doc, regions, i);
        if (escapedValue == null) {
            int charPos = DocumentUtil.lastNonWhitespaceCharOfRegion((IDocument)doc, (IRegion)regions[i]);
            if (charPos >= 0) {
                problems.accept((ReconcileProblem)SpringPropertyProblem.problem(SpringPropertiesProblemType.PROP_VALUE_TYPE_MISMATCH, "Expecting '" + this.typeUtil.niceTypeName(expectType) + "'", charPos, 1));
            }
        } else {
            this.reconcileType(escapedValue, expectType, problems);
        }
    }

    private void reconcileType(DocumentRegion escapedValue, Type expectType, IProblemCollector problems) {
        ValueParser parser = this.typeUtil.getValueParser(expectType);
        if (parser != null) {
            try {
                String valueStr = PropertiesFileEscapes.unescape((String)escapedValue.toString());
                if (!valueStr.contains("${")) {
                    parser.parse(valueStr);
                }
            }
            catch (Exception exception) {
                problems.accept((ReconcileProblem)SpringPropertyProblem.problem(SpringPropertiesProblemType.PROP_VALUE_TYPE_MISMATCH, "Expecting '" + this.typeUtil.niceTypeName(expectType) + "'", escapedValue));
            }
        } else if (TypeUtil.isList(expectType) || TypeUtil.isArray(expectType)) {
            this.commaListReconciler.reconcile(escapedValue, expectType, problems);
        }
    }

    private DocumentRegion getAssignedValue(IDocument doc, ITypedRegion[] regions, int i) {
        int valueRegionIndex = i + 1;
        if (valueRegionIndex < regions.length) {
            String valueRegionType = regions[valueRegionIndex].getType();
            DocumentRegion valueRegion = new DocumentRegion(doc, (IRegion)regions[valueRegionIndex]);
            if ("__pf_roperty_value".equals(valueRegionType)) {
                valueRegion = valueRegion.trimStart(ASSIGN).trimEnd(SPACES);
                return valueRegion;
            }
        }
        return null;
    }

    private String suggestSimilar(PropertyInfo similarEntry, CharSequence validPrefix, CharSequence fullName) {
        int matchedChars = validPrefix.length();
        int wrongChars = fullName.length() - matchedChars;
        if (wrongChars < matchedChars) {
            return " Did you mean '" + similarEntry.getId() + "'?";
        }
        return "";
    }

    private boolean isAssigned(IDocument doc, IRegion r) {
        try {
            char c = doc.getChar(r.getOffset() + r.getLength());
            return SpringPropertiesCompletionEngine.isAssign(c);
        }
        catch (BadLocationException badLocationException) {
            return false;
        }
    }
}

