/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.properties.editor.reconciling;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.IReconcilingStrategyExtension;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.springframework.ide.eclipse.boot.properties.editor.DocumentContextFinder;
import org.springframework.ide.eclipse.boot.properties.editor.IReconcileTrigger;
import org.springframework.ide.eclipse.editor.support.reconcile.IReconcileEngine;
import org.springframework.ide.eclipse.editor.support.reconcile.ReconcileStrategy;
import org.springframework.ide.eclipse.editor.support.reconcile.SeverityProvider;

public class SpringPropertiesReconcileStrategy
extends ReconcileStrategy
implements IReconcilingStrategy,
IReconcilingStrategyExtension,
IPropertyChangeListener {
    private static final IContentType TEXT_CONTENT_TYPE = Platform.getContentTypeManager().getContentType("org.eclipse.core.runtime.text");
    private final IReconcileTrigger fReconcileTrigger;
    private final DocumentContextFinder fDocumentContextFinder;
    private SeverityProvider fSeverities;
    private IPreferenceStore fProjectPreferences;

    public SpringPropertiesReconcileStrategy(ISourceViewer viewer, IReconcileEngine engine, DocumentContextFinder documentContextFinder, IReconcileTrigger reconcileTrigger) {
        super(viewer, engine);
        Assert.isNotNull((Object)viewer);
        this.fDocumentContextFinder = documentContextFinder;
        this.fReconcileTrigger = reconcileTrigger;
    }

    protected IContentType getContentType() {
        return TEXT_CONTENT_TYPE;
    }

    public void setDocument(IDocument document) {
        IProject project;
        super.setDocument(document);
        this.fSeverities = this.fDocumentContextFinder.getSeverityProvider(document);
        if (this.fProjectPreferences != null) {
            this.fProjectPreferences.removePropertyChangeListener((IPropertyChangeListener)this);
        }
        if ((project = this.getProject()) != null) {
            this.fProjectPreferences = new ScopedPreferenceStore((IScopeContext)new ProjectScope(project), "org.springframework.ide.eclipse.boot.properties.editor");
            this.fProjectPreferences.addPropertyChangeListener((IPropertyChangeListener)this);
        }
    }

    private IProject getProject() {
        IJavaProject jp;
        IDocument document = this.getDocument();
        if (document != null && (jp = this.fDocumentContextFinder.getJavaProject(document)) != null) {
            return jp.getProject();
        }
        return null;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().startsWith("spring.properties.editor.problem.")) {
            this.fReconcileTrigger.forceReconcile();
        }
    }

    protected SeverityProvider getSeverities() {
        if (this.fSeverities == null) {
            return super.getSeverities();
        }
        return this.fSeverities;
    }
}

