/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.properties.editor.reconciling;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.springframework.ide.eclipse.boot.properties.editor.metadata.PropertyInfo;
import org.springframework.ide.eclipse.boot.properties.editor.preferences.EditorType;
import org.springframework.ide.eclipse.boot.properties.editor.preferences.ProblemSeverityPreferencesUtil;
import org.springframework.ide.eclipse.boot.properties.editor.quickfix.IgnoreProblemTypeInProjectQuickfix;
import org.springframework.ide.eclipse.boot.properties.editor.quickfix.IgnoreProblemTypeInWorkspaceQuickfix;
import org.springframework.ide.eclipse.boot.properties.editor.reconciling.CreateAdditionalMetadataQuickfix;
import org.springframework.ide.eclipse.boot.properties.editor.reconciling.ProblemFixer;
import org.springframework.ide.eclipse.boot.properties.editor.reconciling.SpringPropertiesProblemType;
import org.springframework.ide.eclipse.editor.support.reconcile.FixableProblem;
import org.springframework.ide.eclipse.editor.support.reconcile.QuickfixContext;
import org.springframework.ide.eclipse.editor.support.reconcile.ReconcileProblem;
import org.springframework.ide.eclipse.editor.support.util.DocumentRegion;

public class SpringPropertyProblem
implements ReconcileProblem,
FixableProblem {
    private static final EnumSet<SpringPropertiesProblemType> FIXABLE_UNKNOWN_PROPERTY_PROBLEM_TYPES = EnumSet.of(SpringPropertiesProblemType.PROP_UNKNOWN_PROPERTY, SpringPropertiesProblemType.YAML_UNKNOWN_PROPERTY);
    private String msg;
    private int length;
    private int offset;
    private SpringPropertiesProblemType type;
    private String propertyName;
    private PropertyInfo metadata;
    private ProblemFixer problemFixer;

    private SpringPropertyProblem(SpringPropertiesProblemType type, String msg, int offset, int length) {
        this.msg = msg;
        this.offset = offset;
        this.length = length;
        this.type = type;
    }

    public String getMessage() {
        return this.msg;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLength() {
        return this.length;
    }

    public String toString() {
        return "@[" + this.offset + "," + this.length + "]: " + this.msg;
    }

    public SpringPropertiesProblemType getType() {
        return this.type;
    }

    public static SpringPropertyProblem problem(SpringPropertiesProblemType problemType, String message, DocumentRegion region) {
        if (region.isEmpty()) {
            region = SpringPropertyProblem.makeVisible(region);
        }
        IRegion absolute = region.asRegion();
        return SpringPropertyProblem.problem(problemType, message, absolute.getOffset(), absolute.getLength());
    }

    private static DocumentRegion makeVisible(DocumentRegion region) {
        DocumentRegion altRegion = region.textAfter(1);
        if (!altRegion.isEmpty() && SpringPropertyProblem.canUnderline(altRegion.charAt(0))) {
            return altRegion;
        }
        altRegion = region.textBefore(1);
        if (!altRegion.isEmpty() && SpringPropertyProblem.canUnderline(altRegion.charAt(0))) {
            return altRegion;
        }
        return region;
    }

    private static boolean canUnderline(char c) {
        return c != '\n' && c != '\r';
    }

    public static SpringPropertyProblem problem(SpringPropertiesProblemType problemType, String message, int offset, int len) {
        return new SpringPropertyProblem(problemType, message, offset, len);
    }

    public List<ICompletionProposal> getQuickfixes(QuickfixContext context) {
        ArrayList<ICompletionProposal> proposals = new ArrayList<ICompletionProposal>(2);
        this.addProvidedFixes(context, proposals);
        this.addUnknownPropertyFixes(context, proposals);
        this.addIgnoreProblemFixes(context, proposals);
        return Collections.unmodifiableList(proposals);
    }

    private void addProvidedFixes(QuickfixContext context, List<ICompletionProposal> proposals) {
        if (this.problemFixer != null) {
            this.problemFixer.contributeFixes(context, this, proposals);
        }
    }

    private void addIgnoreProblemFixes(QuickfixContext context, List<ICompletionProposal> proposals) {
        IPreferenceStore projectPrefs = context.getProjectPreferences();
        SpringPropertiesProblemType problemType = this.getType();
        EditorType editorType = problemType.getEditorType();
        proposals.add(new IgnoreProblemTypeInProjectQuickfix(context, problemType));
        if (!ProblemSeverityPreferencesUtil.projectPreferencesEnabled(projectPrefs, editorType)) {
            proposals.add(new IgnoreProblemTypeInWorkspaceQuickfix(context.getWorkspacePreferences(), this.getType()));
        }
    }

    private void addUnknownPropertyFixes(QuickfixContext context, List<ICompletionProposal> proposals) {
        if (FIXABLE_UNKNOWN_PROPERTY_PROBLEM_TYPES.contains((Object)this.type)) {
            String missingProperty = this.getPropertyName();
            IJavaProject project = context.getJavaProject();
            if (project != null && missingProperty != null) {
                proposals.add(new CreateAdditionalMetadataQuickfix(project, missingProperty, context.getUI()));
            }
        }
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public PropertyInfo getMetadata() {
        return this.metadata;
    }

    public void setMetadata(PropertyInfo property) {
        this.metadata = property;
    }

    public ProblemFixer getProblemFixer() {
        return this.problemFixer;
    }

    public void setProblemFixer(ProblemFixer problemFixer) {
        this.problemFixer = problemFixer;
    }

    public int getEnd() {
        return this.getOffset() + this.getLength();
    }
}

