/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.properties.editor.util;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.ui.progress.UIJob;
import org.springframework.ide.eclipse.boot.properties.editor.util.Type;
import org.springframework.ide.eclipse.boot.properties.editor.util.TypeParser;
import org.springframework.ide.eclipse.boot.properties.editor.util.TypeUtil;
import org.springframework.ide.eclipse.editor.support.EditorSupportActivator;
import org.springframework.ide.eclipse.editor.support.hover.HoverInfo;
import org.springframework.ide.eclipse.editor.support.util.HtmlBuffer;

public class JavaTypeLinks {
    private final HoverInfo hoverInfo;

    public JavaTypeLinks(HoverInfo hoverInfo) {
        this.hoverInfo = hoverInfo;
    }

    public void javaTypeLink(HtmlBuffer html, TypeUtil typeUtil, Type type) {
        this.javaTypeLink(html, typeUtil, type, "" + type);
    }

    public void javaTypeLink(HtmlBuffer html, IJavaProject javaProject, String typeStr) {
        this.javaTypeLink(html, new TypeUtil(javaProject), TypeParser.parse(typeStr), typeStr);
    }

    private void javaTypeLink(HtmlBuffer html, final TypeUtil typeUtil, final Type type, String displayString) {
        this.actionLink(html, displayString, new Runnable(){

            @Override
            public void run() {
                if (type != null) {
                    UIJob j = new UIJob("Open type " + type){

                        public IStatus runInUIThread(IProgressMonitor mon) {
                            mon.beginTask("Open type " + type, 10);
                            try {
                                try {
                                    IType javaType = typeUtil.getJavaProject().findType(type.getErasure(), (IProgressMonitor)new SubProgressMonitor(mon, 8));
                                    if (javaType != null) {
                                        JavaUI.openInEditor((IJavaElement)javaType);
                                    }
                                }
                                catch (Exception e) {
                                    EditorSupportActivator.log((Throwable)e);
                                    mon.done();
                                }
                            }
                            finally {
                                mon.done();
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    j.schedule();
                }
            }
        });
    }

    private void actionLink(HtmlBuffer html, String displayString, Runnable runnable) {
        this.hoverInfo.actionLink(html, displayString, runnable);
    }
}

