/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.properties.editor.util;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collection;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaProject;
import org.springframework.ide.eclipse.boot.properties.editor.metadata.CachingValueProvider;
import org.springframework.ide.eclipse.boot.properties.editor.metadata.StsValueHint;
import org.springframework.ide.eclipse.boot.properties.editor.metadata.ValueProviderRegistry;
import org.springframework.ide.eclipse.boot.util.JavaProjectUtil;
import org.springframework.ide.eclipse.boot.util.Log;
import org.springframework.ide.eclipse.editor.support.util.FuzzyMatcher;
import reactor.core.publisher.Flux;

public class ResourceHintProvider
implements ValueProviderRegistry.ValueProviderStrategy {
    private static final Pattern EXCLUDED = Pattern.compile(".*\\.java$");
    private static String[] CLASSPATH_PREFIXES = new String[]{"classpath:", "classpath*:"};
    private static final String[] URL_PREFIXES = new String[]{"classpath:", "classpath*:", "file:", "http://", "https://"};
    private final ImmutableList<StsValueHint> urlPrefixHints = ImmutableList.copyOf((Collection)Arrays.stream(URL_PREFIXES).map(StsValueHint::create).collect(Collectors.toList()));
    private ClasspathHints classpathHints = new ClasspathHints();

    @Override
    public Flux<StsValueHint> getValues(IJavaProject javaProject, String query) {
        String[] stringArray = CLASSPATH_PREFIXES;
        int n = CLASSPATH_PREFIXES.length;
        int n2 = 0;
        while (n2 < n) {
            String prefix = stringArray[n2];
            if (query.startsWith(prefix)) {
                return this.classpathHints.getValues(javaProject, query.substring(prefix.length())).map(hint -> hint.prefixWith(prefix));
            }
            ++n2;
        }
        return Flux.fromIterable(this.urlPrefixHints);
    }

    private static class ClasspathHints
    extends CachingValueProvider {
        private ClasspathHints() {
        }

        @Override
        protected Flux<StsValueHint> getValuesAsycn(IJavaProject javaProject, String query) {
            return this.getClasspathResourcePaths(javaProject).map(path -> path.toString()).filter(path -> !EXCLUDED.matcher((CharSequence)path).matches() && 0.0 != FuzzyMatcher.matchScore((String)query, (String)path)).distinct().map(path -> StsValueHint.create(path));
        }

        private Flux<IPath> getClasspathResourcePaths(IJavaProject javaProject) {
            return Flux.fromArray((Object[])JavaProjectUtil.getSourceFolders((IJavaProject)javaProject, (boolean)true)).flatMap(sourceFolder -> {
                int chopSegments = sourceFolder.getProjectRelativePath().segmentCount();
                return this.getResourcePaths((IContainer)sourceFolder).map(path -> path.removeFirstSegments(chopSegments));
            });
        }

        private Flux<IPath> getResourcePaths(IContainer folder) {
            return this.getMembers(folder).flatMap(member -> {
                Flux allPaths = Flux.just((Object)member.getProjectRelativePath());
                if (member instanceof IContainer) {
                    allPaths = allPaths.concatWith(this.getResourcePaths((IContainer)member));
                }
                return allPaths;
            });
        }

        private Flux<IResource> getMembers(IContainer folder) {
            try {
                return Flux.fromArray((Object[])folder.members());
            }
            catch (CoreException e) {
                Log.log((Throwable)e);
                return Flux.empty();
            }
        }
    }
}

