/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.properties.editor.util;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.springframework.ide.eclipse.boot.properties.editor.FuzzyMap;
import org.springframework.ide.eclipse.boot.properties.editor.SpringPropertiesEditorPlugin;
import org.springframework.ide.eclipse.boot.properties.editor.SpringPropertyIndex;
import org.springframework.ide.eclipse.boot.properties.editor.StsConfigMetadataRepositoryJsonLoader;
import org.springframework.ide.eclipse.boot.properties.editor.metadata.PropertyInfo;
import org.springframework.ide.eclipse.boot.properties.editor.metadata.ValueProviderRegistry;
import org.springframework.ide.eclipse.boot.properties.editor.util.ClasspathListener;
import org.springframework.ide.eclipse.boot.properties.editor.util.Listener;
import org.springframework.ide.eclipse.boot.properties.editor.util.ListenerManager;

public class SpringPropertiesIndexManager
extends ListenerManager<Listener<SpringPropertiesIndexManager>>
implements ClasspathListener {
    private Map<String, SpringPropertyIndex> indexes = null;
    private final ValueProviderRegistry valueProviders;

    public SpringPropertiesIndexManager(ValueProviderRegistry valueProviders) {
        this.valueProviders = valueProviders;
        SpringPropertiesEditorPlugin.getClasspathListeners().addListener(this);
        ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)new LiveMetadataListener(), 1);
    }

    public synchronized FuzzyMap<PropertyInfo> get(IJavaProject jp) {
        SpringPropertyIndex index;
        String key = jp.getElementName();
        if (this.indexes == null) {
            this.indexes = new HashMap<String, SpringPropertyIndex>();
        }
        if ((index = this.indexes.get(key)) == null) {
            index = new SpringPropertyIndex(this.valueProviders, jp);
            this.indexes.put(key, index);
        }
        return index;
    }

    @Override
    public synchronized void classpathChanged(IJavaProject jp) {
        this.clear();
    }

    private void clear() {
        if (this.indexes != null) {
            this.indexes.clear();
            for (Listener l : this.getListeners()) {
                l.changed(this);
            }
        }
    }

    public synchronized void liveMetadataChanged(IJavaProject jp, IFile jsonFile) {
        this.clear();
    }

    private class LiveMetadataListener
    implements IResourceChangeListener,
    IResourceDeltaVisitor {
        private LiveMetadataListener() {
        }

        public void resourceChanged(IResourceChangeEvent event) {
            try {
                event.getDelta().accept((IResourceDeltaVisitor)this);
            }
            catch (Exception e) {
                SpringPropertiesEditorPlugin.log(e);
            }
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            IResource r = delta.getResource();
            int t = r.getType();
            switch (t) {
                case 4: {
                    IProject p = (IProject)r;
                    if (p.isAccessible() && p.hasNature("org.eclipse.jdt.core.javanature")) {
                        IJavaProject jp = JavaCore.create((IProject)p);
                        IPath outputPath = jp.getOutputLocation().removeFirstSegments(1);
                        String[] stringArray = StsConfigMetadataRepositoryJsonLoader.PROJECT_META_DATA_LOCATIONS;
                        int n = StsConfigMetadataRepositoryJsonLoader.PROJECT_META_DATA_LOCATIONS.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String metaLoc = stringArray[n2];
                            IResourceDelta metaDelta = delta.findMember(outputPath.append(metaLoc));
                            IFile jsonFile = this.getFile(metaDelta);
                            if (jsonFile != null) {
                                SpringPropertiesIndexManager.this.liveMetadataChanged(jp, jsonFile);
                            }
                            ++n2;
                        }
                    }
                    return false;
                }
            }
            return true;
        }

        private IFile getFile(IResourceDelta delta) {
            int t;
            IResource r;
            if (delta != null && (r = delta.getResource()) != null && ((t = r.getType()) | 1) != 0) {
                return (IFile)r;
            }
            return null;
        }
    }
}

