/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.properties.editor.util;

import java.util.ArrayList;
import java.util.StringTokenizer;
import org.springframework.ide.eclipse.boot.properties.editor.util.Type;
import org.springframework.ide.eclipse.editor.support.util.StringUtil;

public class TypeParser {
    private static final String DELIM = "<>,";
    private Tokener input;

    private TypeParser(String input) {
        this.input = new Tokener(input);
    }

    public static Type parse(String str) {
        if (StringUtil.hasText((String)str)) {
            return new TypeParser(str).parseType();
        }
        return null;
    }

    private Type parseType() {
        String ident = this.input.nextToken();
        String token = this.input.peekToken();
        if ("<".equals(token)) {
            ArrayList<Type> params = this.parseParams();
            return new Type(ident, params.toArray(new Type[params.size()]));
        }
        return new Type(ident, null);
    }

    private ArrayList<Type> parseParams() {
        this.skip("<");
        try {
            ArrayList<Type> arrayList = this.parseParamList(new ArrayList<Type>());
            return arrayList;
        }
        finally {
            this.skip(">");
        }
    }

    private ArrayList<Type> parseParamList(ArrayList<Type> params) {
        String tok = this.input.peekToken();
        if (this.isIdent(tok)) {
            params.add(this.parseType());
            if (this.skip(",")) {
                return this.parseParamList(params);
            }
        }
        return params;
    }

    private boolean skip(String expected) {
        String t = this.input.peekToken();
        if (expected.equals(t)) {
            this.input.nextToken();
            return true;
        }
        return false;
    }

    public boolean isIdent(String token) {
        return token != null && !this.isSeparator(token);
    }

    private boolean isSeparator(String token) {
        if (token != null && token.length() == 1) {
            int len = DELIM.length();
            char c = token.charAt(0);
            int i = 0;
            while (i < len) {
                if (DELIM.charAt(i) == c) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private static class Tokener {
        private String lookahead;
        private StringTokenizer tokens;

        public Tokener(String input) {
            this.tokens = new StringTokenizer(input, TypeParser.DELIM, true);
        }

        public String nextToken() {
            if (this.lookahead != null) {
                try {
                    String string = this.lookahead;
                    return string;
                }
                finally {
                    this.lookahead = null;
                }
            }
            if (this.tokens.hasMoreTokens()) {
                return this.tokens.nextToken();
            }
            return null;
        }

        public String peekToken() {
            if (this.lookahead != null) {
                return this.lookahead;
            }
            if (this.tokens.hasMoreTokens()) {
                this.lookahead = this.tokens.nextToken();
                return this.lookahead;
            }
            return null;
        }
    }
}

