/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.properties.editor.util;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.net.MediaType;
import java.lang.reflect.Field;
import java.net.InetAddress;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.inject.Provider;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.springframework.boot.configurationmetadata.Deprecation;
import org.springframework.ide.eclipse.boot.core.BootActivator;
import org.springframework.ide.eclipse.boot.properties.editor.metadata.DeprecationUtil;
import org.springframework.ide.eclipse.boot.properties.editor.metadata.StsValueHint;
import org.springframework.ide.eclipse.boot.properties.editor.metadata.ValueProviderRegistry;
import org.springframework.ide.eclipse.boot.properties.editor.reconciling.AlwaysFailingParser;
import org.springframework.ide.eclipse.boot.properties.editor.util.ArrayUtils;
import org.springframework.ide.eclipse.boot.properties.editor.util.LazyProvider;
import org.springframework.ide.eclipse.boot.properties.editor.util.ResourceHintProvider;
import org.springframework.ide.eclipse.boot.properties.editor.util.Type;
import org.springframework.ide.eclipse.boot.properties.editor.util.TypedProperty;
import org.springframework.ide.eclipse.boot.util.Log;
import org.springframework.ide.eclipse.editor.support.util.CollectionUtil;
import org.springframework.ide.eclipse.editor.support.util.EnumValueParser;
import org.springframework.ide.eclipse.editor.support.util.StringUtil;
import org.springframework.ide.eclipse.editor.support.util.ValueParser;
import reactor.core.publisher.Flux;

public class TypeUtil {
    private static final Object OBJECT_TYPE_NAME = Object.class.getName();
    private static final String STRING_TYPE_NAME = String.class.getName();
    private static final String INET_ADDRESS_TYPE_NAME = InetAddress.class.getName();
    private static final String CLASS_TYPE_NAME = Class.class.getName();
    private IJavaProject javaProject;
    private static final Map<String, String> PRIMITIVE_TYPE_NAMES = new HashMap<String, String>();
    private static final Map<String, Type> PRIMITIVE_TO_BOX_TYPE = new HashMap<String, Type>();
    public static final Type INTEGER_TYPE;
    private static final Set<String> ASSIGNABLE_TYPES;
    private static final Set<String> ATOMIC_TYPES;
    private static final Map<String, String[]> TYPE_VALUES;
    private static final Map<String, ValueParser> VALUE_PARSERS;
    private static final String[] NO_PARAMS;
    private static final Map<String, ValueProviderRegistry.ValueProviderStrategy> VALUE_HINTERS;

    static {
        PRIMITIVE_TYPE_NAMES.put("java.lang.Boolean", "boolean");
        PRIMITIVE_TYPE_NAMES.put("java.lang.Byte", "byte");
        PRIMITIVE_TYPE_NAMES.put("java.lang.Short", "short");
        PRIMITIVE_TYPE_NAMES.put("java.lang.Integer", "int");
        PRIMITIVE_TYPE_NAMES.put("java.lang.Long", "long");
        PRIMITIVE_TYPE_NAMES.put("java.lang.Double", "double");
        PRIMITIVE_TYPE_NAMES.put("java.lang.Float", "float");
        PRIMITIVE_TYPE_NAMES.put("java.lang.Character", "char");
        for (Map.Entry<String, String> e : PRIMITIVE_TYPE_NAMES.entrySet()) {
            PRIMITIVE_TO_BOX_TYPE.put(e.getValue(), new Type(e.getKey(), null));
        }
        INTEGER_TYPE = new Type("java.lang.Integer", null);
        ASSIGNABLE_TYPES = new HashSet<String>(Arrays.asList("java.lang.Boolean", "java.lang.String", "java.lang.Short", "java.lang.Integer", "java.lang.Long", "java.lang.Double", "java.lang.Float", "java.lang.Character", "java.lang.Byte", INET_ADDRESS_TYPE_NAME, CLASS_TYPE_NAME, "java.lang.String[]"));
        ATOMIC_TYPES = new HashSet<String>(PRIMITIVE_TYPE_NAMES.keySet());
        ATOMIC_TYPES.add(INET_ADDRESS_TYPE_NAME);
        ATOMIC_TYPES.add(STRING_TYPE_NAME);
        ATOMIC_TYPES.add(CLASS_TYPE_NAME);
        TYPE_VALUES = new HashMap<String, String[]>();
        TYPE_VALUES.put("java.lang.Boolean", new String[]{"true", "false"});
        VALUE_PARSERS = new HashMap<String, ValueParser>();
        VALUE_PARSERS.put(Byte.class.getName(), new RadixableParser(){

            @Override
            public Object parse(String str, int radix) {
                return Byte.parseByte(str, radix);
            }
        });
        VALUE_PARSERS.put(Integer.class.getName(), new RadixableParser(){

            @Override
            public Object parse(String str, int radix) {
                return Integer.parseInt(str, radix);
            }
        });
        VALUE_PARSERS.put(Long.class.getName(), new RadixableParser(){

            @Override
            public Object parse(String str, int radix) {
                return Long.parseLong(str, radix);
            }
        });
        VALUE_PARSERS.put(Short.class.getName(), new RadixableParser(){

            @Override
            public Object parse(String str, int radix) {
                return Short.parseShort(str, radix);
            }
        });
        VALUE_PARSERS.put(Double.class.getName(), new ValueParser(){

            public Object parse(String str) {
                return Double.parseDouble(str);
            }
        });
        VALUE_PARSERS.put(Float.class.getName(), new ValueParser(){

            public Object parse(String str) {
                return Float.valueOf(Float.parseFloat(str));
            }
        });
        VALUE_PARSERS.put(Boolean.class.getName(), new ValueParser(){

            public Object parse(String str) {
                if ((str = str.toLowerCase()).equals("true")) {
                    return true;
                }
                if (str.equals("false")) {
                    return false;
                }
                throw new IllegalArgumentException("Value should be 'true' or 'false'");
            }
        });
        NO_PARAMS = new String[0];
        VALUE_HINTERS = new HashMap<String, ValueProviderRegistry.ValueProviderStrategy>();
        TypeUtil.valueHints("java.nio.charset.Charset", (Provider<String[]>)new LazyProvider<String[]>(){

            @Override
            protected String[] compute() {
                Set<String> charsets = Charset.availableCharsets().keySet();
                return charsets.toArray(new String[charsets.size()]);
            }
        });
        TypeUtil.valueHints("java.util.Locale", (Provider<String[]>)new LazyProvider<String[]>(){

            @Override
            protected String[] compute() {
                Locale[] locales = SimpleDateFormat.getAvailableLocales();
                String[] names = new String[locales.length];
                int i = 0;
                while (i < names.length) {
                    names[i] = locales[i].toString();
                    ++i;
                }
                return names;
            }
        });
        TypeUtil.valueHints("org.springframework.util.MimeType", (Provider<String[]>)new LazyProvider<String[]>(){

            @Override
            protected String[] compute() {
                try {
                    Field f = MediaType.class.getDeclaredField("KNOWN_TYPES");
                    f.setAccessible(true);
                    Map map = (Map)f.get(null);
                    TreeSet<String> mediaTypes = new TreeSet<String>();
                    for (MediaType m : map.keySet()) {
                        mediaTypes.add(m.toString());
                    }
                    return mediaTypes.toArray(new String[mediaTypes.size()]);
                }
                catch (Exception e) {
                    BootActivator.log((Throwable)e);
                    return null;
                }
            }
        });
        TypeUtil.valueHints("org.springframework.core.io.Resource", new ResourceHintProvider());
    }

    public TypeUtil(IJavaProject jp) {
        this.javaProject = jp;
    }

    public ValueParser getValueParser(Type type) {
        ValueParser simpleParser = VALUE_PARSERS.get(type.getErasure());
        if (simpleParser != null) {
            return simpleParser;
        }
        Collection<StsValueHint> enumValues = this.getAllowedValues(type, EnumCaseMode.ALIASED);
        if (enumValues != null) {
            return new EnumValueParser(this.niceTypeName(type), this.getBareValues(enumValues));
        }
        if (TypeUtil.isMap(type)) {
            return new AlwaysFailingParser(this.niceTypeName(type));
        }
        return null;
    }

    private String[] getBareValues(Collection<StsValueHint> hints) {
        if (hints != null) {
            String[] values = new String[hints.size()];
            int i = 0;
            for (StsValueHint h : hints) {
                values[i++] = h.getValue();
            }
            return values;
        }
        return null;
    }

    public Collection<StsValueHint> getAllowedValues(Type enumType, EnumCaseMode caseMode) {
        if (enumType != null) {
            try {
                IField[] fields;
                Object[] values = TYPE_VALUES.get(enumType.getErasure());
                if (values != null) {
                    if (caseMode == EnumCaseMode.ALIASED) {
                        ImmutableSet.Builder aliased = ImmutableSet.builder();
                        aliased.add(values);
                        int i = 0;
                        while (i < values.length) {
                            aliased.add((Object)((String)values[i]).toUpperCase());
                            ++i;
                        }
                        return aliased.build().stream().map(StsValueHint::create).collect(Collectors.toList());
                    }
                    return Arrays.stream(values).map(StsValueHint::create).collect(Collectors.toList());
                }
                IType type = this.findType(enumType.getErasure());
                if (type != null && type.isEnum() && (fields = type.getFields()) != null) {
                    ImmutableList.Builder enums = ImmutableList.builder();
                    boolean addOriginal = caseMode == EnumCaseMode.ORIGNAL || caseMode == EnumCaseMode.ALIASED;
                    boolean addLowerCased = caseMode == EnumCaseMode.LOWER_CASE || caseMode == EnumCaseMode.ALIASED;
                    int i = 0;
                    while (i < fields.length) {
                        IField f = fields[i];
                        StsValueHint.javaDocSnippet((IJavaElement)f);
                        if (f.isEnumConstant()) {
                            String rawName = f.getElementName();
                            if (addOriginal) {
                                enums.add((Object)StsValueHint.create(rawName, (IJavaElement)f));
                            }
                            if (addLowerCased) {
                                enums.add((Object)StsValueHint.create(StringUtil.upperCaseToHyphens((String)rawName), (IJavaElement)f));
                            }
                        }
                        ++i;
                    }
                    return enums.build();
                }
            }
            catch (Exception e) {
                BootActivator.log((Throwable)e);
            }
        }
        return null;
    }

    public String niceTypeName(Type _type) {
        StringBuilder buf = new StringBuilder();
        this.niceTypeName(_type, buf);
        return buf.toString();
    }

    public void niceTypeName(Type type, StringBuilder buf) {
        if (type == null) {
            buf.append("null");
            return;
        }
        String typeStr = type.getErasure();
        String primTypeName = PRIMITIVE_TYPE_NAMES.get(typeStr);
        if (primTypeName != null) {
            buf.append(primTypeName);
        } else if (typeStr.startsWith("java.lang.")) {
            buf.append(typeStr.substring("java.lang.".length()));
        } else if (typeStr.startsWith("java.util.")) {
            buf.append(typeStr.substring("java.util.".length()));
        } else {
            buf.append(typeStr);
        }
        if (this.isEnum(type)) {
            Collection<StsValueHint> values = this.getAllowedValues(type, EnumCaseMode.ORIGNAL);
            if (values != null && !values.isEmpty()) {
                buf.append("[");
                int i = 0;
                for (StsValueHint hint : values) {
                    if (i > 0) {
                        buf.append(", ");
                    }
                    buf.append(hint.getValue());
                    if (++i >= 4) break;
                }
                if (i < values.size()) {
                    buf.append(", ...");
                }
                buf.append("]");
            }
        } else if (type.isGeneric()) {
            Type[] params = type.getParams();
            buf.append("<");
            int i = 0;
            while (i < params.length) {
                if (i > 0) {
                    buf.append(", ");
                }
                this.niceTypeName(params[i], buf);
                ++i;
            }
            buf.append(">");
        }
    }

    public boolean isDotable(Type type) {
        String typeName = type.getErasure();
        if (typeName.equals("java.lang.Object")) {
            return false;
        }
        return !this.isAtomic(type);
    }

    public static boolean isObject(Type type) {
        return type != null && OBJECT_TYPE_NAME.equals(type.getErasure());
    }

    public static boolean isString(Type type) {
        return type != null && STRING_TYPE_NAME.equals(type.getErasure());
    }

    public boolean isAtomic(Type type) {
        if (type != null) {
            String typeName = type.getErasure();
            return ATOMIC_TYPES.contains(typeName) || this.isEnum(type);
        }
        return false;
    }

    public static boolean isBracketable(Type type) {
        return TypeUtil.isArray(type) || TypeUtil.isList(type);
    }

    public static boolean isList(Type type) {
        if (type != null) {
            String erasure = type.getErasure();
            try {
                Class<?> erasureClass = Class.forName(erasure);
                return List.class.isAssignableFrom(erasureClass);
            }
            catch (Exception exception) {}
        }
        return false;
    }

    public static boolean isSequencable(Type type) {
        return TypeUtil.isList(type) || TypeUtil.isArray(type);
    }

    public static boolean isArray(Type type) {
        return type != null && type.getErasure().endsWith("[]");
    }

    public static boolean isMap(Type type) {
        if (type != null) {
            String erasure = type.getErasure();
            try {
                Class<?> erasureClass = Class.forName(erasure);
                return Map.class.isAssignableFrom(erasureClass);
            }
            catch (Exception exception) {}
        }
        return false;
    }

    public static Type getDomainType(Type type) {
        if (TypeUtil.isArray(type)) {
            return TypeUtil.getArrayDomainType(type);
        }
        return ArrayUtils.lastElement(type.getParams());
    }

    private static Type getArrayDomainType(Type type) {
        if (type != null) {
            String fullName = type.getErasure();
            Assert.isLegal((boolean)fullName.endsWith("[]"));
            String elName = fullName.substring(0, fullName.length() - 2);
            return TypeUtil.normalizePrimitiveType(new Type(elName, null));
        }
        return null;
    }

    private static Type normalizePrimitiveType(Type type) {
        String name;
        Type boxType;
        if (type != null && (boxType = PRIMITIVE_TO_BOX_TYPE.get(name = type.getErasure())) != null) {
            return boxType;
        }
        return type;
    }

    public Type getKeyType(Type mapOrArrayType) {
        if (TypeUtil.isSequencable(mapOrArrayType)) {
            return INTEGER_TYPE;
        }
        return ArrayUtils.firstElement(mapOrArrayType.getParams());
    }

    public boolean isAssignableType(Type type) {
        return ASSIGNABLE_TYPES.contains(type.getErasure()) || this.isEnum(type) || this.isAssignableList(type);
    }

    private boolean isAssignableList(Type type) {
        if (TypeUtil.isBracketable(type)) {
            Type domainType = TypeUtil.getDomainType(type);
            return this.isAtomic(domainType);
        }
        return false;
    }

    public boolean isEnum(Type type) {
        try {
            IType eclipseType = this.findType(type.getErasure());
            if (eclipseType != null) {
                return eclipseType.isEnum();
            }
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
        return false;
    }

    private IType findType(String typeName) {
        try {
            if (this.javaProject != null) {
                return this.javaProject.findType(typeName);
            }
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
        return null;
    }

    private IType findType(Type beanType) {
        return this.findType(beanType.getErasure());
    }

    public List<TypedProperty> getProperties(Type type, EnumCaseMode enumMode, BeanPropertyNameMode beanMode) {
        if (type == null) {
            return null;
        }
        if (!this.isDotable(type)) {
            return Collections.emptyList();
        }
        if (TypeUtil.isMap(type)) {
            Collection<StsValueHint> keyHints;
            Type keyType = this.getKeyType(type);
            if (keyType != null && CollectionUtil.hasElements(keyHints = this.getAllowedValues(keyType, enumMode))) {
                Type valueType = TypeUtil.getDomainType(type);
                ArrayList<TypedProperty> properties = new ArrayList<TypedProperty>(keyHints.size());
                for (StsValueHint hint : keyHints) {
                    String propName = hint.getValue();
                    properties.add(new TypedProperty(propName, valueType, hint.getDescriptionProvider(), hint.getDeprecation()));
                }
                return properties;
            }
        } else {
            List<IMethod> getters;
            String typename = type.getErasure();
            IType eclipseType = this.findType(typename);
            if (eclipseType != null && (getters = this.getGetterMethods(eclipseType)) != null && !getters.isEmpty()) {
                ArrayList<TypedProperty> properties = new ArrayList<TypedProperty>(getters.size());
                for (IMethod m : getters) {
                    Deprecation deprecation = DeprecationUtil.extract((IJavaElement)m);
                    Type propType = null;
                    try {
                        propType = Type.fromSignature(m.getReturnType(), eclipseType);
                    }
                    catch (JavaModelException e) {
                        Log.log((Throwable)e);
                    }
                    if (beanMode.includesHyphenated()) {
                        properties.add(new TypedProperty(this.getterOrSetterNameToProperty(m.getElementName()), propType, deprecation));
                    }
                    if (!beanMode.includesCamelCase()) continue;
                    properties.add(new TypedProperty(this.getterOrSetterNameToCamelName(m.getElementName()), propType, deprecation));
                }
                return properties;
            }
        }
        return null;
    }

    public static void valueHints(String typeName, ValueProviderRegistry.ValueProviderStrategy provider) {
        Assert.isLegal((!VALUE_HINTERS.containsKey(typeName) ? 1 : 0) != 0);
        ATOMIC_TYPES.add(typeName);
        ASSIGNABLE_TYPES.add(typeName);
        VALUE_HINTERS.put(typeName, provider);
    }

    public static void valueHints(String typeName, final Provider<String[]> provider) {
        TypeUtil.valueHints(typeName, new ValueProviderRegistry.ValueProviderStrategy(){

            @Override
            public Flux<StsValueHint> getValues(IJavaProject javaProject, String query) {
                Object[] values = (String[])provider.get();
                if (ArrayUtils.hasElements(values)) {
                    return Flux.fromArray((Object[])values).map(StsValueHint::create);
                }
                return Flux.empty();
            }
        });
    }

    private String getterOrSetterNameToProperty(String name) {
        String camelName = this.getterOrSetterNameToCamelName(name);
        return StringUtil.camelCaseToHyphens((String)camelName);
    }

    public String getterOrSetterNameToCamelName(String name) {
        Assert.isLegal((name.startsWith("set") || name.startsWith("get") || name.startsWith("is") ? 1 : 0) != 0);
        int prefixLen = name.startsWith("is") ? 2 : 3;
        String camelName = String.valueOf(Character.toLowerCase(name.charAt(prefixLen))) + name.substring(prefixLen + 1);
        return camelName;
    }

    private List<IMethod> getGetterMethods(IType eclipseType) {
        try {
            IMethod[] allMethods;
            if (eclipseType != null && eclipseType.isClass() && ArrayUtils.hasElements(allMethods = eclipseType.getMethods())) {
                ArrayList<IMethod> getters = new ArrayList<IMethod>();
                IMethod[] iMethodArray = allMethods;
                int n = allMethods.length;
                int n2 = 0;
                while (n2 < n) {
                    String sig;
                    int numParams;
                    String mname;
                    IMethod m = iMethodArray[n2];
                    if (!this.isStatic(m) && this.isPublic(m) && ((mname = m.getElementName()).startsWith("get") && mname.length() >= 4 || mname.startsWith("is") && mname.length() >= 3) && (numParams = Signature.getParameterCount((String)(sig = m.getSignature()))) == 0) {
                        getters.add(m);
                    }
                    ++n2;
                }
                return getters;
            }
        }
        catch (Exception e) {
            BootActivator.log((Throwable)e);
        }
        return null;
    }

    private boolean isStatic(IMethod m) {
        try {
            return Flags.isStatic((int)m.getFlags());
        }
        catch (JavaModelException e) {
            BootActivator.log((Throwable)e);
            return false;
        }
    }

    private boolean isPublic(IMethod m) {
        try {
            return m.getDeclaringType().isInterface() || Flags.isPublic((int)m.getFlags());
        }
        catch (JavaModelException e) {
            BootActivator.log((Throwable)e);
            return true;
        }
    }

    public Map<String, TypedProperty> getPropertiesMap(Type type, EnumCaseMode enumMode, BeanPropertyNameMode beanMode) {
        List<TypedProperty> list = this.getProperties(type, enumMode, beanMode);
        if (list != null) {
            HashMap<String, TypedProperty> map = new HashMap<String, TypedProperty>();
            for (TypedProperty p : list) {
                map.put(p.getName(), p);
            }
            return map;
        }
        return null;
    }

    public IJavaProject getJavaProject() {
        return this.javaProject;
    }

    public IField getField(Type beanType, String propName) {
        IType type = this.findType(beanType);
        return this.getExactField(type, propName);
    }

    protected IField getExactField(IType type, String fieldName) {
        IField f = type.getField(StringUtil.hyphensToCamelCase((String)fieldName, (boolean)false));
        if (f != null && f.exists()) {
            return f;
        }
        return null;
    }

    public IField getEnumConstant(Type enumType, String propName) {
        IType type = this.findType(enumType);
        IField f = this.getExactField(type, propName);
        if (f != null) {
            return f;
        }
        String fieldName = StringUtil.hyphensToUpperCase((String)propName);
        return this.getExactField(type, fieldName);
    }

    public IMethod getSetter(Type beanType, String propName) {
        try {
            String setterName = "set" + StringUtil.hyphensToCamelCase((String)propName, (boolean)true);
            IType type = this.findType(beanType);
            IMethod[] iMethodArray = type.getMethods();
            int n = iMethodArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMethod m = iMethodArray[n2];
                if (setterName.equals(m.getElementName())) {
                    return m;
                }
                ++n2;
            }
        }
        catch (Exception e) {
            BootActivator.log((Throwable)e);
        }
        return null;
    }

    public IJavaElement getGetter(Type beanType, String propName) {
        String getterName = "get" + StringUtil.hyphensToCamelCase((String)propName, (boolean)true);
        IType type = this.findType(beanType);
        IMethod m = type.getMethod(getterName, NO_PARAMS);
        if (m.exists()) {
            return m;
        }
        return null;
    }

    public static String deprecatedPropertyMessage(String name, String contextType, String replace, String reason) {
        StringBuilder msg = new StringBuilder("Property '" + name + "'");
        if (StringUtil.hasText((String)contextType)) {
            msg.append(" of type '" + contextType + "'");
        }
        boolean hasReplace = StringUtil.hasText((String)replace);
        boolean hasReason = StringUtil.hasText((String)reason);
        if (!hasReplace && !hasReason) {
            msg.append(" is Deprecated!");
        } else {
            msg.append(" is Deprecated: ");
            if (hasReplace) {
                msg.append("Use '" + replace + "' instead.");
                if (hasReason) {
                    msg.append(" Reason: ");
                }
            }
            if (hasReason) {
                msg.append(reason);
            }
        }
        return msg.toString();
    }

    public Collection<StsValueHint> getHintValues(Type type, String query, EnumCaseMode enumCaseMode) {
        if (type != null) {
            Collection<StsValueHint> allowed = this.getAllowedValues(type, enumCaseMode);
            if (allowed != null) {
                return allowed;
            }
            ValueProviderRegistry.ValueProviderStrategy valueHinter = VALUE_HINTERS.get(type.getErasure());
            if (valueHinter != null) {
                return valueHinter.getValuesNow(this.javaProject, query);
            }
        }
        return null;
    }

    public static int getDimensionality(Type type) {
        int dim = 0;
        while (TypeUtil.isSequencable(type) || TypeUtil.isMap(type)) {
            ++dim;
            type = TypeUtil.getDomainType(type);
        }
        return dim;
    }

    public static boolean isClass(Type type) {
        if (type != null) {
            return CLASS_TYPE_NAME.equals(type.getErasure());
        }
        return false;
    }

    public static enum BeanPropertyNameMode {
        HYPHENATED(true, false),
        CAMEL_CASE(false, true),
        ALIASED(true, true);

        private final boolean includesHyphenated;
        private final boolean includesCamelCase;

        private BeanPropertyNameMode(boolean hyphenated, boolean camelCase) {
            this.includesCamelCase = camelCase;
            this.includesHyphenated = hyphenated;
        }

        public boolean includesHyphenated() {
            return this.includesHyphenated;
        }

        public boolean includesCamelCase() {
            return this.includesCamelCase;
        }
    }

    public static enum EnumCaseMode {
        LOWER_CASE,
        ORIGNAL,
        ALIASED;

    }

    private static abstract class RadixableParser
    implements ValueParser {
        private RadixableParser() {
        }

        protected abstract Object parse(String var1, int var2);

        public Object parse(String str) {
            if (str.startsWith("0")) {
                if (str.startsWith("0x") || str.startsWith("0X")) {
                    return this.parse(str.substring(2), 16);
                }
                if (str.startsWith("0b") || str.startsWith("0B")) {
                    return this.parse(str.substring(2), 2);
                }
                return this.parse(str, 8);
            }
            return this.parse(str, 10);
        }
    }
}

