/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.properties.editor.util;

import javax.inject.Provider;
import org.springframework.boot.configurationmetadata.Deprecation;
import org.springframework.ide.eclipse.boot.properties.editor.util.Type;
import org.springframework.ide.eclipse.editor.support.hover.DescriptionProviders;
import org.springframework.ide.eclipse.editor.support.util.HtmlSnippet;
import org.springframework.ide.eclipse.editor.support.yaml.schema.YTypedProperty;

public class TypedProperty
implements YTypedProperty {
    private final String name;
    private final Type type;
    private final Provider<HtmlSnippet> descriptionProvider;
    private final Deprecation deprecation;

    public TypedProperty(String name, Type type, Deprecation deprecation) {
        this(name, type, (Provider<HtmlSnippet>)DescriptionProviders.NO_DESCRIPTION, deprecation);
    }

    public TypedProperty(String name, Type type, Provider<HtmlSnippet> descriptionProvider, Deprecation deprecation) {
        this.name = name;
        this.type = type;
        this.descriptionProvider = descriptionProvider;
        this.deprecation = deprecation;
    }

    public String getName() {
        return this.name;
    }

    public Type getType() {
        return this.type;
    }

    public String toString() {
        return String.valueOf(this.name) + "::" + this.type;
    }

    public HtmlSnippet getDescription() {
        return (HtmlSnippet)this.descriptionProvider.get();
    }

    public static Type typeOf(TypedProperty typedProperty) {
        if (typedProperty != null) {
            return typedProperty.getType();
        }
        return null;
    }

    public boolean isDeprecated() {
        return this.deprecation != null;
    }

    public String getDeprecationReplacement() {
        if (this.deprecation != null) {
            return this.deprecation.getReplacement();
        }
        return null;
    }

    public String getDeprecationReason() {
        if (this.deprecation != null) {
            return this.deprecation.getReason();
        }
        return null;
    }

    public Deprecation getDeprecation() {
        return this.deprecation;
    }
}

