/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.livegraph;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.springframework.ide.eclipse.beans.ui.livegraph.LiveGraphUiPlugin;

public class LiveGraphUIImages {
    private static final String ICON_PATH_PREFIX = "icons/full/";
    private static final String NAME_PREFIX = "org.springframework.ide.eclipse.beans.ui.livegraph.";
    private static final int NAME_PREFIX_LENGTH = "org.springframework.ide.eclipse.beans.ui.livegraph.".length();
    private static URL ICON_BASE_URL = null;
    private static Map<String, ImageDescriptor> imageDescriptors;
    public static final String IMG_OBJS_BEAN = "org.springframework.ide.eclipse.beans.ui.livegraph.bean_obj.gif";
    public static final String IMG_OBJS_BEAN_REF = "org.springframework.ide.eclipse.beans.ui.livegraph.beanref_obj.gif";
    public static final String IMG_OBJS_CONFIG = "org.springframework.ide.eclipse.beans.ui.livegraph.config_obj.gif";
    public static final String IMG_OBJS_COLLECTION = "org.springframework.ide.eclipse.beans.ui.livegraph.collection_obj.gif";
    public static final String IMG_OBJS_REFRESH = "org.springframework.ide.eclipse.beans.ui.livegraph.refresh_obj.gif";
    private static final String OBJECT = "obj16/";
    public static final ImageDescriptor DESC_OBJS_BEAN_REF;
    public static final ImageDescriptor DESC_OBJS_COLLECTION;
    public static final ImageDescriptor DESC_OBJS_BEAN;
    public static final ImageDescriptor DESC_OBJS_CONFIG;
    public static final ImageDescriptor REFRESH;

    static {
        try {
            ICON_BASE_URL = new URL(LiveGraphUiPlugin.getDefault().getBundle().getEntry("/"), ICON_PATH_PREFIX);
        }
        catch (MalformedURLException e) {
            LiveGraphUiPlugin.log(e);
        }
        DESC_OBJS_BEAN_REF = LiveGraphUIImages.createManaged(OBJECT, IMG_OBJS_BEAN_REF);
        DESC_OBJS_COLLECTION = LiveGraphUIImages.createManaged(OBJECT, IMG_OBJS_COLLECTION);
        DESC_OBJS_BEAN = LiveGraphUIImages.createManaged(OBJECT, IMG_OBJS_BEAN);
        DESC_OBJS_CONFIG = LiveGraphUIImages.createManaged(OBJECT, IMG_OBJS_CONFIG);
        REFRESH = LiveGraphUIImages.createManaged(OBJECT, IMG_OBJS_REFRESH);
    }

    static void initializeImageRegistry(ImageRegistry registry) {
        for (String key : imageDescriptors.keySet()) {
            registry.put(key, imageDescriptors.get(key));
        }
    }

    public static Image getImage(String key) {
        return LiveGraphUiPlugin.getDefault().getImageRegistry().get(key);
    }

    private static ImageDescriptor createManaged(String prefix, String name) {
        try {
            ImageDescriptor result = ImageDescriptor.createFromURL((URL)LiveGraphUIImages.makeIconFileURL(prefix, name.substring(NAME_PREFIX_LENGTH)));
            if (imageDescriptors == null) {
                imageDescriptors = new HashMap<String, ImageDescriptor>();
            }
            imageDescriptors.put(name, result);
            return result;
        }
        catch (MalformedURLException e) {
            LiveGraphUiPlugin.log(e);
            return ImageDescriptor.getMissingImageDescriptor();
        }
    }

    private static URL makeIconFileURL(String prefix, String name) throws MalformedURLException {
        if (ICON_BASE_URL == null) {
            throw new MalformedURLException();
        }
        StringBuffer buffer = new StringBuffer(prefix);
        buffer.append('/').append(name);
        return new URL(ICON_BASE_URL, buffer.toString());
    }
}

