/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.beans.ui.search.internal.queries;

import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.springframework.ide.eclipse.beans.core.model.IBean;
import org.springframework.ide.eclipse.beans.core.model.IBeanProperty;
import org.springframework.ide.eclipse.beans.ui.search.internal.BeansSearchMessages;
import org.springframework.ide.eclipse.beans.ui.search.internal.BeansSearchScope;
import org.springframework.ide.eclipse.beans.ui.search.internal.queries.AbstractBeansQuery;
import org.springframework.ide.eclipse.core.MessageUtils;
import org.springframework.ide.eclipse.core.model.IModelElement;

public class BeanPropertyQuery
extends AbstractBeansQuery {
    public BeanPropertyQuery(BeansSearchScope scope, String pattern, boolean isCaseSensitive, boolean isRegexSearch) {
        super(scope, pattern, isCaseSensitive, isRegexSearch);
    }

    public String getLabel() {
        Object[] args = new Object[]{this.getPattern(), this.getScope().getDescription()};
        return MessageUtils.format((String)BeansSearchMessages.SearchQuery_searchFor_property, (Object[])args);
    }

    @Override
    protected boolean doesMatch(IModelElement element, Pattern pattern, IProgressMonitor monitor) {
        if (element instanceof IBean) {
            for (IBeanProperty property : ((IBean)element).getProperties()) {
                if (!pattern.matcher(property.getElementName()).matches()) continue;
                return true;
            }
        }
        return false;
    }
}

