/*
 * Decompiled with CFR 0.152.
 */
package org.apache.subversion.javahl;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.subversion.javahl.ClientException;
import org.apache.subversion.javahl.SubversionException;
import org.apache.subversion.javahl.callback.AuthnCallback;
import org.apache.subversion.javahl.types.ExternalItem;
import org.apache.subversion.javahl.types.NodeKind;
import org.apache.subversion.javahl.util.ConfigLib;
import org.apache.subversion.javahl.util.DiffLib;
import org.apache.subversion.javahl.util.PropLib;
import org.apache.subversion.javahl.util.SubstLib;

public class SVNUtil {
    private static final ConfigLib configLib = new ConfigLib();
    private static final DiffLib diffLib = new DiffLib();
    private static final PropLib propLib = new PropLib();
    private static final SubstLib substLib = new SubstLib();
    public static final byte[] EOL_LF = SubstLib.EOL_LF;
    public static final byte[] EOL_CR = SubstLib.EOL_CR;
    public static final byte[] EOL_CRLF = SubstLib.EOL_CRLF;

    public static void enableNativeCredentialsStore() throws ClientException {
        configLib.enableNativeCredentialsStore();
    }

    public static void disableNativeCredentialsStore() throws ClientException {
        configLib.disableNativeCredentialsStore();
    }

    public static boolean isNativeCredentialsStoreEnabled() throws ClientException {
        return configLib.isNativeCredentialsStoreEnabled();
    }

    public static Credential getCredential(String configDir, Credential.Kind kind, String realm) throws ClientException, SubversionException {
        return configLib.getCredential(configDir, kind, realm);
    }

    public static Credential removeCredential(String configDir, Credential.Kind kind, String realm) throws ClientException, SubversionException {
        return configLib.removeCredential(configDir, kind, realm);
    }

    public static List<Credential> searchCredentials(String configDir, Credential.Kind kind, String realmPattern, String usernamePattern, String hostnamePattern, String textPattern) throws ClientException, SubversionException {
        return configLib.searchCredentials(configDir, kind, realmPattern, usernamePattern, hostnamePattern, textPattern);
    }

    public static boolean fileDiff(String originalFile, String modifiedFile, DiffOptions diffOptions, String originalHeader, String modifiedHeader, String headerEncoding, String relativeToDir, OutputStream resultStream) throws ClientException {
        return diffLib.fileDiff(originalFile, modifiedFile, diffOptions, originalHeader, modifiedHeader, headerEncoding, relativeToDir, resultStream);
    }

    public static boolean fileMerge(String originalFile, String modifiedFile, String latestFile, DiffOptions diffOptions, String conflictOriginal, String conflictModified, String conflictLatest, String conflictSeparator, ConflictDisplayStyle conflictStyle, OutputStream resultStream) throws ClientException {
        return diffLib.fileMerge(originalFile, modifiedFile, latestFile, diffOptions, conflictOriginal, conflictModified, conflictLatest, conflictSeparator, conflictStyle, resultStream);
    }

    public static byte[] canonicalizeNodeProperty(String name, byte[] value, String path, NodeKind kind, String mimeType) throws ClientException {
        return propLib.canonicalizeNodeProperty(name, value, path, kind, mimeType, null);
    }

    public static byte[] canonicalizeNodeProperty(String name, byte[] value, String path, NodeKind kind, String mimeType, InputStream fileContents) throws ClientException {
        return propLib.canonicalizeNodeProperty(name, value, path, kind, mimeType, fileContents);
    }

    public static List<ExternalItem> parseExternals(byte[] description, String parentDirectory, boolean canonicalizeUrl) throws ClientException {
        return propLib.parseExternals(description, parentDirectory, canonicalizeUrl);
    }

    public static byte[] unparseExternals(List<ExternalItem> items, String parentDirectory) throws SubversionException {
        return propLib.unparseExternals(items, parentDirectory, false);
    }

    public static byte[] unparseExternalsForAncientUnsupportedClients(List<ExternalItem> items, String parentDirectory) throws SubversionException {
        return propLib.unparseExternals(items, parentDirectory, true);
    }

    public static String resolveExternalsUrl(ExternalItem external, String reposRootUrl, String parentDirUrl) throws ClientException {
        return propLib.resolveExternalsUrl(external, reposRootUrl, parentDirUrl);
    }

    public static Map<String, byte[]> buildKeywords(byte[] keywordsValue, long revision, String url, String reposRootUrl, Date date, String author) throws SubversionException, ClientException {
        return substLib.buildKeywords(keywordsValue, revision, url, reposRootUrl, date, author);
    }

    public static InputStream translateStream(InputStream source, byte[] eolMarker, boolean repairEol, Map<String, byte[]> keywords, boolean expandKeywords) throws SubversionException, ClientException {
        return substLib.translateInputStream(source, eolMarker, repairEol, keywords, true, expandKeywords, null, -1L, null, null, null, null);
    }

    public static InputStream translateStream(InputStream source, byte[] eolMarker, boolean repairEol, boolean expandKeywords, byte[] keywordsValue, long revision, String url, String reposRootUrl, Date date, String author) throws SubversionException, ClientException {
        return substLib.translateInputStream(source, eolMarker, repairEol, null, false, expandKeywords, keywordsValue, revision, url, reposRootUrl, date, author);
    }

    public static OutputStream translateStream(OutputStream destination, byte[] eolMarker, boolean repairEol, Map<String, byte[]> keywords, boolean expandKeywords) throws SubversionException, ClientException {
        return substLib.translateOutputStream(destination, eolMarker, repairEol, keywords, true, expandKeywords, null, -1L, null, null, null, null);
    }

    public static OutputStream translateStream(OutputStream destination, byte[] eolMarker, boolean repairEol, boolean expandKeywords, byte[] keywordsValue, long revision, String url, String reposRootUrl, Date date, String author) throws SubversionException, ClientException {
        return substLib.translateOutputStream(destination, eolMarker, repairEol, null, false, expandKeywords, keywordsValue, revision, url, reposRootUrl, date, author);
    }

    public static class CredentialTypeMismatch
    extends SubversionException {
        private static final long serialVersionUID = 1L;

        public CredentialTypeMismatch(Credential.Kind kind, String attribute) {
            super("Credential type '" + kind.toString() + "'  does not have the attribute '" + attribute + "'");
        }
    }

    public static class Credential
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private Kind kind;
        private String realm;
        private String store;
        private String username;
        private String password;
        private AuthnCallback.SSLServerCertInfo info;
        private AuthnCallback.SSLServerCertFailures failures;
        private String passphrase;

        public Kind getKind() {
            return this.kind;
        }

        public String getRealm() {
            return this.realm;
        }

        public String getSecureStore() throws CredentialTypeMismatch {
            if (this.kind != Kind.simple && this.kind != Kind.sslClientPassphrase) {
                throw new CredentialTypeMismatch(this.kind, "secure store");
            }
            return this.store;
        }

        public String getUsername() throws CredentialTypeMismatch {
            if (this.kind != Kind.username && this.kind != Kind.simple) {
                throw new CredentialTypeMismatch(this.kind, "username");
            }
            return this.username;
        }

        public String getPassword() throws CredentialTypeMismatch {
            if (this.kind != Kind.simple && this.kind != Kind.sslClientPassphrase) {
                throw new CredentialTypeMismatch(this.kind, "password");
            }
            return this.password;
        }

        public AuthnCallback.SSLServerCertInfo getServerCertInfo() throws CredentialTypeMismatch {
            if (this.kind != Kind.sslServer) {
                throw new CredentialTypeMismatch(this.kind, "server cert info");
            }
            return this.info;
        }

        public AuthnCallback.SSLServerCertFailures getServerCertFailures() throws CredentialTypeMismatch {
            if (this.kind != Kind.sslServer) {
                throw new CredentialTypeMismatch(this.kind, "server cert failures");
            }
            return this.failures;
        }

        public String getClientCertPassphrase() throws CredentialTypeMismatch {
            if (this.kind != Kind.sslClientPassphrase) {
                throw new CredentialTypeMismatch(this.kind, "passphrase");
            }
            return this.passphrase;
        }

        private Credential(Kind kind, String realm, String store, String username, String password, AuthnCallback.SSLServerCertInfo info, AuthnCallback.SSLServerCertFailures failures, String passphrase) {
            assert (kind != null && realm != null);
            switch (kind) {
                case username: {
                    assert (username != null && password == null && info == null && failures == null && passphrase == null);
                    break;
                }
                case simple: {
                    assert (username != null && password != null && info == null && failures == null && passphrase == null);
                    break;
                }
                case sslServer: {
                    assert (username == null && password == null && info != null && failures != null && passphrase == null);
                    break;
                }
                case sslClientPassphrase: {
                    assert (username == null && password == null && info == null && failures == null && passphrase != null);
                    break;
                }
                default: {
                    assert (kind == Kind.username || kind == Kind.simple || kind == Kind.sslServer || kind == Kind.sslClientPassphrase);
                    break;
                }
            }
            this.kind = kind;
            this.realm = realm;
            this.store = store;
            this.username = username;
            this.password = password;
            this.info = info;
            this.failures = failures;
            this.passphrase = passphrase;
        }

        public static enum Kind {
            username("svn.username"),
            simple("svn.simple"),
            sslServer("svn.ssl.server"),
            sslClientPassphrase("svn.ssl.client-passphrase");

            private String token;

            private Kind(String token) {
                this.token = token;
            }

            public String toString() {
                return this.token;
            }

            private static Kind fromString(String stringrep) {
                Kind[] kindArray = Kind.values();
                int n = 0;
                int n2 = kindArray.length;
                while (n < n2) {
                    Kind kind = kindArray[n];
                    if (kind.toString().equals(stringrep)) {
                        return kind;
                    }
                    ++n;
                }
                return null;
            }
        }
    }

    public static class DiffOptions {
        public final IgnoreSpace ignoreSpace;
        public final boolean ignoreEolStyle;
        public final boolean showCFunction;
        public final int contextSize;

        public DiffOptions(IgnoreSpace ignoreSpace, boolean ignoreEolStyle, boolean showCFunction) {
            this.ignoreSpace = ignoreSpace;
            this.ignoreEolStyle = ignoreEolStyle;
            this.showCFunction = showCFunction;
            this.contextSize = -1;
        }

        public DiffOptions(IgnoreSpace ignoreSpace, boolean ignoreEolStyle, boolean showCFunction, int contextSize) {
            this.ignoreSpace = ignoreSpace;
            this.ignoreEolStyle = ignoreEolStyle;
            this.showCFunction = showCFunction;
            this.contextSize = contextSize;
        }

        public static enum IgnoreSpace {
            none,
            change,
            all;

        }
    }

    public static enum ConflictDisplayStyle {
        modified_latest,
        resolved_modified_latest,
        modified_original_latest,
        modified,
        latest,
        only_conflicts;

    }
}

