/*
 * Decompiled with CFR 0.152.
 */
package org.apache.subversion.javahl.types;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;

public class Revision
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected Kind revKind;
    public static final Revision HEAD = new Revision(Kind.head);
    public static final Revision START;
    public static final Revision UNSPECIFIED;
    public static final Revision COMMITTED;
    public static final Revision PREVIOUS;
    public static final Revision BASE;
    public static final Revision WORKING;
    public static final int SVN_INVALID_REVNUM = -1;

    static {
        UNSPECIFIED = START = new Revision(Kind.unspecified);
        COMMITTED = new Revision(Kind.committed);
        PREVIOUS = new Revision(Kind.previous);
        BASE = new Revision(Kind.base);
        WORKING = new Revision(Kind.working);
    }

    public Revision(Kind kind) {
        if (kind.ordinal() < Kind.unspecified.ordinal() || kind.ordinal() > Kind.head.ordinal()) {
            throw new IllegalArgumentException((Object)((Object)kind) + " is not a legal revision kind");
        }
        this.revKind = kind;
    }

    public Kind getKind() {
        return this.revKind;
    }

    public String toString() {
        switch (this.revKind) {
            case base: {
                return "BASE";
            }
            case committed: {
                return "COMMITTED";
            }
            case head: {
                return "HEAD";
            }
            case previous: {
                return "PREV";
            }
            case working: {
                return "WORKING";
            }
            case unspecified: {
                return "UNSPECIFIED";
            }
        }
        return super.toString();
    }

    public int hashCode() {
        return this.revKind.ordinal() * -1;
    }

    public boolean equals(Object target) {
        if (this == target) {
            return true;
        }
        if (!(target instanceof Revision)) {
            return false;
        }
        return ((Revision)target).revKind == this.revKind;
    }

    public static Revision getInstance(long revisionNumber) {
        return new Number(revisionNumber);
    }

    static Number createNumber(long revNumber) {
        return revNumber < 0L ? null : new Number(revNumber);
    }

    public static Revision getInstance(Date revisionDate) {
        return new DateSpec(revisionDate);
    }

    public static class Number
    extends Revision {
        private static final long serialVersionUID = 1L;
        protected long revNumber;

        public Number(long number) {
            super(Kind.number);
            if (number < 0L) {
                throw new IllegalArgumentException("Invalid (negative) revision number: " + number);
            }
            this.revNumber = number;
        }

        public long getNumber() {
            return this.revNumber;
        }

        @Override
        public String toString() {
            return Long.toString(this.revNumber);
        }

        @Override
        public boolean equals(Object target) {
            if (!super.equals(target)) {
                return false;
            }
            return ((Number)target).revNumber == this.revNumber;
        }

        @Override
        public int hashCode() {
            return (int)(this.revNumber ^ this.revNumber >>> 32);
        }
    }

    public static class DateSpec
    extends Revision {
        private static final long serialVersionUID = 1L;
        protected Date revDate;

        public DateSpec(Date date) {
            super(Kind.date);
            if (date == null) {
                throw new IllegalArgumentException("a date must be specified");
            }
            this.revDate = date;
        }

        private DateSpec(long milliseconds) {
            this(new Date(milliseconds));
        }

        public Date getDate() {
            return this.revDate;
        }

        @Override
        public String toString() {
            SimpleDateFormat dateFormat = new SimpleDateFormat("EEE, d MMM yyyy HH:mm:ss Z", Locale.US);
            return String.valueOf('{') + dateFormat.format(this.revDate) + '}';
        }

        @Override
        public boolean equals(Object target) {
            if (!super.equals(target)) {
                return false;
            }
            return ((DateSpec)target).revDate.equals(this.revDate);
        }

        @Override
        public int hashCode() {
            return this.revDate.hashCode();
        }
    }

    public static enum Kind {
        unspecified,
        number,
        date,
        committed,
        previous,
        base,
        working,
        head;

    }
}

