/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter.javahl;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.subversion.javahl.ClientException;
import org.apache.subversion.javahl.ConflictResult;
import org.apache.subversion.javahl.ISVNClient;
import org.apache.subversion.javahl.SubversionException;
import org.apache.subversion.javahl.callback.DiffSummaryCallback;
import org.apache.subversion.javahl.callback.ListCallback;
import org.apache.subversion.javahl.callback.StatusCallback;
import org.apache.subversion.javahl.callback.UserPasswordCallback;
import org.apache.subversion.javahl.types.CopySource;
import org.apache.subversion.javahl.types.Depth;
import org.apache.subversion.javahl.types.DirEntry;
import org.apache.subversion.javahl.types.Lock;
import org.apache.subversion.javahl.types.Mergeinfo;
import org.apache.subversion.javahl.types.NodeKind;
import org.apache.subversion.javahl.types.Revision;
import org.apache.subversion.javahl.types.RevisionRange;
import org.apache.subversion.javahl.types.Status;
import org.tigris.subversion.svnclientadapter.AbstractClientAdapter;
import org.tigris.subversion.svnclientadapter.ISVNAnnotations;
import org.tigris.subversion.svnclientadapter.ISVNConflictResolver;
import org.tigris.subversion.svnclientadapter.ISVNDirEntry;
import org.tigris.subversion.svnclientadapter.ISVNDirEntryWithLock;
import org.tigris.subversion.svnclientadapter.ISVNInfo;
import org.tigris.subversion.svnclientadapter.ISVNLogMessage;
import org.tigris.subversion.svnclientadapter.ISVNLogMessageCallback;
import org.tigris.subversion.svnclientadapter.ISVNMergeInfo;
import org.tigris.subversion.svnclientadapter.ISVNNotifyListener;
import org.tigris.subversion.svnclientadapter.ISVNProgressListener;
import org.tigris.subversion.svnclientadapter.ISVNPromptUserPassword;
import org.tigris.subversion.svnclientadapter.ISVNProperty;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.ISVNStatusCallback;
import org.tigris.subversion.svnclientadapter.SVNBaseDir;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNDiffSummary;
import org.tigris.subversion.svnclientadapter.SVNInfoUnversioned;
import org.tigris.subversion.svnclientadapter.SVNLogMessageCallback;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNNotificationHandler;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNRevisionRange;
import org.tigris.subversion.svnclientadapter.SVNScheduleKind;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;
import org.tigris.subversion.svnclientadapter.SVNStatusUnversioned;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import org.tigris.subversion.svnclientadapter.javahl.InheritedJhlProplistCallback;
import org.tigris.subversion.svnclientadapter.javahl.JhlAnnotations;
import org.tigris.subversion.svnclientadapter.javahl.JhlCommitCallback;
import org.tigris.subversion.svnclientadapter.javahl.JhlCommitMessage;
import org.tigris.subversion.svnclientadapter.javahl.JhlConflictResolver;
import org.tigris.subversion.svnclientadapter.javahl.JhlConverter;
import org.tigris.subversion.svnclientadapter.javahl.JhlDiffSummaryReceiver;
import org.tigris.subversion.svnclientadapter.javahl.JhlDirEntry;
import org.tigris.subversion.svnclientadapter.javahl.JhlDirEntryWithLock;
import org.tigris.subversion.svnclientadapter.javahl.JhlInfoCallback;
import org.tigris.subversion.svnclientadapter.javahl.JhlLogMessageCallback;
import org.tigris.subversion.svnclientadapter.javahl.JhlMergeInfo;
import org.tigris.subversion.svnclientadapter.javahl.JhlNotificationHandler;
import org.tigris.subversion.svnclientadapter.javahl.JhlProgressListener;
import org.tigris.subversion.svnclientadapter.javahl.JhlPromptUserPassword;
import org.tigris.subversion.svnclientadapter.javahl.JhlPropertyData;
import org.tigris.subversion.svnclientadapter.javahl.JhlProplistCallback;
import org.tigris.subversion.svnclientadapter.javahl.JhlStatus;
import org.tigris.subversion.svnclientadapter.javahl.JhlStatusCallback;
import org.tigris.subversion.svnclientadapter.javahl.SVNUrlWithPegRevision;
import org.tigris.subversion.svnclientadapter.utils.Messages;

public abstract class AbstractJhlClientAdapter
extends AbstractClientAdapter {
    protected ISVNClient svnClient;
    protected JhlNotificationHandler notificationHandler;
    protected JhlConflictResolver conflictResolver;
    protected JhlProgressListener progressListener;
    private String postCommitError;

    public ISVNClient getSVNClient() {
        return this.svnClient;
    }

    public void addNotifyListener(ISVNNotifyListener listener) {
        this.notificationHandler.add(listener);
    }

    public void removeNotifyListener(ISVNNotifyListener listener) {
        this.notificationHandler.remove(listener);
    }

    public SVNNotificationHandler getNotificationHandler() {
        return this.notificationHandler;
    }

    public void setUsername(String username) {
        this.svnClient.username(username);
    }

    public void setPassword(String password) {
        this.notificationHandler.setCommand(0);
        this.svnClient.password(password);
    }

    public void setPromptUserPassword(UserPasswordCallback prompt) {
        this.svnClient.setPrompt(prompt);
    }

    protected static String fileToSVNPath(File file, boolean canonical) {
        if (file == null) {
            return null;
        }
        if (canonical) {
            try {
                return file.getCanonicalPath().replace('\\', '/');
            }
            catch (IOException iOException) {
                return null;
            }
        }
        return file.getPath().replace('\\', '/');
    }

    public void addFile(File file) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(1);
            this.notificationHandler.logCommandLine("add -N " + file.toString());
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir((File)file));
            this.svnClient.add(AbstractJhlClientAdapter.fileToSVNPath(file, false), Depth.infinity, false, true, true);
        }
        catch (ClientException e) {
            this.notificationHandler.logException(e);
            throw new SVNClientException((Throwable)e);
        }
    }

    public void addDirectory(File file, boolean recurse) throws SVNClientException {
        this.addDirectory(file, recurse, false);
    }

    public void addDirectory(File dir, boolean recurse, boolean force) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(1);
            this.notificationHandler.logCommandLine("add" + (recurse ? "" : " -N") + (force ? " --force" : "") + " " + dir.toString());
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir((File)dir));
            boolean noIgnores = false;
            boolean addParents = true;
            this.svnClient.add(AbstractJhlClientAdapter.fileToSVNPath(dir, false), Depth.infinityOrEmpty(recurse), force, noIgnores, addParents);
        }
        catch (ClientException e) {
            this.notificationHandler.logException(e);
            throw new SVNClientException((Throwable)e);
        }
    }

    public void checkout(SVNUrl moduleName, File destPath, SVNRevision revision, boolean recurse) throws SVNClientException {
        this.checkout(moduleName, destPath, revision, Depth.infinityOrImmediates(recurse).ordinal(), false, true);
    }

    public void checkout(SVNUrl moduleName, File destPath, SVNRevision revision, int depth, boolean ignoreExternals, boolean force) throws SVNClientException {
        try {
            String url = moduleName.toString();
            Depth d = JhlConverter.depth(depth);
            this.notificationHandler.setCommand(2);
            StringBuffer commandLine = new StringBuffer("checkout " + url + " -r " + revision.toString() + this.depthCommandLine(d));
            if (ignoreExternals) {
                commandLine.append(" --ignore-externals");
            }
            if (force) {
                commandLine.append(" --force");
            }
            this.notificationHandler.logCommandLine(commandLine.toString());
            this.notificationHandler.setBaseDir(new File("."));
            this.svnClient.checkout(url, AbstractJhlClientAdapter.fileToSVNPath(destPath, false), JhlConverter.convert(revision), JhlConverter.convert(revision), d, ignoreExternals, force);
        }
        catch (ClientException e) {
            this.notificationHandler.logException(e);
            throw new SVNClientException((Throwable)e);
        }
    }

    public long commit(File[] paths, String message, boolean recurse) throws SVNClientException {
        return this.commit(paths, message, recurse, false);
    }

    public long commit(File[] paths, String message, boolean recurse, boolean keepLocks) throws SVNClientException {
        try {
            this.postCommitError = null;
            String fixedMessage = this.fixSVNString(message);
            if (fixedMessage == null) {
                fixedMessage = "";
            }
            this.notificationHandler.setCommand(3);
            HashSet<String> files = new HashSet<String>(paths.length);
            String commandLine = "commit -m \"" + this.getFirstMessageLine(fixedMessage) + "\"";
            if (!recurse) {
                commandLine = String.valueOf(commandLine) + " -N";
            }
            if (keepLocks) {
                commandLine = String.valueOf(commandLine) + " --no-unlock";
            }
            int i = 0;
            while (i < paths.length) {
                files.add(AbstractJhlClientAdapter.fileToSVNPath(paths[i], false));
                ++i;
            }
            commandLine = this.appendPaths(commandLine, files);
            this.notificationHandler.logCommandLine(commandLine);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir((File[])paths));
            boolean keepChangeLists = false;
            JhlCommitCallback callback = new JhlCommitCallback();
            this.svnClient.commit(files, Depth.infinityOrEmpty(recurse), keepLocks, keepChangeLists, null, null, new JhlCommitMessage(fixedMessage), callback);
            this.postCommitError = callback.getPostCommitError();
            long newRev = callback.getRevision();
            if (newRev > 0L) {
                this.notificationHandler.logCompleted("Committed revision " + newRev + ".");
            }
            return newRev;
        }
        catch (ClientException e) {
            this.notificationHandler.logException(e);
            throw new SVNClientException((Throwable)e);
        }
    }

    public String getPostCommitError() {
        return this.postCommitError;
    }

    public ISVNDirEntry[] getList(SVNUrl url, SVNRevision revision, boolean recurse) throws SVNClientException {
        String target = url.toString();
        return this.list(target, revision, SVNRevision.HEAD, recurse);
    }

    public ISVNDirEntry[] getList(SVNUrl url, SVNRevision revision, SVNRevision pegRevision, boolean recurse) throws SVNClientException {
        String target = url.toString();
        return this.list(target, revision, pegRevision, recurse);
    }

    public ISVNDirEntry[] getList(File path, SVNRevision revision, boolean recurse) throws SVNClientException {
        String target = AbstractJhlClientAdapter.fileToSVNPath(path, false);
        return this.list(target, revision, SVNRevision.HEAD, recurse);
    }

    public ISVNDirEntry[] getList(File path, SVNRevision revision, SVNRevision pegRevision, boolean recurse) throws SVNClientException {
        String target = AbstractJhlClientAdapter.fileToSVNPath(path, false);
        return this.list(target, revision, pegRevision, recurse);
    }

    private ISVNDirEntry[] list(String path, SVNRevision revision, SVNRevision pegRevision, boolean recurse) throws SVNClientException {
        final ArrayList dirEntryList = new ArrayList();
        ListCallback callback = new ListCallback(){

            @Override
            public void doEntry(DirEntry dirent, Lock lock) {
                if (dirent.getPath().length() == 0) {
                    if (dirent.getNodeKind() == NodeKind.file) {
                        String absPath = dirent.getAbsPath();
                        int lastSeparator = absPath.lastIndexOf(47);
                        String path = absPath.substring(lastSeparator, absPath.length());
                        dirent.setPath(path);
                    } else {
                        return;
                    }
                }
                dirEntryList.add(new JhlDirEntry(dirent));
            }
        };
        try {
            this.notificationHandler.setCommand(11);
            String commandLine = "list -r " + revision.toString() + (recurse ? "-R" : "") + " " + path;
            this.notificationHandler.logCommandLine(commandLine);
            this.notificationHandler.setBaseDir(new File("."));
            this.svnClient.list(path, JhlConverter.convert(revision), JhlConverter.convert(pegRevision), Depth.infinityOrImmediates(recurse), -1, false, callback);
        }
        catch (ClientException e) {
            this.notificationHandler.logException(e);
            throw new SVNClientException((Throwable)e);
        }
        ISVNDirEntry[] dirEntries = new ISVNDirEntry[dirEntryList.size()];
        dirEntryList.toArray(dirEntries);
        return dirEntries;
    }

    public ISVNDirEntryWithLock[] getListWithLocks(SVNUrl url, SVNRevision revision, SVNRevision pegRevision, boolean recurse) throws SVNClientException {
        final ArrayList dirEntryList = new ArrayList();
        ListCallback callback = new ListCallback(){

            @Override
            public void doEntry(DirEntry dirent, Lock lock) {
                if (dirent.getPath().length() == 0) {
                    if (dirent.getNodeKind() == NodeKind.file) {
                        String absPath = dirent.getAbsPath();
                        int lastSeparator = absPath.lastIndexOf(47);
                        String path = absPath.substring(lastSeparator, absPath.length());
                        dirent.setPath(path);
                    } else {
                        return;
                    }
                }
                dirEntryList.add(new JhlDirEntryWithLock(dirent, lock));
            }
        };
        try {
            this.notificationHandler.setCommand(11);
            String commandLine = "list -r " + revision.toString() + (recurse ? "-R" : "") + " " + url.toString();
            this.notificationHandler.logCommandLine(commandLine);
            this.notificationHandler.setBaseDir(new File("."));
            this.svnClient.list(url.toString(), JhlConverter.convert(revision), JhlConverter.convert(pegRevision), Depth.infinityOrImmediates(recurse), -1, true, callback);
        }
        catch (ClientException e) {
            this.notificationHandler.logException(e);
            throw new SVNClientException((Throwable)e);
        }
        ISVNDirEntryWithLock[] dirEntries = new ISVNDirEntryWithLock[dirEntryList.size()];
        dirEntryList.toArray(dirEntries);
        return dirEntries;
    }

    public ISVNDirEntry getDirEntry(SVNUrl url, SVNRevision revision) throws SVNClientException {
        ISVNDirEntry[] entries = this.getList(url.getParent(), revision, false);
        String expectedPath = url.getLastPathSegment();
        int i = 0;
        while (i < entries.length) {
            if (entries[i].getPath().equals(expectedPath)) {
                return entries[i];
            }
            ++i;
        }
        return null;
    }

    public ISVNDirEntry getDirEntry(File path, SVNRevision revision) throws SVNClientException {
        ISVNDirEntry[] entries = this.getList(path.getParentFile(), revision, false);
        String expectedPath = path.getName();
        int i = 0;
        while (i < entries.length) {
            if (entries[i].getPath().equals(expectedPath)) {
                return entries[i];
            }
            ++i;
        }
        return null;
    }

    public ISVNStatus getSingleStatus(File path) throws SVNClientException {
        return this.getStatus(new File[]{path})[0];
    }

    public ISVNStatus[] getStatus(File[] path) throws SVNClientException {
        ISVNStatus[] statuses = new ISVNStatus[path.length];
        int i = 0;
        while (i < path.length) {
            ISVNStatus[] s = this.getStatus(path[i], false, true, false, false);
            statuses[i] = s == null || s.length == 0 ? new SVNStatusUnversioned(path[i]) : s[0];
            ++i;
        }
        return statuses;
    }

    public ISVNStatus[] getStatus(File path, boolean descend, boolean getAll) throws SVNClientException {
        return this.getStatus(path, descend, getAll, false);
    }

    public ISVNStatus[] getStatus(File path, boolean descend, boolean getAll, boolean contactServer) throws SVNClientException {
        return this.getStatus(path, descend, getAll, contactServer, false);
    }

    public ISVNStatus[] getStatus(File path, boolean descend, boolean getAll, boolean contactServer, boolean ignoreExternals) throws SVNClientException {
        return this.getStatus(path, descend, getAll, contactServer, ignoreExternals, null);
    }

    public ISVNStatus[] getStatus(File path, boolean descend, boolean getAll, boolean contactServer, boolean ignoreExternals, ISVNStatusCallback callback) throws SVNClientException {
        return this.getStatus(path, descend, getAll, contactServer, ignoreExternals, true, callback);
    }

    public ISVNStatus[] getStatus(File path, boolean descend, boolean getAll, boolean contactServer, boolean ignoreExternals, boolean noIgnore, ISVNStatusCallback callback) throws SVNClientException {
        this.notificationHandler.setCommand(12);
        String filePathSVN = AbstractJhlClientAdapter.fileToSVNPath(path, false);
        Depth depth = Depth.unknownOrImmediates(descend);
        this.notificationHandler.logCommandLine("status" + (contactServer ? " -u" : "") + this.depthCommandLine(depth) + " " + filePathSVN);
        this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir((File)path));
        try {
            StatusCallback statusCallback = callback == null ? new MyStatusCallback() : new JhlStatusCallback(callback);
            this.svnClient.status(filePathSVN, depth, contactServer, getAll, noIgnore, ignoreExternals, null, statusCallback);
            List<Status> statusList = null;
            statusList = statusCallback instanceof MyStatusCallback ? ((MyStatusCallback)statusCallback).getStatusList() : ((JhlStatusCallback)statusCallback).getStatusList();
            return this.processFolderStatuses(this.processExternalStatuses(JhlConverter.convertStatus(statusList, this.svnClient)), getAll, contactServer);
        }
        catch (ClientException e) {
            if (e.getAprError() == 155007 || e.getAprError() == 155010) {
                return new ISVNStatus[]{new SVNStatusUnversioned(path)};
            }
            this.notificationHandler.logException(e);
            throw new SVNClientException((Throwable)e);
        }
    }

    protected JhlStatus[] processExternalStatuses(JhlStatus[] statuses) throws SVNClientException {
        ArrayList<Integer> externalStatusesIndexes = new ArrayList<Integer>();
        int i = 0;
        while (i < statuses.length) {
            if (SVNStatusKind.EXTERNAL.equals((Object)statuses[i].getTextStatus())) {
                externalStatusesIndexes.add(new Integer(i));
            }
            ++i;
        }
        if (externalStatusesIndexes.isEmpty()) {
            return statuses;
        }
        for (Integer integer : externalStatusesIndexes) {
            int index = integer;
            JhlStatus jhlStatus = statuses[index];
            int i2 = 0;
            while (i2 < statuses.length) {
                if (statuses[i2].getPath() != null && statuses[i2].getPath().equals(jhlStatus.getPath())) {
                    statuses[i2] = new JhlStatus.JhlStatusExternal(statuses[i2], this.svnClient);
                    statuses[index] = statuses[i2];
                }
                ++i2;
            }
        }
        return statuses;
    }

    protected ISVNStatus[] processFolderStatuses(JhlStatus[] statuses, boolean getAll, boolean contactServer) throws SVNClientException {
        JhlStatus jhlStatus;
        if (!getAll || !contactServer) {
            return statuses;
        }
        ArrayList<JhlStatus> folders = new ArrayList<JhlStatus>();
        int i = 0;
        while (i < statuses.length) {
            jhlStatus = statuses[i];
            if (SVNNodeKind.DIR == jhlStatus.getNodeKind() && jhlStatus.getReposLastChangedRevision() == null) {
                folders.add(jhlStatus);
            }
            ++i;
        }
        i = 0;
        while (i < statuses.length) {
            jhlStatus = statuses[i];
            if (jhlStatus.getLastChangedRevision() != null) {
                for (JhlStatus folder : folders) {
                    if (jhlStatus.getUrlString() == null || !jhlStatus.getUrlString().startsWith(String.valueOf(folder.getUrlString()) + "/") || folder.getLastChangedRevision() != null && folder.getLastChangedRevision().getNumber() >= jhlStatus.getLastChangedRevision().getNumber()) continue;
                    folder.updateFromStatus(jhlStatus);
                }
            }
            ++i;
        }
        return statuses;
    }

    public void copy(File srcPath, File destPath) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(6);
            String src = AbstractJhlClientAdapter.fileToSVNPath(srcPath, false);
            String dest = AbstractJhlClientAdapter.fileToSVNPath(destPath, false);
            this.notificationHandler.logCommandLine("copy " + src + " " + dest);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir((File[])new File[]{srcPath, destPath}));
            ArrayList<CopySource> copySources = new ArrayList<CopySource>();
            copySources.add(new CopySource(src, Revision.WORKING, Revision.WORKING));
            this.svnClient.copy(copySources, dest, true, true, false, null, null, null);
        }
        catch (ClientException e) {
            this.notificationHandler.logException(e);
            throw new SVNClientException((Throwable)e);
        }
    }

    public void copy(File srcPath, SVNUrl destUrl, String message) throws SVNClientException {
        try {
            String fixedMessage = this.fixSVNString(message);
            if (fixedMessage == null) {
                fixedMessage = "";
            }
            this.notificationHandler.setCommand(6);
            String src = AbstractJhlClientAdapter.fileToSVNPath(srcPath, false);
            String dest = destUrl.toString();
            this.notificationHandler.logCommandLine("copy " + src + " " + dest);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir((File)srcPath));
            ArrayList<CopySource> copySources = new ArrayList<CopySource>();
            copySources.add(new CopySource(src, Revision.WORKING, Revision.WORKING));
            this.svnClient.copy(copySources, dest, true, true, true, null, new JhlCommitMessage(fixedMessage), null);
        }
        catch (ClientException e) {
            this.notificationHandler.logException(e);
            throw new SVNClientException((Throwable)e);
        }
    }

    public void copy(File[] srcPaths, SVNUrl destUrl, String message, boolean copyAsChild, boolean makeParents) throws SVNClientException {
        String fixedMessage = this.fixSVNString(message);
        if (srcPaths.length > 1) {
            this.mkdir(destUrl, makeParents, fixedMessage);
            int i = 0;
            while (i < srcPaths.length) {
                File[] file = new File[]{srcPaths[i]};
                this.copy(file, destUrl, fixedMessage, copyAsChild, makeParents);
                ++i;
            }
            return;
        }
        try {
            if (fixedMessage == null) {
                fixedMessage = "";
            }
            this.notificationHandler.setCommand(6);
            ArrayList<CopySource> copySources = new ArrayList<CopySource>(srcPaths.length);
            int i = 0;
            while (i < srcPaths.length) {
                copySources.add(new CopySource(AbstractJhlClientAdapter.fileToSVNPath(srcPaths[i], false), Revision.WORKING, Revision.WORKING));
                ++i;
            }
            String dest = destUrl.toString();
            String commandLine = "copy";
            HashSet<String> paths = new HashSet<String>(srcPaths.length);
            int i2 = 0;
            while (i2 < srcPaths.length) {
                paths.add(AbstractJhlClientAdapter.fileToSVNPath(srcPaths[i2], false));
                ++i2;
            }
            commandLine = String.valueOf(this.appendPaths(commandLine, paths)) + " " + dest;
            this.notificationHandler.logCommandLine(commandLine.toString());
            this.notificationHandler.setBaseDir();
            this.svnClient.copy(copySources, dest, copyAsChild, makeParents, true, null, new JhlCommitMessage(fixedMessage), null);
        }
        catch (ClientException e) {
            this.notificationHandler.logException(e);
            throw new SVNClientException((Throwable)e);
        }
    }

    public void copy(SVNUrl srcUrl, File destPath, SVNRevision revision) throws SVNClientException {
        this.copy(srcUrl, destPath, revision, true, false);
    }

    public void copy(SVNUrl srcUrl, File destPath, SVNRevision revision, boolean copyAsChild, boolean makeParents) throws SVNClientException {
        this.copy(srcUrl, destPath, revision, SVNRevision.HEAD, copyAsChild, makeParents);
    }

    public void copy(SVNUrl srcUrl, File destPath, SVNRevision revision, SVNRevision pegRevision, boolean copyAsChild, boolean makeParents) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(6);
            String dest = AbstractJhlClientAdapter.fileToSVNPath(destPath, false);
            ArrayList<CopySource> copySources = new ArrayList<CopySource>();
            copySources.add(new CopySource(srcUrl.toString(), JhlConverter.convert(revision), JhlConverter.convert(pegRevision)));
            this.notificationHandler.logCommandLine("copy " + srcUrl + " " + dest);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir((File)destPath));
            this.svnClient.copy(copySources, dest, copyAsChild, makeParents, true, null, null, null);
        }
        catch (ClientException e) {
            this.notificationHandler.logException(e);
            throw new SVNClientException((Throwable)e);
        }
    }

    public void copy(SVNUrl srcUrl, SVNUrl destUrl, String message, SVNRevision revision) throws SVNClientException {
        this.copy(srcUrl, destUrl, message, revision, false);
    }

    public void copy(SVNUrl srcUrl, SVNUrl destUrl, String message, SVNRevision revision, boolean makeParents) throws SVNClientException {
        this.copy(new SVNUrl[]{srcUrl}, destUrl, message, revision, true, makeParents);
    }

    public void copy(SVNUrl[] srcUrls, SVNUrl destUrl, String message, SVNRevision revision, boolean copyAsChild, boolean makeParents) throws SVNClientException {
        try {
            String fixedMessage = this.fixSVNString(message);
            if (fixedMessage == null) {
                fixedMessage = "";
            }
            this.notificationHandler.setCommand(6);
            ArrayList<CopySource> copySources = new ArrayList<CopySource>(srcUrls.length);
            int i = 0;
            while (i < srcUrls.length) {
                copySources.add(new CopySource(srcUrls[i].toString(), JhlConverter.convert(revision), JhlConverter.convert(SVNRevision.HEAD)));
                ++i;
            }
            String dest = destUrl.toString();
            String commandLine = "copy -r" + revision.toString();
            HashSet<String> paths = new HashSet<String>(srcUrls.length);
            int i2 = 0;
            while (i2 < srcUrls.length) {
                paths.add(srcUrls[i2].toString());
                ++i2;
            }
            commandLine = String.valueOf(this.appendPaths(commandLine, paths)) + " " + dest;
            this.notificationHandler.logCommandLine(commandLine);
            this.notificationHandler.setBaseDir();
            this.svnClient.copy(copySources, dest, copyAsChild, makeParents, true, null, new JhlCommitMessage(fixedMessage), null);
        }
        catch (ClientException e) {
            this.notificationHandler.logException(e);
            throw new SVNClientException((Throwable)e);
        }
    }

    public void remove(SVNUrl[] url, String message) throws SVNClientException {
        try {
            String fixedMessage = this.fixSVNString(message);
            if (fixedMessage == null) {
                fixedMessage = "";
            }
            this.notificationHandler.setCommand(7);
            String commandLine = "delete -m \"" + this.getFirstMessageLine(fixedMessage) + "\"";
            HashSet<String> targets = new HashSet<String>(url.length);
            int i = 0;
            while (i < url.length) {
                targets.add(url[i].toString());
                ++i;
            }
            commandLine = this.appendPaths(commandLine, targets);
            this.notificationHandler.logCommandLine(commandLine);
            this.notificationHandler.setBaseDir();
            this.svnClient.remove(targets, false, false, null, new JhlCommitMessage(fixedMessage), null);
        }
        catch (ClientException e) {
            this.notificationHandler.logException(e);
            throw new SVNClientException((Throwable)e);
        }
    }

    public void remove(File[] file, boolean force) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(7);
            String commandLine = "delete" + (force ? " --force" : "");
            HashSet<String> targets = new HashSet<String>(file.length);
            int i = 0;
            while (i < file.length) {
                targets.add(AbstractJhlClientAdapter.fileToSVNPath(file[i], false));
                ++i;
            }
            commandLine = this.appendPaths(commandLine, targets);
            this.notificationHandler.logCommandLine(commandLine);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir((File[])file));
            this.svnClient.remove(targets, force, false, null, null, null);
        }
        catch (ClientException e) {
            this.notificationHandler.logException(e);
            throw new SVNClientException((Throwable)e);
        }
    }

    public void doExport(SVNUrl srcUrl, File destPath, SVNRevision revision, boolean force) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(8);
            String src = srcUrl.toString();
            String dest = AbstractJhlClientAdapter.fileToSVNPath(destPath, false);
            this.notificationHandler.logCommandLine("export -r " + revision.toString() + ' ' + src + ' ' + dest);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir((File)destPath));
            this.svnClient.doExport(src, dest, JhlConverter.convert(revision), Revision.HEAD, force, false, Depth.infinity, null);
        }
        catch (ClientException e) {
            this.notificationHandler.logException(e);
            throw new SVNClientException((Throwable)e);
        }
    }

    public void doExport(File srcPath, File destPath, boolean force) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(8);
            String src = AbstractJhlClientAdapter.fileToSVNPath(srcPath, false);
            String dest = AbstractJhlClientAdapter.fileToSVNPath(destPath, false);
            this.notificationHandler.logCommandLine("export " + src + ' ' + dest);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir((File[])new File[]{srcPath, destPath}));
            this.svnClient.doExport(src, dest, Revision.WORKING, Revision.BASE, force, false, Depth.infinity, null);
        }
        catch (ClientException e) {
            this.notificationHandler.logException(e);
            throw new SVNClientException((Throwable)e);
        }
    }

    public void doImport(File path, SVNUrl url, String message, boolean recurse) throws SVNClientException {
        try {
            String fixedMessage = this.fixSVNString(message);
            if (fixedMessage == null) {
                fixedMessage = "";
            }
            this.notificationHandler.setCommand(9);
            String src = AbstractJhlClientAdapter.fileToSVNPath(path, false);
            String dest = url.toString();
            this.notificationHandler.logCommandLine("import -m \"" + this.getFirstMessageLine(fixedMessage) + "\" " + (recurse ? "" : "-N ") + src + ' ' + dest);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir((File)path));
            this.svnClient.doImport(src, dest, Depth.infinityOrEmpty(recurse), false, true, null, new JhlCommitMessage(fixedMessage), null);
            this.notificationHandler.logCompleted(Messages.bind((String)"notify.import.complete"));
        }
        catch (ClientException e) {
            this.notificationHandler.logException(e);
            throw new SVNClientException((Throwable)e);
        }
    }

    public void mkdir(SVNUrl url, String message) throws SVNClientException {
        this.mkdir(url, false, message);
    }

    public void mkdir(File file) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(10);
            HashSet<String> target = new HashSet<String>();
            target.add(AbstractJhlClientAdapter.fileToSVNPath(file, false));
            this.notificationHandler.logCommandLine("mkdir " + target);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir((File)file));
            this.svnClient.mkdir(target, false, null, null, null);
        }
        catch (ClientException e) {
            this.notificationHandler.logException(e);
            throw new SVNClientException((Throwable)e);
        }
    }

    public void move(File srcPath, File destPath, boolean force) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(5);
            HashSet<String> src = new HashSet<String>();
            src.add(AbstractJhlClientAdapter.fileToSVNPath(srcPath, false));
            String dest = AbstractJhlClientAdapter.fileToSVNPath(destPath, false);
            this.notificationHandler.logCommandLine("move " + AbstractJhlClientAdapter.fileToSVNPath(srcPath, false) + ' ' + dest);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir((File[])new File[]{srcPath, destPath}));
            this.svnClient.move(src, dest, force, false, false, null, null, null);
        }
        catch (ClientException e) {
            this.notificationHandler.logException(e);
            throw new SVNClientException((Throwable)e);
        }
    }

    public void move(SVNUrl srcUrl, SVNUrl destUrl, String message, SVNRevision revision) throws SVNClientException {
        try {
            String fixedMessage = this.fixSVNString(message);
            if (fixedMessage == null) {
                fixedMessage = "";
            }
            this.notificationHandler.setCommand(5);
            HashSet<String> src = new HashSet<String>();
            src.add(srcUrl.toString());
            String dest = destUrl.toString();
            this.notificationHandler.logCommandLine("move -m \"" + this.getFirstMessageLine(fixedMessage) + ' ' + srcUrl.toString() + ' ' + dest);
            this.notificationHandler.setBaseDir();
            this.svnClient.move(src, dest, false, false, false, null, new JhlCommitMessage(fixedMessage), null);
        }
        catch (ClientException e) {
            this.notificationHandler.logException(e);
            throw new SVNClientException((Throwable)e);
        }
    }

    public long update(File path, SVNRevision revision, boolean recurse) throws SVNClientException {
        return this.update(path, revision, Depth.unknownOrFiles(recurse).ordinal(), false, false, true);
    }

    public long update(File path, SVNRevision revision, int depth, boolean setDepth, boolean ignoreExternals, boolean force) throws SVNClientException {
        try {
            StringBuffer commandLine;
            this.notificationHandler.setCommand(4);
            HashSet<String> target = new HashSet<String>();
            String t = AbstractJhlClientAdapter.fileToSVNPath(path, false);
            target.add(t);
            Depth d = JhlConverter.depth(depth);
            if (d == Depth.exclude) {
                commandLine = new StringBuffer("update " + t + " --set-depth=exclude");
            } else {
                commandLine = new StringBuffer("update " + t + " -r " + revision.toString() + this.depthCommandLine(d));
                if (ignoreExternals) {
                    commandLine.append(" --ignore-externals");
                }
                if (force) {
                    commandLine.append(" --force");
                }
            }
            this.notificationHandler.logCommandLine(commandLine.toString());
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir((File)path));
            boolean makeParents = false;
            long[] rev = this.svnClient.update(target, JhlConverter.convert(revision), d, setDepth, makeParents, ignoreExternals, force);
            return rev[0];
        }
        catch (ClientException e) {
            this.notificationHandler.logException(e);
            throw new SVNClientException((Throwable)e);
        }
    }

    public long[] update(File[] path, SVNRevision revision, boolean recurse, boolean ignoreExternals) throws SVNClientException {
        return this.update(path, revision, Depth.unknownOrFiles(recurse).ordinal(), false, ignoreExternals, true);
    }

    public long[] update(File[] path, SVNRevision revision, int depth, boolean setDepth, boolean ignoreExternals, boolean force) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(4);
            HashSet<String> targets = new HashSet<String>(path.length);
            int i = 0;
            while (i < path.length) {
                targets.add(AbstractJhlClientAdapter.fileToSVNPath(path[i], false));
                ++i;
            }
            Depth d = JhlConverter.depth(depth);
            StringBuffer commandLine = new StringBuffer(String.valueOf(this.appendPaths("update ", targets)) + " -r " + revision.toString() + this.depthCommandLine(d));
            if (ignoreExternals) {
                commandLine.append(" --ignore-externals");
            }
            if (force) {
                commandLine.append(" --force");
            }
            this.notificationHandler.logCommandLine(commandLine.toString());
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir((File[])path));
            this.notificationHandler.holdStats();
            boolean makeParents = false;
            long[] rtnCode = this.svnClient.update(targets, JhlConverter.convert(revision), d, setDepth, makeParents, ignoreExternals, force);
            this.notificationHandler.releaseStats();
            return rtnCode;
        }
        catch (ClientException e) {
            this.notificationHandler.logException(e);
            throw new SVNClientException((Throwable)e);
        }
    }

    public void revert(File path, boolean recurse) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(16);
            String target = AbstractJhlClientAdapter.fileToSVNPath(path, false);
            this.notificationHandler.logCommandLine("revert " + (recurse ? "" : "-N ") + target);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir((File)path));
            this.svnClient.revert(target, Depth.infinityOrEmpty(recurse), null);
        }
        catch (ClientException e) {
            this.notificationHandler.logException(e);
            throw new SVNClientException((Throwable)e);
        }
    }

    public InputStream getContent(SVNUrl url, SVNRevision revision, SVNRevision pegRevision) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(18);
            String commandLine = "cat -r " + revision + " " + url;
            if (pegRevision != null) {
                commandLine = String.valueOf(commandLine) + "@" + pegRevision;
            }
            this.notificationHandler.logCommandLine(commandLine);
            this.notificationHandler.setBaseDir();
            byte[] contents = this.svnClient.fileContent(url.toString(), JhlConverter.convert(revision), JhlConverter.convert(pegRevision));
            ByteArrayInputStream input = new ByteArrayInputStream(contents);
            return input;
        }
        catch (ClientException e) {
            this.notificationHandler.logException(e);
            throw new SVNClientException((Throwable)e);
        }
    }

    public InputStream getContent(SVNUrl url, SVNRevision revision) throws SVNClientException {
        return this.getContent(url, revision, SVNRevision.HEAD);
    }

    public InputStream getContent(File path, SVNRevision revision) throws SVNClientException {
        try {
            ISVNStatus status;
            String target = AbstractJhlClientAdapter.fileToSVNPath(path, false);
            this.notificationHandler.setCommand(18);
            this.notificationHandler.logCommandLine("cat -r " + revision.toString() + " " + target);
            this.notificationHandler.setBaseDir();
            if (revision.equals((Object)SVNRevision.BASE) && (status = this.getSingleStatus(path)).getTextStatus().equals((Object)SVNStatusKind.ADDED)) {
                return new ByteArrayInputStream(new byte[0]);
            }
            byte[] contents = this.svnClient.fileContent(target, JhlConverter.convert(revision), Revision.BASE);
            ByteArrayInputStream input = new ByteArrayInputStream(contents);
            return input;
        }
        catch (ClientException e) {
            this.notificationHandler.logException(e);
            throw new SVNClientException((Throwable)e);
        }
    }

    public ISVNProperty[] getProperties(File path) throws SVNClientException {
        return this.getProperties(path, false);
    }

    public ISVNProperty[] getProperties(File path, boolean descend) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(21);
            String target = AbstractJhlClientAdapter.fileToSVNPath(path, false);
            StringBuffer commandLine = new StringBuffer("propList ");
            if (descend) {
                commandLine.append(" -R ");
            }
            commandLine.append(target);
            this.notificationHandler.logCommandLine(commandLine.toString());
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir((File)path));
            JhlProplistCallback callback = new JhlProplistCallback(true);
            if (descend) {
                this.svnClient.properties(target, null, null, Depth.infinity, null, callback);
            } else {
                this.svnClient.properties(target, null, null, Depth.empty, null, callback);
            }
            return callback.getPropertyData();
        }
        catch (ClientException e) {
            this.notificationHandler.logException(e);
            throw new SVNClientException((Throwable)e);
        }
    }

    public ISVNProperty[] getProperties(SVNUrl url) throws SVNClientException {
        return this.getProperties(url, SVNRevision.HEAD, SVNRevision.HEAD);
    }

    public ISVNProperty[] getProperties(SVNUrl url, SVNRevision revision, SVNRevision pegRevision) throws SVNClientException {
        return this.getProperties(url, revision, pegRevision, true);
    }

    public ISVNProperty[] getProperties(SVNUrl url, SVNRevision revision, SVNRevision pegRevision, boolean recurse) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(21);
            String target = url.toString();
            this.notificationHandler.logCommandLine("proplist " + target);
            this.notificationHandler.setBaseDir();
            JhlProplistCallback callback = new JhlProplistCallback(false);
            Depth depth = recurse ? Depth.infinity : Depth.empty;
            this.svnClient.properties(target, JhlConverter.convert(revision), JhlConverter.convert(pegRevision), depth, null, callback);
            return callback.getPropertyData();
        }
        catch (ClientException e) {
            this.notificationHandler.logException(e);
            throw new SVNClientException((Throwable)e);
        }
    }

    public ISVNProperty[] getPropertiesIncludingInherited(File path, boolean includeEmptyProperties, boolean includeClosestOnly, List<String> filterProperties) throws SVNClientException {
        ISVNProperty[] properties = this.getPropertiesIncludingInherited(AbstractJhlClientAdapter.fileToSVNPath(path, false), true);
        return this.filterProperties(properties, includeEmptyProperties, includeClosestOnly, filterProperties);
    }

    public ISVNProperty[] getPropertiesIncludingInherited(SVNUrl path, boolean includeEmptyProperties, boolean includeClosestOnly, List<String> filterProperties) throws SVNClientException {
        ISVNProperty[] properties = this.getPropertiesIncludingInherited(path.toString(), false);
        return this.filterProperties(properties, includeEmptyProperties, includeClosestOnly, filterProperties);
    }

    private ISVNProperty[] filterProperties(ISVNProperty[] properties, boolean includeEmptyProperties, boolean includeClosestOnly, List<String> filterProperties) {
        ISVNProperty[] propertyArray;
        if (includeEmptyProperties && filterProperties == null) {
            return properties;
        }
        ArrayList<ISVNProperty> allProperties = null;
        HashMap<String, ISVNProperty> propertyMap = null;
        if (includeClosestOnly) {
            propertyMap = new HashMap<String, ISVNProperty>();
        } else {
            allProperties = new ArrayList<ISVNProperty>();
        }
        ISVNProperty[] iSVNPropertyArray = properties;
        int n = 0;
        int n2 = iSVNPropertyArray.length;
        while (n < n2) {
            ISVNProperty property = iSVNPropertyArray[n];
            if (filterProperties == null || filterProperties.contains(property.getName())) {
                if (includeClosestOnly) {
                    propertyMap.put(property.getName(), property);
                } else {
                    allProperties.add(property);
                }
            }
            ++n;
        }
        if (includeClosestOnly) {
            propertyArray = new ISVNProperty[propertyMap.size()];
            propertyMap.values().toArray(propertyArray);
        } else {
            propertyArray = new ISVNProperty[allProperties.size()];
            allProperties.toArray(propertyArray);
        }
        return propertyArray;
    }

    public ISVNProperty[] getPropertiesIncludingInherited(File path) throws SVNClientException {
        return this.getPropertiesIncludingInherited(AbstractJhlClientAdapter.fileToSVNPath(path, false), true);
    }

    public ISVNProperty[] getPropertiesIncludingInherited(SVNUrl path) throws SVNClientException {
        return this.getPropertiesIncludingInherited(path.toString(), false);
    }

    private ISVNProperty[] getPropertiesIncludingInherited(String path, boolean isFile) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(21);
            this.notificationHandler.logCommandLine("proplist " + path);
            this.notificationHandler.setBaseDir();
            InheritedJhlProplistCallback callback = new InheritedJhlProplistCallback(isFile);
            Revision revision = null;
            if (!isFile) {
                revision = JhlConverter.convert(SVNRevision.HEAD);
            }
            this.svnClient.properties(path, revision, revision, Depth.empty, null, callback);
            return callback.getPropertyData();
        }
        catch (ClientException e) {
            this.notificationHandler.logException(e);
            throw new SVNClientException((Throwable)e);
        }
    }

    public void propertySet(SVNUrl url, SVNRevision.Number baseRev, String propertyName, String propertyValue, String message) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(14);
            if (propertyName.startsWith("svn:")) {
                this.svnClient.propertySetRemote(url.toString(), baseRev.getNumber(), propertyName, this.fixSVNString(propertyValue).getBytes(), new JhlCommitMessage(message), false, null, new JhlCommitCallback());
            } else {
                this.svnClient.propertySetRemote(url.toString(), baseRev.getNumber(), propertyName, propertyValue.getBytes(), new JhlCommitMessage(message), false, null, new JhlCommitCallback());
            }
        }
        catch (ClientException e) {
            this.notificationHandler.logException(e);
            throw new SVNClientException((Throwable)e);
        }
    }

    public void propertySet(File path, String propertyName, String propertyValue, boolean recurse) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(14);
            String target = AbstractJhlClientAdapter.fileToSVNPath(path, false);
            this.notificationHandler.logCommandLine("propset " + (recurse ? "-R " : "") + propertyName + " \"" + propertyValue + "\" " + target);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir((File)path));
            HashSet<String> statusBefore = null;
            if (recurse) {
                statusBefore = new HashSet<String>();
                ISVNStatus[] statuses = this.getStatus(path, recurse, false);
                int i = 0;
                while (i < statuses.length) {
                    statusBefore.add(statuses[i].getFile().getAbsolutePath());
                    ++i;
                }
            }
            HashSet<String> paths = new HashSet<String>(1);
            paths.add(target);
            if (propertyName.startsWith("svn:")) {
                this.svnClient.propertySetLocal(paths, propertyName, this.fixSVNString(propertyValue).getBytes(), Depth.infinityOrEmpty(recurse), null, false);
            } else {
                this.svnClient.propertySetLocal(paths, propertyName, propertyValue.getBytes(), Depth.infinityOrEmpty(recurse), null, false);
            }
            if (recurse) {
                ISVNStatus[] statuses = this.getStatus(path, recurse, false);
                int i = 0;
                while (i < statuses.length) {
                    String statusPath = statuses[i].getFile().getAbsolutePath();
                    this.notificationHandler.notifyListenersOfChange(statusPath);
                    statusBefore.remove(statusPath);
                    ++i;
                }
                for (String status : statusBefore) {
                    this.notificationHandler.notifyListenersOfChange(status);
                }
            } else {
                this.notificationHandler.notifyListenersOfChange(path.getAbsolutePath());
            }
        }
        catch (ClientException e) {
            this.notificationHandler.logException(e);
            throw new SVNClientException((Throwable)e);
        }
    }

    public void propertySet(File path, String propertyName, File propertyFile, boolean recurse) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(14);
            String target = AbstractJhlClientAdapter.fileToSVNPath(path, false);
            this.notificationHandler.logCommandLine("propset " + (recurse ? "-R " : "") + propertyName + "-F \"" + propertyFile.toString() + "\" " + target);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir((File)path));
            byte[] propertyBytes = new byte[(int)propertyFile.length()];
            FileInputStream is = null;
            try {
                try {
                    is = new FileInputStream(propertyFile);
                    is.read(propertyBytes);
                }
                catch (IOException ioe) {
                    throw new SVNClientException((Throwable)ioe);
                }
            }
            catch (Throwable throwable) {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
            HashSet<String> statusBefore = null;
            if (recurse) {
                statusBefore = new HashSet<String>();
                ISVNStatus[] statuses = this.getStatus(path, recurse, false);
                int i = 0;
                while (i < statuses.length) {
                    statusBefore.add(statuses[i].getFile().getAbsolutePath());
                    ++i;
                }
            }
            HashSet<String> paths = new HashSet<String>(1);
            paths.add(target);
            this.svnClient.propertySetLocal(paths, propertyName, propertyBytes, Depth.infinityOrEmpty(recurse), null, false);
            if (recurse) {
                ISVNStatus[] statuses = this.getStatus(path, recurse, false);
                int i = 0;
                while (i < statuses.length) {
                    String statusPath = statuses[i].getFile().getAbsolutePath();
                    this.notificationHandler.notifyListenersOfChange(statusPath);
                    statusBefore.remove(statusPath);
                    ++i;
                }
                for (String status : statusBefore) {
                    this.notificationHandler.notifyListenersOfChange(status);
                }
            } else {
                this.notificationHandler.notifyListenersOfChange(path.getAbsolutePath());
            }
        }
        catch (ClientException e) {
            this.notificationHandler.logException(e);
            throw new SVNClientException((Throwable)e);
        }
    }

    public ISVNProperty propertyGet(File path, String propertyName) throws SVNClientException {
        byte[] bytes;
        String target;
        block3: {
            try {
                this.notificationHandler.setCommand(20);
                target = AbstractJhlClientAdapter.fileToSVNPath(path, false);
                this.notificationHandler.logCommandLine("propget " + propertyName + " " + target);
                this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir((File)path));
                bytes = this.svnClient.propertyGet(target, propertyName, null, null);
                if (bytes != null) break block3;
                return null;
            }
            catch (ClientException e) {
                this.notificationHandler.logException(e);
                throw new SVNClientException((Throwable)e);
            }
        }
        return JhlPropertyData.newForFile(target, propertyName, bytes);
    }

    public ISVNProperty propertyGet(SVNUrl url, SVNRevision revision, SVNRevision peg, String propertyName) throws SVNClientException {
        byte[] bytes;
        String target;
        block4: {
            try {
                this.notificationHandler.setCommand(20);
                target = url.toString();
                String commandLine = "propget -r " + revision.toString() + " " + propertyName + " " + target;
                if (!peg.equals((Object)SVNRevision.HEAD)) {
                    commandLine = String.valueOf(commandLine) + "@" + peg.toString();
                }
                this.notificationHandler.logCommandLine(commandLine);
                this.notificationHandler.setBaseDir();
                bytes = this.svnClient.propertyGet(target, propertyName, JhlConverter.convert(revision), JhlConverter.convert(peg));
                if (bytes != null) break block4;
                return null;
            }
            catch (ClientException e) {
                this.notificationHandler.logException(e);
                throw new SVNClientException((Throwable)e);
            }
        }
        return JhlPropertyData.newForUrl(target, propertyName, bytes);
    }

    public void propertyDel(File path, String propertyName, boolean recurse) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(15);
            String target = AbstractJhlClientAdapter.fileToSVNPath(path, false);
            this.notificationHandler.logCommandLine("propdel " + propertyName + " " + target);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir((File)path));
            HashSet<String> statusBefore = null;
            if (recurse) {
                statusBefore = new HashSet<String>();
                ISVNStatus[] statuses = this.getStatus(path, recurse, false);
                int i = 0;
                while (i < statuses.length) {
                    statusBefore.add(statuses[i].getFile().getAbsolutePath());
                    ++i;
                }
            }
            HashSet<String> paths = new HashSet<String>(1);
            paths.add(target);
            this.svnClient.propertySetLocal(paths, propertyName, null, Depth.infinityOrEmpty(recurse), null, true);
            if (recurse) {
                ISVNStatus[] statuses = this.getStatus(path, recurse, false);
                int i = 0;
                while (i < statuses.length) {
                    String statusPath = statuses[i].getFile().getAbsolutePath();
                    this.notificationHandler.notifyListenersOfChange(statusPath);
                    statusBefore.remove(statusPath);
                    ++i;
                }
                for (String status : statusBefore) {
                    this.notificationHandler.notifyListenersOfChange(status);
                }
            } else {
                this.notificationHandler.notifyListenersOfChange(path.getAbsolutePath());
            }
        }
        catch (ClientException e) {
            this.notificationHandler.logException(e);
            throw new SVNClientException((Throwable)e);
        }
    }

    public void diff(File oldPath, SVNRevision oldPathRevision, File newPath, SVNRevision newPathRevision, File outFile, boolean recurse) throws SVNClientException {
        this.diff(oldPath, oldPathRevision, newPath, newPathRevision, outFile, recurse, true, false, false);
    }

    private void diffRelative(File oldPath, SVNRevision oldPathRevision, File newPath, SVNRevision newPathRevision, File outFile, boolean recurse, boolean ignoreAncestry, boolean noDiffDeleted, boolean force, File relativeTo) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(17);
            if (oldPath == null) {
                oldPath = new File(".");
            }
            if (newPath == null) {
                newPath = oldPath;
            }
            if (oldPathRevision == null) {
                oldPathRevision = SVNRevision.BASE;
            }
            if (newPathRevision == null) {
                newPathRevision = SVNRevision.WORKING;
            }
            String oldTarget = AbstractJhlClientAdapter.fileToSVNPath(oldPath, false);
            String newTarget = AbstractJhlClientAdapter.fileToSVNPath(newPath, false);
            String svnOutFile = AbstractJhlClientAdapter.fileToSVNPath(outFile, false);
            String relativeToDir = AbstractJhlClientAdapter.fileToSVNPath(relativeTo, false);
            String commandLine = "diff ";
            if (oldPathRevision.getKind() != Revision.Kind.base.ordinal() || newPathRevision.getKind() != Revision.Kind.working.ordinal()) {
                commandLine = String.valueOf(commandLine) + "-r " + oldPathRevision.toString();
                if (newPathRevision.getKind() != Revision.Kind.working.ordinal()) {
                    commandLine = String.valueOf(commandLine) + ":" + newPathRevision.toString();
                }
                commandLine = String.valueOf(commandLine) + " ";
            }
            if (!oldPath.equals(new File("."))) {
                commandLine = String.valueOf(commandLine) + "--old " + oldTarget + " ";
            }
            if (!newPath.equals(oldPath)) {
                commandLine = String.valueOf(commandLine) + "--new " + newTarget + " ";
            }
            int depth = Depth.empty.ordinal();
            if (recurse) {
                depth = Depth.infinity.ordinal();
            } else if (oldPath.isFile()) {
                depth = Depth.files.ordinal();
            }
            this.notificationHandler.logCommandLine(commandLine);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir((File[])new File[]{oldPath, newPath}));
            this.svnClient.diff(oldTarget, JhlConverter.convert(oldPathRevision), newTarget, JhlConverter.convert(newPathRevision), relativeToDir, svnOutFile, JhlConverter.depth(depth), null, ignoreAncestry, noDiffDeleted, force, true);
        }
        catch (ClientException e) {
            this.notificationHandler.logException(e);
            throw new SVNClientException((Throwable)e);
        }
    }

    public void diff(File oldPath, SVNRevision oldPathRevision, File newPath, SVNRevision newPathRevision, File outFile, boolean recurse, boolean ignoreAncestry, boolean noDiffDeleted, boolean force) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(17);
            if (oldPath == null) {
                oldPath = new File(".");
            }
            if (newPath == null) {
                newPath = oldPath;
            }
            if (oldPathRevision == null) {
                oldPathRevision = SVNRevision.BASE;
            }
            if (newPathRevision == null) {
                newPathRevision = SVNRevision.WORKING;
            }
            String oldTarget = AbstractJhlClientAdapter.fileToSVNPath(oldPath, false);
            String newTarget = AbstractJhlClientAdapter.fileToSVNPath(newPath, false);
            String svnOutFile = AbstractJhlClientAdapter.fileToSVNPath(outFile, false);
            String commandLine = "diff ";
            if (oldPathRevision.getKind() != Revision.Kind.base.ordinal() || newPathRevision.getKind() != Revision.Kind.working.ordinal()) {
                commandLine = String.valueOf(commandLine) + "-r " + oldPathRevision.toString();
                if (newPathRevision.getKind() != Revision.Kind.working.ordinal()) {
                    commandLine = String.valueOf(commandLine) + ":" + newPathRevision.toString();
                }
                commandLine = String.valueOf(commandLine) + " ";
            }
            if (!oldPath.equals(new File("."))) {
                commandLine = String.valueOf(commandLine) + "--old " + oldTarget + " ";
            }
            if (!newPath.equals(oldPath)) {
                commandLine = String.valueOf(commandLine) + "--new " + newTarget + " ";
            }
            this.notificationHandler.logCommandLine(commandLine);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir((File[])new File[]{oldPath, newPath}));
            this.svnClient.diff(oldTarget, JhlConverter.convert(oldPathRevision), newTarget, JhlConverter.convert(newPathRevision), null, svnOutFile, Depth.infinityOrEmpty(recurse), null, ignoreAncestry, noDiffDeleted, force, true);
        }
        catch (ClientException e) {
            this.notificationHandler.logException(e);
            throw new SVNClientException((Throwable)e);
        }
    }

    public void diff(File path, File outFile, boolean recurse) throws SVNClientException {
        this.diff(path, null, null, null, outFile, recurse);
    }

    public void diff(SVNUrl oldUrl, SVNRevision oldUrlRevision, SVNUrl newUrl, SVNRevision newUrlRevision, File outFile, boolean recurse) throws SVNClientException {
        this.diff(oldUrl, oldUrlRevision, newUrl, newUrlRevision, outFile, recurse, true, false, false);
    }

    public void diff(SVNUrl target, SVNRevision pegRevision, SVNRevision startRevision, SVNRevision endRevision, File outFile, int depth, boolean ignoreAncestry, boolean noDiffDeleted, boolean force) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(17);
            if (pegRevision == null) {
                pegRevision = SVNRevision.HEAD;
            }
            if (startRevision == null) {
                startRevision = SVNRevision.HEAD;
            }
            if (endRevision == null) {
                endRevision = SVNRevision.HEAD;
            }
            String commandLine = "diff ";
            Depth d = JhlConverter.depth(depth);
            commandLine = String.valueOf(commandLine) + this.depthCommandLine(d);
            if (ignoreAncestry) {
                commandLine = String.valueOf(commandLine) + " --ignoreAncestry";
            }
            commandLine = String.valueOf(commandLine) + " -r " + startRevision + ":" + endRevision + " " + target;
            this.notificationHandler.logCommandLine(commandLine);
            this.notificationHandler.setBaseDir();
            this.svnClient.diff(target.toString(), JhlConverter.convert(pegRevision), JhlConverter.convert(startRevision), JhlConverter.convert(endRevision), null, outFile.getAbsolutePath(), d, null, ignoreAncestry, noDiffDeleted, force, false);
        }
        catch (ClientException e) {
            this.notificationHandler.logException(e);
            throw new SVNClientException((Throwable)e);
        }
    }

    public void diff(SVNUrl target, SVNRevision pegRevision, SVNRevision startRevision, SVNRevision endRevision, File outFile, boolean recurse) throws SVNClientException {
        this.diff(target, pegRevision, startRevision, endRevision, outFile, Depth.infinityOrImmediates(recurse).ordinal(), true, false, false);
    }

    public void diff(SVNUrl oldUrl, SVNRevision oldUrlRevision, SVNUrl newUrl, SVNRevision newUrlRevision, File outFile, boolean recurse, boolean ignoreAncestry, boolean noDiffDeleted, boolean force) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(17);
            if (newUrl == null) {
                newUrl = oldUrl;
            }
            if (oldUrlRevision == null) {
                oldUrlRevision = SVNRevision.HEAD;
            }
            if (newUrlRevision == null) {
                newUrlRevision = SVNRevision.HEAD;
            }
            String svnOutFile = AbstractJhlClientAdapter.fileToSVNPath(outFile, false);
            String commandLine = "diff ";
            if (oldUrlRevision.getKind() != Revision.Kind.head.ordinal() || newUrlRevision.getKind() != Revision.Kind.head.ordinal()) {
                commandLine = String.valueOf(commandLine) + "-r " + oldUrlRevision.toString();
                if (newUrlRevision.getKind() != Revision.Kind.head.ordinal()) {
                    commandLine = String.valueOf(commandLine) + ":" + newUrlRevision.toString();
                }
                commandLine = String.valueOf(commandLine) + " ";
            }
            commandLine = String.valueOf(commandLine) + oldUrl + " ";
            if (!newUrl.equals((Object)oldUrl)) {
                commandLine = String.valueOf(commandLine) + newUrl + " ";
            }
            this.notificationHandler.logCommandLine(commandLine);
            this.notificationHandler.setBaseDir();
            this.svnClient.diff(oldUrl.toString(), JhlConverter.convert(oldUrlRevision), newUrl.toString(), JhlConverter.convert(newUrlRevision), null, svnOutFile, Depth.infinityOrEmpty(recurse), null, ignoreAncestry, noDiffDeleted, force, false);
        }
        catch (ClientException e) {
            this.notificationHandler.logException(e);
            throw new SVNClientException((Throwable)e);
        }
    }

    public void diff(SVNUrl url, SVNRevision oldUrlRevision, SVNRevision newUrlRevision, File outFile, boolean recurse) throws SVNClientException {
        this.diff(url, oldUrlRevision, url, newUrlRevision, outFile, recurse);
    }

    public ISVNAnnotations annotate(File file, SVNRevision revisionStart, SVNRevision revisionEnd, boolean ignoreMimeType, boolean includeMergedRevisions) throws SVNClientException {
        return this.annotate(file, revisionStart, revisionEnd, null, ignoreMimeType, includeMergedRevisions);
    }

    public ISVNAnnotations annotate(File file, SVNRevision revisionStart, SVNRevision revisionEnd, SVNRevision pegRevision, boolean ignoreMimeType, boolean includeMergedRevisions) throws SVNClientException {
        String target = AbstractJhlClientAdapter.fileToSVNPath(file, false);
        ISVNInfo info = this.getInfoFromWorkingCopy(file);
        if (SVNScheduleKind.ADD == info.getSchedule() && info.getCopyUrl() != null) {
            target = info.getCopyUrl().toString();
        }
        return this.annotate(target, revisionStart, revisionEnd, pegRevision, ignoreMimeType, includeMergedRevisions);
    }

    public ISVNAnnotations annotate(SVNUrl url, SVNRevision revisionStart, SVNRevision revisionEnd, SVNRevision pegRevision, boolean ignoreMimeType, boolean includeMergedRevisions) throws SVNClientException {
        return this.annotate(url.toString(), revisionStart, revisionEnd, pegRevision, ignoreMimeType, includeMergedRevisions);
    }

    private ISVNAnnotations annotate(String target, SVNRevision revisionStart, SVNRevision revisionEnd, SVNRevision pegRevision, boolean ignoreMimeType, boolean includeMergedRevisions) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(25);
            if (revisionStart == null) {
                revisionStart = new SVNRevision.Number(1L);
            }
            if (revisionEnd == null) {
                revisionEnd = SVNRevision.HEAD;
            }
            if (pegRevision == null) {
                pegRevision = SVNRevision.HEAD;
            }
            String commandLine = "blame ";
            if (includeMergedRevisions) {
                commandLine = String.valueOf(commandLine) + "-g ";
            }
            commandLine = String.valueOf(commandLine) + "-r " + revisionStart.toString() + ":" + revisionEnd.toString() + " ";
            commandLine = String.valueOf(commandLine) + target + "@" + pegRevision;
            this.notificationHandler.logCommandLine(commandLine);
            this.notificationHandler.setBaseDir();
            JhlAnnotations annotations = new JhlAnnotations();
            this.svnClient.blame(target, JhlConverter.convert(pegRevision), JhlConverter.convert(revisionStart), JhlConverter.convert(revisionEnd), ignoreMimeType, includeMergedRevisions, annotations);
            return annotations;
        }
        catch (ClientException e) {
            if (includeMergedRevisions && e.getAprError() == 200007) {
                return this.annotate(target, revisionStart, revisionEnd, pegRevision, ignoreMimeType, false);
            }
            if (e.getAprError() == 160013 && pegRevision != null && !pegRevision.equals((Object)revisionEnd)) {
                return this.annotate(target, revisionStart, pegRevision, pegRevision, ignoreMimeType, includeMergedRevisions);
            }
            this.notificationHandler.logException(e);
            throw new SVNClientException((Throwable)e);
        }
    }

    public ISVNAnnotations annotate(SVNUrl url, SVNRevision revisionStart, SVNRevision revisionEnd) throws SVNClientException {
        return this.annotate(url.toString(), revisionStart, revisionEnd, null, false, false);
    }

    public ISVNAnnotations annotate(File file, SVNRevision revisionStart, SVNRevision revisionEnd) throws SVNClientException {
        String target = AbstractJhlClientAdapter.fileToSVNPath(file, false);
        ISVNInfo info = this.getInfoFromWorkingCopy(file);
        if (SVNScheduleKind.ADD == info.getSchedule() && info.getCopyUrl() != null) {
            target = info.getCopyUrl().toString();
        }
        return this.annotate(target, revisionStart, revisionEnd, null, false, false);
    }

    public void resolved(File path) throws SVNClientException {
        this.resolve(path, 6);
    }

    public void resolve(File path, int result) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(31);
            String target = AbstractJhlClientAdapter.fileToSVNPath(path, true);
            String commandLine = "resolve ";
            ConflictResult.Choice choice = ConflictResult.Choice.chooseMerged;
            switch (result) {
                case 6: {
                    commandLine = String.valueOf(commandLine) + "--accept=working ";
                    choice = ConflictResult.Choice.chooseMerged;
                    break;
                }
                case 1: {
                    commandLine = String.valueOf(commandLine) + "--accept=base ";
                    choice = ConflictResult.Choice.chooseBase;
                    break;
                }
                case 2: {
                    commandLine = String.valueOf(commandLine) + "--accept=theirs-full ";
                    choice = ConflictResult.Choice.chooseTheirsFull;
                    break;
                }
                case 4: {
                    commandLine = String.valueOf(commandLine) + "--accept=theirs-conflict ";
                    choice = ConflictResult.Choice.chooseTheirsConflict;
                    break;
                }
                case 3: {
                    commandLine = String.valueOf(commandLine) + "--accept=mine-full ";
                    choice = ConflictResult.Choice.chooseMineFull;
                    break;
                }
                case 5: {
                    commandLine = String.valueOf(commandLine) + "--accept=mine-conflict ";
                    choice = ConflictResult.Choice.chooseMineConflict;
                    break;
                }
                default: {
                    choice = ConflictResult.Choice.chooseMerged;
                }
            }
            commandLine = String.valueOf(commandLine) + target;
            this.notificationHandler.logCommandLine(commandLine);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir((File)path));
            this.svnClient.resolve(target, Depth.empty, choice);
        }
        catch (SubversionException e) {
            this.notificationHandler.logException(e);
            throw new SVNClientException((Throwable)e);
        }
    }

    public void cancelOperation() throws SVNClientException {
        try {
            this.svnClient.cancelOperation();
        }
        catch (ClientException e) {
            this.notificationHandler.logException(e);
            throw new SVNClientException((Throwable)e);
        }
    }

    public ISVNInfo getInfoFromWorkingCopy(File path) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(19);
            String target = AbstractJhlClientAdapter.fileToSVNPath(path, false);
            this.notificationHandler.logCommandLine("info " + target);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir((File)path));
            JhlInfoCallback callback = new JhlInfoCallback();
            this.svnClient.info2(target, null, null, Depth.empty, null, callback);
            ISVNInfo[] items = callback.getInfo();
            if (items == null) {
                return new SVNInfoUnversioned(path);
            }
            return items[0];
        }
        catch (ClientException e) {
            if (e.getAprError() == 155007 || e.getAprError() == 155010) {
                return new SVNInfoUnversioned(path);
            }
            this.notificationHandler.logException(e);
            throw new SVNClientException((Throwable)e);
        }
    }

    public ISVNInfo getInfo(File path) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(19);
            String target = AbstractJhlClientAdapter.fileToSVNPath(path, false);
            this.notificationHandler.logCommandLine("info " + target);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir((File)path));
            JhlInfoCallback callback = new JhlInfoCallback();
            this.svnClient.info2(target, Revision.WORKING, Revision.BASE, Depth.infinity, null, callback);
            ISVNInfo[] items = callback.getInfo();
            if (items == null || items.length == 0) {
                return new SVNInfoUnversioned(path);
            }
            return items[0];
        }
        catch (ClientException e) {
            if (e.getAprError() == 155007 || e.getAprError() == 155010) {
                return new SVNInfoUnversioned(path);
            }
            this.notificationHandler.logException(e);
            throw new SVNClientException((Throwable)e);
        }
    }

    public ISVNInfo[] getInfo(File path, boolean descend) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(19);
            String target = AbstractJhlClientAdapter.fileToSVNPath(path, false);
            if (descend) {
                this.notificationHandler.logCommandLine("info " + target + " --depth=infinity");
            } else {
                this.notificationHandler.logCommandLine("info " + target);
            }
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir((File)path));
            JhlInfoCallback callback = new JhlInfoCallback();
            this.svnClient.info2(target, null, null, Depth.infinityOrEmpty(descend), null, callback);
            ISVNInfo[] items = callback.getInfo();
            if (items == null) {
                return new ISVNInfo[]{new SVNInfoUnversioned(path)};
            }
            return items;
        }
        catch (ClientException e) {
            if (e.getAprError() == 155007 || e.getAprError() == 155010) {
                return new ISVNInfo[]{new SVNInfoUnversioned(path)};
            }
            this.notificationHandler.logException(e);
            throw new SVNClientException((Throwable)e);
        }
    }

    public ISVNInfo getInfo(SVNUrl url, SVNRevision revision, SVNRevision peg) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(19);
            String target = url.toString();
            this.notificationHandler.logCommandLine("info " + target);
            JhlInfoCallback callback = new JhlInfoCallback();
            this.svnClient.info2(target, JhlConverter.convert(revision), JhlConverter.convert(peg), Depth.empty, null, callback);
            ISVNInfo[] items = callback.getInfo();
            if (items == null || items.length == 0) {
                return new SVNInfoUnversioned(null);
            }
            return items[0];
        }
        catch (ClientException e) {
            if (e.getAprError() == 155007 || e.getAprError() == 155010) {
                return new SVNInfoUnversioned(null);
            }
            this.notificationHandler.logException(e);
            throw new SVNClientException((Throwable)e);
        }
    }

    public void switchToUrl(File path, SVNUrl url, SVNRevision revision, boolean recurse) throws SVNClientException {
        this.switchToUrl(path, url, revision, Depth.unknownOrFiles(recurse).ordinal(), false, false, true);
    }

    public void switchToUrl(File path, SVNUrl url, SVNRevision revision, int depth, boolean setDepth, boolean ignoreExternals, boolean force) throws SVNClientException {
        this.switchToUrl(path, url, revision, revision, depth, setDepth, ignoreExternals, force);
    }

    public void switchToUrl(File path, SVNUrl url, SVNRevision revision, SVNRevision pegRevision, int depth, boolean setDepth, boolean ignoreExternals, boolean force) throws SVNClientException {
        this.switchToUrl(path, url, revision, pegRevision, depth, setDepth, ignoreExternals, force, false);
    }

    public void switchToUrl(File path, SVNUrl url, SVNRevision revision, SVNRevision pegRevision, int depth, boolean setDepth, boolean ignoreExternals, boolean force, boolean ignoreAncestry) throws SVNClientException {
        if (depth == Depth.exclude.ordinal()) {
            this.update(path, pegRevision, depth, true, ignoreExternals, force);
            return;
        }
        try {
            this.notificationHandler.setCommand(26);
            Depth d = JhlConverter.depth(depth);
            String target = AbstractJhlClientAdapter.fileToSVNPath(path, false);
            StringBuffer commandLine = new StringBuffer("switch " + url + " " + target + " -r " + revision.toString() + this.depthCommandLine(d));
            if (ignoreExternals) {
                commandLine.append(" --ignore-externals");
            }
            if (force) {
                commandLine.append(" --force");
            }
            this.notificationHandler.logCommandLine(commandLine.toString());
            File baseDir = SVNBaseDir.getBaseDir((File)path);
            this.notificationHandler.setBaseDir(baseDir);
            Revision rev = JhlConverter.convert(revision);
            Revision pegRev = JhlConverter.convert(pegRevision);
            this.svnClient.doSwitch(target, url.toString(), rev, pegRev, d, setDepth, ignoreExternals, force, ignoreAncestry);
        }
        catch (ClientException e) {
            this.notificationHandler.logException(e);
            throw new SVNClientException((Throwable)e);
        }
    }

    public void setConfigDirectory(File dir) throws SVNClientException {
        try {
            this.svnClient.setConfigDirectory(AbstractJhlClientAdapter.fileToSVNPath(dir, false));
        }
        catch (ClientException e) {
            this.notificationHandler.logException(e);
            throw new SVNClientException((Throwable)e);
        }
    }

    public void cleanup(File path) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(24);
            String target = AbstractJhlClientAdapter.fileToSVNPath(path, false);
            String commandLine = "cleanup " + target;
            this.notificationHandler.logCommandLine(commandLine);
            this.svnClient.cleanup(target);
        }
        catch (ClientException e) {
            this.notificationHandler.logException(e);
            throw new SVNClientException((Throwable)e);
        }
    }

    public void upgrade(File path) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(33);
            String target = AbstractJhlClientAdapter.fileToSVNPath(path, false);
            String commandLine = "upgrade " + target;
            this.notificationHandler.logCommandLine(commandLine);
            this.svnClient.upgrade(target);
        }
        catch (ClientException e) {
            this.notificationHandler.logException(e);
            throw new SVNClientException((Throwable)e);
        }
    }

    public void merge(SVNUrl path1, SVNRevision revision1, SVNUrl path2, SVNRevision revision2, File localPath, boolean force, boolean recurse, boolean dryRun, boolean ignoreAncestry) throws SVNClientException {
        this.merge(path1, revision1, path2, revision2, localPath, force, Depth.infinityOrFiles(recurse).ordinal(), dryRun, ignoreAncestry, false);
    }

    public void merge(SVNUrl path1, SVNRevision revision1, SVNUrl path2, SVNRevision revision2, SVNRevision pegRevision, File localPath, boolean force, int depth, boolean dryRun, boolean ignoreAncestry, boolean recordOnly) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(27);
            Depth d = JhlConverter.depth(depth);
            String target = AbstractJhlClientAdapter.fileToSVNPath(localPath, false);
            String commandLine = "merge";
            boolean samePath = false;
            if (dryRun) {
                commandLine = String.valueOf(commandLine) + " --dry-run";
            }
            commandLine = String.valueOf(commandLine) + this.depthCommandLine(d);
            if (force) {
                commandLine = String.valueOf(commandLine) + " --force";
            }
            if (ignoreAncestry) {
                commandLine = String.valueOf(commandLine) + " --ignore-ancestry";
            }
            if (path1.toString().equals(path2.toString())) {
                samePath = true;
                commandLine = revision1 == null || revision2 == null ? String.valueOf(commandLine) + " " + path1 : String.valueOf(commandLine) + " -r" + revision1.toString() + ":" + revision2.toString() + " " + path1;
            } else {
                commandLine = String.valueOf(commandLine) + " " + path1 + "@" + revision1.toString() + " " + path2 + "@" + revision2.toString();
            }
            commandLine = String.valueOf(commandLine) + " " + target;
            this.notificationHandler.logCommandLine(commandLine);
            File baseDir = SVNBaseDir.getBaseDir((File)localPath);
            this.notificationHandler.setBaseDir(baseDir);
            if (samePath) {
                ArrayList<RevisionRange> revisionRanges;
                if (revision1 == null && revision2 == null) {
                    revisionRanges = null;
                } else {
                    Revision rev1 = revision1 == null ? Revision.START : JhlConverter.convert(revision1);
                    Revision rev2 = revision2 == null ? Revision.START : JhlConverter.convert(revision2);
                    revisionRanges = new ArrayList<RevisionRange>();
                    revisionRanges.add(new RevisionRange(rev1, rev2));
                }
                this.svnClient.merge(path1.toString(), JhlConverter.convert(pegRevision), revisionRanges, target, force, d, ignoreAncestry, dryRun, recordOnly);
            } else {
                this.svnClient.merge(path1.toString(), JhlConverter.convert(revision1), path2.toString(), JhlConverter.convert(revision2), target, force, d, ignoreAncestry, dryRun, recordOnly);
            }
            if (dryRun) {
                this.notificationHandler.logCompleted("Dry-run merge complete.");
            } else {
                this.notificationHandler.logCompleted("Merge complete.");
            }
        }
        catch (ClientException e) {
            this.notificationHandler.logException(e);
            if (dryRun) {
                this.notificationHandler.logCompleted("Dry-run merge completed abnormally.");
            } else {
                this.notificationHandler.logCompleted("Merge completed abnormally.");
            }
            SVNClientException svnClientException = new SVNClientException((Throwable)e);
            svnClientException.setAprError(e.getAprError());
            throw svnClientException;
        }
    }

    public void merge(SVNUrl path1, SVNRevision revision1, SVNUrl path2, SVNRevision revision2, File localPath, boolean force, int depth, boolean dryRun, boolean ignoreAncestry, boolean recordOnly) throws SVNClientException {
        SVNUrlWithPegRevision svnUrlWithPegRevision = new SVNUrlWithPegRevision(path1);
        SVNRevision pegRevision = svnUrlWithPegRevision.getPegRevision();
        if (pegRevision == null) {
            pegRevision = revision2 == null ? SVNRevision.HEAD : revision2;
        }
        this.merge(svnUrlWithPegRevision.getUrl(), revision1, new SVNUrlWithPegRevision(path2).getUrl(), revision2, pegRevision, localPath, force, depth, dryRun, ignoreAncestry, recordOnly);
    }

    public void mergeReintegrate(SVNUrl path, SVNRevision pegRevision, File localPath, boolean force, boolean dryRun) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(27);
            String target = AbstractJhlClientAdapter.fileToSVNPath(localPath, false);
            String commandLine = "merge --reintegrate";
            if (dryRun) {
                commandLine = String.valueOf(commandLine) + " --dry-run";
            }
            if (force) {
                commandLine = String.valueOf(commandLine) + " --force";
            }
            commandLine = String.valueOf(commandLine) + " " + path + " " + target;
            this.notificationHandler.logCommandLine(commandLine);
            File baseDir = SVNBaseDir.getBaseDir((File)localPath);
            this.notificationHandler.setBaseDir(baseDir);
            Revision peg = JhlConverter.convert(pegRevision);
            if (peg == null) {
                peg = Revision.HEAD;
            }
            this.svnClient.mergeReintegrate(path.toString(), peg, target, dryRun);
            if (dryRun) {
                this.notificationHandler.logCompleted("Dry-run merge complete.");
            } else {
                this.notificationHandler.logCompleted("Merge complete.");
            }
        }
        catch (ClientException e) {
            this.notificationHandler.logException(e);
            if (dryRun) {
                this.notificationHandler.logCompleted("Dry-run merge completed abnormally.");
            } else {
                this.notificationHandler.logCompleted("Merge completed abnormally.");
            }
            SVNClientException svnClientException = new SVNClientException((Throwable)e);
            svnClientException.setAprError(e.getAprError());
            throw svnClientException;
        }
    }

    public void addPasswordCallback(ISVNPromptUserPassword callback) {
        if (callback != null) {
            JhlPromptUserPassword prompt = new JhlPromptUserPassword(callback);
            this.setPromptUserPassword(prompt);
        }
    }

    public void lock(SVNUrl[] uris, String comment, boolean force) throws SVNClientException {
        this.notImplementedYet();
    }

    public void unlock(SVNUrl[] uris, boolean force) throws SVNClientException {
        this.notImplementedYet();
    }

    public void lock(File[] paths, String comment, boolean force) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(28);
            HashSet<String> files = new HashSet<String>(paths.length);
            String commandLine = "lock -m \"" + comment + "\"";
            if (force) {
                commandLine = String.valueOf(commandLine) + " --force";
            }
            int i = 0;
            while (i < paths.length) {
                files.add(AbstractJhlClientAdapter.fileToSVNPath(paths[i], false));
                ++i;
            }
            commandLine = this.appendPaths(commandLine, files);
            this.notificationHandler.logCommandLine(commandLine);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir((File[])paths));
            this.svnClient.lock(files, comment, force);
            for (String file : files) {
                this.notificationHandler.notifyListenersOfChange(file);
            }
        }
        catch (ClientException e) {
            this.notificationHandler.logException(e);
        }
    }

    public void unlock(File[] paths, boolean force) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(28);
            HashSet<String> files = new HashSet<String>(paths.length);
            String commandLine = "unlock ";
            if (force) {
                commandLine = String.valueOf(commandLine) + " --force";
            }
            int i = 0;
            while (i < paths.length) {
                files.add(AbstractJhlClientAdapter.fileToSVNPath(paths[i], false));
                ++i;
            }
            commandLine = this.appendPaths(commandLine, files);
            this.notificationHandler.logCommandLine(commandLine);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir((File[])paths));
            this.svnClient.unlock(files, force);
            for (String file : files) {
                this.notificationHandler.notifyListenersOfChange(file);
            }
        }
        catch (ClientException e) {
            this.notificationHandler.logException(e);
        }
    }

    public void setRevProperty(SVNUrl url, SVNRevision.Number revisionNo, String propName, String propertyData, boolean force) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(14);
            this.notificationHandler.logCommandLine("propset --revprop -r " + revisionNo.toString() + (force ? " --force " : "") + " \"" + propName + "\"  \"" + propertyData + "\" " + url.toString());
            this.notificationHandler.setBaseDir();
            if (propName.startsWith("svn:")) {
                this.svnClient.setRevProperty(url.toString(), propName, Revision.getInstance(revisionNo.getNumber()), this.fixSVNString(propertyData), null, true);
            } else {
                this.svnClient.setRevProperty(url.toString(), propName, Revision.getInstance(revisionNo.getNumber()), propertyData, null, true);
            }
        }
        catch (ClientException e) {
            this.notificationHandler.logException(e);
            throw new SVNClientException((Throwable)e);
        }
    }

    public String getRevProperty(SVNUrl url, SVNRevision.Number revisionNo, String propName) throws SVNClientException {
        String propData = null;
        try {
            this.notificationHandler.setCommand(20);
            this.notificationHandler.logCommandLine("propget --revprop -r " + revisionNo.toString() + " \"" + propName + "\"  " + url.toString());
            this.notificationHandler.setBaseDir();
            byte[] bytes = this.svnClient.revProperty(url.toString(), propName, Revision.getInstance(revisionNo.getNumber()));
            try {
                propData = new String(bytes, "UTF8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                propData = new String(bytes);
            }
            if (propName.startsWith("svn:")) {
                this.fixSVNString(propData);
            }
        }
        catch (ClientException e) {
            this.notificationHandler.logException(e);
            throw new SVNClientException((Throwable)e);
        }
        return propData;
    }

    public ISVNProperty[] getRevProperties(SVNUrl url, SVNRevision.Number revisionNo) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(21);
            String target = url.toString();
            this.notificationHandler.logCommandLine("proplist --revprop -r " + revisionNo.toString() + target);
            this.notificationHandler.setBaseDir();
            Map<String, byte[]> propertiesData = this.svnClient.revProperties(target, Revision.getInstance(revisionNo.getNumber()));
            if (propertiesData == null) {
                return new JhlPropertyData[0];
            }
            Set<String> keys = propertiesData.keySet();
            ISVNProperty[] svnProperties = new JhlPropertyData[keys.size()];
            int i = 0;
            for (String key : keys) {
                svnProperties[i] = JhlPropertyData.newForUrl(target, key, propertiesData.get(key));
                ++i;
            }
            return svnProperties;
        }
        catch (ClientException e) {
            this.notificationHandler.logException(e);
            throw new SVNClientException((Throwable)e);
        }
    }

    public String getAdminDirectoryName() {
        return this.svnClient.getAdminDirectoryName();
    }

    public boolean isAdminDirectory(String name) {
        return this.svnClient.isAdminDirectory(name);
    }

    private void getLogMessages(String target, SVNRevision pegRevision, SVNRevision revisionStart, SVNRevision revisionEnd, boolean stopOnCopy, boolean fetchChangePath, long limit, boolean includeMergedRevisions, String[] requestedProperties, ISVNLogMessageCallback worker) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(13);
            String logExtras = "";
            if (includeMergedRevisions) {
                logExtras = String.valueOf(logExtras) + " -g";
            }
            if (stopOnCopy) {
                logExtras = String.valueOf(logExtras) + " --stop-on-copy";
            }
            if (limit > 0L) {
                logExtras = String.valueOf(logExtras) + " --limit " + limit;
            }
            this.notificationHandler.logCommandLine("log -r " + revisionStart.toString() + ":" + revisionEnd.toString() + " " + target + logExtras);
            JhlLogMessageCallback callback = new JhlLogMessageCallback(worker);
            HashSet<String> revProps = new HashSet<String>(requestedProperties.length);
            int i = 0;
            while (i < requestedProperties.length) {
                revProps.add(requestedProperties[i]);
                ++i;
            }
            ArrayList<RevisionRange> range = new ArrayList<RevisionRange>();
            range.add(new RevisionRange(JhlConverter.convert(revisionStart), JhlConverter.convert(revisionEnd)));
            this.svnClient.logMessages(target, JhlConverter.convert(pegRevision), range, stopOnCopy, fetchChangePath, includeMergedRevisions, revProps, limit, callback);
        }
        catch (ClientException e) {
            if (e.getAprError() == 200007 && includeMergedRevisions) {
                this.getLogMessages(target, pegRevision, revisionStart, revisionEnd, stopOnCopy, fetchChangePath, limit, false, requestedProperties, worker);
            }
            if (!(e.getAprError() != 160013 && e.getAprError() != 195012 || pegRevision == null || pegRevision.equals((Object)revisionStart))) {
                this.getLogMessages(target, pegRevision, pegRevision, revisionEnd, stopOnCopy, fetchChangePath, limit, includeMergedRevisions, requestedProperties, worker);
            }
            this.notificationHandler.logException(e);
            throw new SVNClientException((Throwable)e);
        }
    }

    public void getLogMessages(File path, SVNRevision pegRevision, SVNRevision revisionStart, SVNRevision revisionEnd, boolean stopOnCopy, boolean fetchChangePath, long limit, boolean includeMergedRevisions, String[] requestedProperties, ISVNLogMessageCallback worker) throws SVNClientException {
        String target = AbstractJhlClientAdapter.fileToSVNPath(path, false);
        this.notificationHandler.setBaseDir();
        this.getLogMessages(target, pegRevision, revisionStart, revisionEnd, stopOnCopy, fetchChangePath, limit, includeMergedRevisions, requestedProperties, worker);
    }

    public void getLogMessages(SVNUrl url, SVNRevision pegRevision, SVNRevision revisionStart, SVNRevision revisionEnd, boolean stopOnCopy, boolean fetchChangePath, long limit, boolean includeMergedRevisions, String[] requestedProperties, ISVNLogMessageCallback worker) throws SVNClientException {
        String target = url.toString();
        this.notificationHandler.setBaseDir();
        this.getLogMessages(target, pegRevision, revisionStart, revisionEnd, stopOnCopy, fetchChangePath, limit, includeMergedRevisions, requestedProperties, worker);
    }

    public void relocate(String from, String to, String path, boolean recurse) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(30);
            this.notificationHandler.logCommandLine("switch --relocate " + from + " " + to + " " + path);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir((File)new File(path)));
            boolean ignoreAncestry = false;
            this.svnClient.relocate(from, to, path, ignoreAncestry);
        }
        catch (ClientException e) {
            this.notificationHandler.logException(e);
            throw new SVNClientException((Throwable)e);
        }
    }

    public void diff(File path, SVNUrl url, SVNRevision urlRevision, File outFile, boolean recurse) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(17);
            String wcPath = AbstractJhlClientAdapter.fileToSVNPath(path, false);
            String svnOutFile = AbstractJhlClientAdapter.fileToSVNPath(outFile, false);
            String commandLine = "diff --old " + wcPath + " ";
            commandLine = String.valueOf(commandLine) + "--new " + url.toString();
            if (!urlRevision.equals((Object)SVNRevision.HEAD)) {
                commandLine = String.valueOf(commandLine) + "@" + urlRevision.toString();
            }
            this.notificationHandler.logCommandLine(commandLine);
            this.notificationHandler.setBaseDir(SVNBaseDir.getBaseDir((File)path));
            this.svnClient.diff(wcPath, Revision.WORKING, url.toString(), JhlConverter.convert(urlRevision), null, svnOutFile, Depth.infinityOrEmpty(recurse), null, false, true, false, true);
        }
        catch (ClientException e) {
            this.notificationHandler.logException(e);
            throw new SVNClientException((Throwable)e);
        }
    }

    public void mkdir(SVNUrl url, boolean makeParents, String message) throws SVNClientException {
        try {
            String fixedMessage = this.fixSVNString(message);
            if (fixedMessage == null) {
                fixedMessage = "";
            }
            this.notificationHandler.setCommand(10);
            HashSet<String> target = new HashSet<String>();
            target.add(url.toString());
            if (makeParents) {
                this.notificationHandler.logCommandLine("mkdir --parents -m \"" + this.getFirstMessageLine(fixedMessage) + "\" " + target);
            } else {
                this.notificationHandler.logCommandLine("mkdir -m \"" + this.getFirstMessageLine(fixedMessage) + "\" " + target);
            }
            this.notificationHandler.setBaseDir();
            this.svnClient.mkdir(target, makeParents, null, new JhlCommitMessage(fixedMessage), null);
        }
        catch (ClientException e) {
            this.notificationHandler.logException(e);
            throw new SVNClientException((Throwable)e);
        }
    }

    public void merge(SVNUrl url, SVNRevision pegRevision, SVNRevisionRange[] revisions, File localPath, boolean force, int depth, boolean ignoreAncestry, boolean dryRun, boolean recordOnly) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(27);
            String target = AbstractJhlClientAdapter.fileToSVNPath(localPath, false);
            String commandLine = "merge";
            if (dryRun) {
                commandLine = String.valueOf(commandLine) + " --dry-run";
            }
            Depth d = JhlConverter.depth(depth);
            commandLine = String.valueOf(commandLine) + this.depthCommandLine(d);
            if (force) {
                commandLine = String.valueOf(commandLine) + " --force";
            }
            if (ignoreAncestry) {
                commandLine = String.valueOf(commandLine) + " --ignore-ancestry";
            }
            List<RevisionRange> range = JhlConverter.convert(revisions);
            int i = 0;
            while (i < revisions.length) {
                commandLine = String.valueOf(commandLine) + " " + revisions[i].toMergeString();
                ++i;
            }
            commandLine = String.valueOf(commandLine) + " " + url.toString();
            commandLine = String.valueOf(commandLine) + " " + target;
            this.notificationHandler.logCommandLine(commandLine);
            File baseDir = SVNBaseDir.getBaseDir((File)localPath);
            this.notificationHandler.setBaseDir(baseDir);
            Revision peg = JhlConverter.convert(pegRevision);
            if (peg == null) {
                peg = Revision.HEAD;
            }
            this.svnClient.merge(url.toString(), peg, range, target, force, d, ignoreAncestry, dryRun, recordOnly);
            if (dryRun) {
                this.notificationHandler.logCompleted("Dry-run merge complete.");
            } else {
                this.notificationHandler.logCompleted("Merge complete.");
            }
        }
        catch (ClientException e) {
            this.notificationHandler.logException(e);
            if (dryRun) {
                this.notificationHandler.logCompleted("Dry-run merge completed abnormally.");
            } else {
                this.notificationHandler.logCompleted("Merge completed abnormally.");
            }
            SVNClientException svnClientException = new SVNClientException((Throwable)e);
            svnClientException.setAprError(e.getAprError());
            throw svnClientException;
        }
    }

    private String depthCommandLine(Depth depth) {
        switch (depth) {
            case empty: {
                return " --depth=empty";
            }
            case files: {
                return " --depth=files";
            }
            case immediates: {
                return " --depth=immediates";
            }
            case infinity: {
                return " --depth=infinity";
            }
            case exclude: {
                return " --depth=exclude";
            }
        }
        return "";
    }

    public ISVNMergeInfo getMergeInfo(File path, SVNRevision revision) throws SVNClientException {
        return this.getMergeInfo(AbstractJhlClientAdapter.fileToSVNPath(path, false), JhlConverter.convert(revision));
    }

    public ISVNMergeInfo getMergeInfo(SVNUrl url, SVNRevision revision) throws SVNClientException {
        return this.getMergeInfo(url.toString(), JhlConverter.convert(revision));
    }

    private ISVNMergeInfo getMergeInfo(String path, Revision revision) throws SVNClientException {
        Mergeinfo info;
        block3: {
            try {
                info = this.svnClient.getMergeinfo(path, revision);
                if (info != null) break block3;
                return null;
            }
            catch (SubversionException e) {
                throw new SVNClientException((Throwable)e);
            }
        }
        return new JhlMergeInfo(info);
    }

    public void addConflictResolutionCallback(ISVNConflictResolver callback) {
        this.conflictResolver = callback == null ? null : new JhlConflictResolver(callback);
        this.svnClient.setConflictResolver(this.conflictResolver);
    }

    public void setProgressListener(ISVNProgressListener listener) {
        this.progressListener.setWorker(listener);
    }

    private SVNDiffSummary[] diffSummarize(String target1, SVNRevision revision1, String target2, SVNRevision revision2, int depth, boolean ignoreAncestry) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(17);
            if (revision1 == null) {
                revision1 = SVNRevision.HEAD;
            }
            if (revision2 == null) {
                revision2 = SVNRevision.HEAD;
            }
            String commandLine = "diff --summarize";
            Depth d = JhlConverter.depth(depth);
            commandLine = String.valueOf(commandLine) + this.depthCommandLine(d);
            if (ignoreAncestry) {
                commandLine = String.valueOf(commandLine) + " --ignoreAncestry";
            }
            commandLine = String.valueOf(commandLine) + " " + target1 + "@" + revision1 + " " + target2 + "@" + revision2;
            this.notificationHandler.logCommandLine(commandLine);
            this.notificationHandler.setBaseDir();
            JhlDiffSummaryReceiver callback = new JhlDiffSummaryReceiver();
            this.svnClient.diffSummarize(target1, JhlConverter.convert(revision1), target2, JhlConverter.convert(revision2), d, null, ignoreAncestry, (DiffSummaryCallback)callback);
            return callback.getDiffSummary();
        }
        catch (ClientException e) {
            this.notificationHandler.logException(e);
            throw new SVNClientException((Throwable)e);
        }
    }

    private SVNDiffSummary[] diffSummarize(String target, SVNRevision pegRevision, SVNRevision startRevision, SVNRevision endRevision, int depth, boolean ignoreAncestry) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(17);
            if (pegRevision == null) {
                pegRevision = SVNRevision.HEAD;
            }
            if (startRevision == null) {
                startRevision = SVNRevision.HEAD;
            }
            if (endRevision == null) {
                endRevision = SVNRevision.HEAD;
            }
            String commandLine = "diff --summarize";
            Depth d = JhlConverter.depth(depth);
            commandLine = String.valueOf(commandLine) + this.depthCommandLine(d);
            if (ignoreAncestry) {
                commandLine = String.valueOf(commandLine) + " --ignoreAncestry";
            }
            commandLine = String.valueOf(commandLine) + " -r " + startRevision + ":" + endRevision + " " + target;
            this.notificationHandler.logCommandLine(commandLine);
            this.notificationHandler.setBaseDir();
            JhlDiffSummaryReceiver callback = new JhlDiffSummaryReceiver();
            this.svnClient.diffSummarize(target, JhlConverter.convert(pegRevision), JhlConverter.convert(startRevision), JhlConverter.convert(endRevision), d, null, ignoreAncestry, (DiffSummaryCallback)callback);
            return callback.getDiffSummary();
        }
        catch (ClientException e) {
            this.notificationHandler.logException(e);
            throw new SVNClientException((Throwable)e);
        }
    }

    public SVNDiffSummary[] diffSummarize(File path, SVNRevision pegRevision, SVNRevision startRevision, SVNRevision endRevision, int depth, boolean ignoreAncestry) throws SVNClientException {
        String target = AbstractJhlClientAdapter.fileToSVNPath(path, false);
        return this.diffSummarize(target, pegRevision, startRevision, endRevision, depth, ignoreAncestry);
    }

    public SVNDiffSummary[] diffSummarize(SVNUrl url, SVNRevision pegRevision, SVNRevision startRevision, SVNRevision endRevision, int depth, boolean ignoreAncestry) throws SVNClientException {
        return this.diffSummarize(url.toString(), pegRevision, startRevision, endRevision, depth, ignoreAncestry);
    }

    public SVNDiffSummary[] diffSummarize(File target1, SVNRevision revision1, SVNUrl target2, SVNRevision revision2, int depth, boolean ignoreAncestry) throws SVNClientException {
        return this.diffSummarize(AbstractJhlClientAdapter.fileToSVNPath(target1, false), revision1, target2.toString(), revision2, depth, ignoreAncestry);
    }

    public SVNDiffSummary[] diffSummarize(SVNUrl target1, SVNRevision revision1, SVNUrl target2, SVNRevision revision2, int depth, boolean ignoreAncestry) throws SVNClientException {
        return this.diffSummarize(target1.toString(), revision1, target2.toString(), revision2, depth, ignoreAncestry);
    }

    public SVNDiffSummary[] diffSummarize(File path, SVNUrl toUrl, SVNRevision toRevision, boolean recurse) throws SVNClientException {
        return this.diffSummarize(path.getAbsolutePath(), SVNRevision.WORKING, toUrl.toString(), toRevision, Depth.infinity.ordinal(), true);
    }

    private SVNDiffSummary.SVNDiffKind getDiffKind(String changedResource, boolean deletedLines, boolean addedLines, boolean contextLines, boolean oldRev0, boolean newRev0) {
        SVNDiffSummary.SVNDiffKind diffKind = oldRev0 && newRev0 ? SVNDiffSummary.SVNDiffKind.DELETED : (addedLines && !deletedLines && !contextLines ? SVNDiffSummary.SVNDiffKind.ADDED : (!deletedLines && !addedLines || deletedLines && !addedLines && !contextLines ? (this.exists(changedResource) ? SVNDiffSummary.SVNDiffKind.DELETED : SVNDiffSummary.SVNDiffKind.ADDED) : SVNDiffSummary.SVNDiffKind.MODIFIED));
        return diffKind;
    }

    private boolean exists(String changedResource) {
        File file = new File(changedResource);
        return file.exists();
    }

    public String[] suggestMergeSources(File path) throws SVNClientException {
        String[] sources = null;
        try {
            Set<String> s = this.svnClient.suggestMergeSources(AbstractJhlClientAdapter.fileToSVNPath(path, false), Revision.HEAD);
            sources = new String[s.size()];
            s.toArray(sources);
        }
        catch (SubversionException e) {
            throw new SVNClientException((Throwable)e);
        }
        return sources;
    }

    public String[] suggestMergeSources(SVNUrl url, SVNRevision peg) throws SVNClientException {
        String[] sources = null;
        try {
            Set<String> s = this.svnClient.suggestMergeSources(url.toString(), JhlConverter.convert(peg));
            sources = new String[s.size()];
            s.toArray(sources);
        }
        catch (SubversionException e) {
            throw new SVNClientException((Throwable)e);
        }
        return sources;
    }

    public void createPatch(File[] paths, File relativeToPath, File outFile, boolean recurse) throws SVNClientException {
        FileOutputStream os = null;
        try {
            try {
                ArrayList<File> tempFiles = new ArrayList<File>();
                int i = 0;
                while (i < paths.length) {
                    File tempFile = File.createTempFile("tempDiff", ".txt");
                    tempFile.deleteOnExit();
                    this.diffRelative(paths[i], SVNRevision.BASE, paths[i], SVNRevision.WORKING, tempFile, recurse, false, false, false, relativeToPath);
                    tempFiles.add(tempFile);
                    ++i;
                }
                os = new FileOutputStream(outFile);
                for (File tempFile : tempFiles) {
                    int bytes_read;
                    FileInputStream is = new FileInputStream(tempFile);
                    byte[] buffer = new byte[4096];
                    while ((bytes_read = is.read(buffer)) != -1) {
                        os.write(buffer, 0, bytes_read);
                    }
                    is.close();
                }
            }
            catch (Exception e) {
                throw new SVNClientException((Throwable)e);
            }
        }
        catch (Throwable throwable) {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {}
            }
            throw throwable;
        }
        if (os != null) {
            try {
                os.close();
            }
            catch (IOException iOException) {}
        }
    }

    public void dispose() {
        this.svnClient.dispose();
    }

    public ISVNLogMessage[] getMergeinfoLog(int kind, File path, SVNRevision pegRevision, SVNUrl mergeSourceUrl, SVNRevision srcPegRevision, boolean discoverChangedPaths) throws SVNClientException {
        return this.getMergeinfoLog(kind, AbstractJhlClientAdapter.fileToSVNPath(path, false), pegRevision, mergeSourceUrl, srcPegRevision, discoverChangedPaths);
    }

    public ISVNLogMessage[] getMergeinfoLog(int kind, SVNUrl url, SVNRevision pegRevision, SVNUrl mergeSourceUrl, SVNRevision srcPegRevision, boolean discoverChangedPaths) throws SVNClientException {
        return this.getMergeinfoLog(kind, url.toString(), pegRevision, mergeSourceUrl, srcPegRevision, discoverChangedPaths);
    }

    private ISVNLogMessage[] getMergeinfoLog(int kind, String target, SVNRevision pegRevision, SVNUrl mergeSourceUrl, SVNRevision srcPegRevision, boolean discoverChangedPaths) throws SVNClientException {
        try {
            this.notificationHandler.setCommand(32);
            String show = "";
            Mergeinfo.LogKind mergeKind = Mergeinfo.LogKind.eligible;
            if (kind == 0) {
                show = String.valueOf(show) + " --show-revs eligible ";
            }
            if (kind == 1) {
                show = String.valueOf(show) + " --show-revs merged ";
                mergeKind = Mergeinfo.LogKind.merged;
            }
            this.notificationHandler.logCommandLine("mergeinfo " + show + mergeSourceUrl.toString() + " " + target);
            SVNLogMessageCallback worker = new SVNLogMessageCallback();
            JhlLogMessageCallback callback = new JhlLogMessageCallback((ISVNLogMessageCallback)worker);
            HashSet<String> revProps = new HashSet<String>();
            revProps.add("svn:author");
            revProps.add("svn:date");
            revProps.add("svn:log");
            this.svnClient.getMergeinfoLog(mergeKind, target, JhlConverter.convert(pegRevision), mergeSourceUrl.toString(), JhlConverter.convert(srcPegRevision), discoverChangedPaths, Depth.infinity, revProps, callback);
            return worker.getLogMessages();
        }
        catch (ClientException e) {
            if (e.getAprError() == 200007) {
                return this.getLogMessages(mergeSourceUrl, srcPegRevision, (SVNRevision)new SVNRevision.Number(0L), SVNRevision.HEAD, true, discoverChangedPaths, 0L, false);
            }
            this.notificationHandler.logException(e);
            throw new SVNClientException((Throwable)e);
        }
    }

    private String appendPaths(String commandLine, Set<String> paths) {
        StringBuffer stringBuffer = new StringBuffer(commandLine);
        if (paths.size() > 5) {
            stringBuffer.append(" (" + paths.size() + " paths specified)");
        } else {
            for (String s : paths) {
                stringBuffer.append(" " + s);
            }
        }
        return stringBuffer.toString();
    }

    private String getFirstMessageLine(String message) {
        StringTokenizer tokenizer = new StringTokenizer(message, "\n");
        int count = tokenizer.countTokens();
        if (count > 1) {
            return String.valueOf(tokenizer.nextToken()) + "...";
        }
        return message;
    }

    protected String fixSVNString(String message) {
        if (message == null) {
            return null;
        }
        return message.replaceAll("\r\n", "\n").replaceAll("\r", "\n");
    }

    public static class DefaultPromptUserPassword
    implements UserPasswordCallback {
        @Override
        public int askTrustSSLServer(String info, boolean allowPermanently) {
            return 1;
        }

        @Override
        public String askQuestion(String realm, String question, boolean showAnswer) {
            return "";
        }

        @Override
        public boolean askYesNo(String realm, String question, boolean yesIsDefault) {
            return yesIsDefault;
        }

        @Override
        public String getPassword() {
            return "";
        }

        @Override
        public String getUsername() {
            return "";
        }

        @Override
        public boolean prompt(String realm, String username) {
            return false;
        }

        @Override
        public boolean prompt(String realm, String username, boolean maySave) {
            return false;
        }

        @Override
        public String askQuestion(String realm, String question, boolean showAnswer, boolean maySave) {
            return null;
        }

        @Override
        public boolean userAllowedSave() {
            return false;
        }
    }

    private class MyStatusCallback
    implements StatusCallback {
        private List<Status> statuses = new ArrayList<Status>();

        private MyStatusCallback() {
        }

        @Override
        public void doStatus(String path, Status status) {
            if (status != null) {
                this.statuses.add(status);
            }
        }

        public List<Status> getStatusList() {
            return this.statuses;
        }
    }
}

