/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter.javahl;

import org.apache.subversion.javahl.SVNClient;
import org.apache.subversion.javahl.types.Version;
import org.tigris.subversion.svnclientadapter.ISVNClientAdapter;
import org.tigris.subversion.svnclientadapter.SVNClientAdapterFactory;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.javahl.JhlClientAdapter;

public class JhlClientAdapterFactory
extends SVNClientAdapterFactory {
    private static final String[] WINDOWSLIBS = new String[]{"msvcr100", "msvcp100", "libapr-1", "libapriconv-1", "libeay32", "ssleay32", "libaprutil-1", "dbghelp", "libsasl", "libsvn_subr-1", "libsvn_delta-1", "libsvn_diff-1", "libsvn_wc-1", "libsvn_fs-1", "libsvn_repos-1", "libsvn_ra-1", "libsvn_client-1"};
    private static boolean availabilityCached = false;
    private static boolean available;
    private static StringBuffer javaHLErrors;
    public static final String JAVAHL_CLIENT = "javahl";

    static {
        javaHLErrors = new StringBuffer("Failed to load JavaHL Library.\nThese are the errors that were encountered:\n");
    }

    private JhlClientAdapterFactory() {
    }

    protected ISVNClientAdapter createSVNClientImpl() {
        return new JhlClientAdapter();
    }

    protected String getClientType() {
        return JAVAHL_CLIENT;
    }

    public static void setup() throws SVNClientException {
        if (!JhlClientAdapterFactory.isAvailable()) {
            throw new SVNClientException("Javahl client adapter is not available");
        }
        SVNClientAdapterFactory.registerAdapterFactory((SVNClientAdapterFactory)new JhlClientAdapterFactory());
    }

    public static boolean isAvailable() {
        if (!availabilityCached) {
            block29: {
                Class<?> c = null;
                try {
                    c = Class.forName("org.apache.subversion.javahl.ClientException");
                    if (c == null) {
                        return false;
                    }
                }
                catch (Throwable throwable) {
                    availabilityCached = true;
                    return false;
                }
                if (JhlClientAdapterFactory.isOsWindows()) {
                    int i = 0;
                    while (i < WINDOWSLIBS.length) {
                        try {
                            System.loadLibrary(WINDOWSLIBS[i]);
                        }
                        catch (Exception e) {
                            javaHLErrors.append(e.getMessage()).append("\n");
                        }
                        catch (UnsatisfiedLinkError e) {
                            javaHLErrors.append(e.getMessage()).append("\n");
                        }
                        ++i;
                    }
                }
                available = false;
                try {
                    try {
                        try {
                            String specifiedLibraryName = System.getProperty("subversion.native.library");
                            if (specifiedLibraryName != null) {
                                System.load(specifiedLibraryName);
                                available = true;
                            }
                        }
                        catch (UnsatisfiedLinkError ex) {
                            javaHLErrors.append(ex.getMessage()).append("\n");
                        }
                        if (available) break block29;
                        try {
                            System.loadLibrary("libsvnjavahl-1");
                        }
                        catch (UnsatisfiedLinkError ex) {
                            javaHLErrors.append(String.valueOf(ex.getMessage()) + "\n");
                            try {
                                System.loadLibrary("svnjavahl-1");
                            }
                            catch (UnsatisfiedLinkError e) {
                                javaHLErrors.append(e.getMessage()).append("\n");
                                System.loadLibrary("svnjavahl");
                            }
                        }
                        available = true;
                    }
                    catch (Exception e) {
                        available = false;
                        javaHLErrors.append(e.getMessage()).append("\n");
                    }
                    catch (UnsatisfiedLinkError e) {
                        available = false;
                        javaHLErrors.append(e.getMessage()).append("\n");
                    }
                }
                finally {
                    availabilityCached = true;
                }
            }
            if (!available) {
                String libraryPath = System.getProperty("java.library.path");
                if (libraryPath != null) {
                    javaHLErrors.append("java.library.path = " + libraryPath);
                }
            } else {
                try {
                    SVNClient svnClient = new SVNClient();
                    Version version = svnClient.getVersion();
                    if (version.getMajor() == 1 && version.getMinor() == 9) {
                        available = true;
                    } else {
                        available = false;
                        javaHLErrors = new StringBuffer("Incompatible JavaHL library loaded.  Subversion 1.9.x required.");
                    }
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    available = false;
                    javaHLErrors = new StringBuffer("Incompatible JavaHL library loaded.  1.9.x or later required.");
                }
            }
        }
        return available;
    }

    public static boolean isOsWindows() {
        try {
            return System.getProperty("os.name").startsWith("Windows");
        }
        catch (SecurityException securityException) {
            return false;
        }
    }

    public static String getLibraryLoadErrors() {
        if (JhlClientAdapterFactory.isAvailable()) {
            return "";
        }
        return javaHLErrors.toString();
    }
}

