/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter.javahl;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.subversion.javahl.ConflictDescriptor;
import org.apache.subversion.javahl.ConflictResult;
import org.apache.subversion.javahl.DiffSummary;
import org.apache.subversion.javahl.ISVNClient;
import org.apache.subversion.javahl.types.ChangePath;
import org.apache.subversion.javahl.types.Depth;
import org.apache.subversion.javahl.types.DirEntry;
import org.apache.subversion.javahl.types.Info;
import org.apache.subversion.javahl.types.Lock;
import org.apache.subversion.javahl.types.NodeKind;
import org.apache.subversion.javahl.types.Revision;
import org.apache.subversion.javahl.types.RevisionRange;
import org.apache.subversion.javahl.types.Status;
import org.tigris.subversion.svnclientadapter.ISVNLogMessageChangePath;
import org.tigris.subversion.svnclientadapter.SVNConflictDescriptor;
import org.tigris.subversion.svnclientadapter.SVNConflictResult;
import org.tigris.subversion.svnclientadapter.SVNConflictVersion;
import org.tigris.subversion.svnclientadapter.SVNDiffSummary;
import org.tigris.subversion.svnclientadapter.SVNLogMessageChangePath;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNRevisionRange;
import org.tigris.subversion.svnclientadapter.SVNScheduleKind;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;
import org.tigris.subversion.svnclientadapter.javahl.JhlDirEntry;
import org.tigris.subversion.svnclientadapter.javahl.JhlLock;
import org.tigris.subversion.svnclientadapter.javahl.JhlLogMessageChangePath;
import org.tigris.subversion.svnclientadapter.javahl.JhlStatus;

public class JhlConverter {
    private static final Logger log = Logger.getLogger(JhlConverter.class.getName());

    private JhlConverter() {
    }

    public static Revision convert(SVNRevision svnRevision) {
        if (svnRevision == null) {
            return null;
        }
        switch (svnRevision.getKind()) {
            case 5: {
                return Revision.BASE;
            }
            case 3: {
                return Revision.COMMITTED;
            }
            case 2: {
                return new Revision.DateSpec(((SVNRevision.DateSpec)svnRevision).getDate());
            }
            case 7: {
                return Revision.HEAD;
            }
            case 1: {
                return new Revision.Number(((SVNRevision.Number)svnRevision).getNumber());
            }
            case 4: {
                return Revision.PREVIOUS;
            }
            case 0: {
                return Revision.START;
            }
            case 6: {
                return Revision.WORKING;
            }
        }
        log.severe("unknown revision kind :" + svnRevision.getKind());
        return Revision.START;
    }

    public static RevisionRange convert(SVNRevisionRange svnRevisionRange) {
        return new RevisionRange(JhlConverter.convert(svnRevisionRange.getFromRevision()), JhlConverter.convert(svnRevisionRange.getToRevision()));
    }

    public static SVNRevisionRange convert(RevisionRange svnRevisionRange) {
        return new SVNRevisionRange(JhlConverter.convert(svnRevisionRange.getFromRevision()), JhlConverter.convert(svnRevisionRange.getToRevision()));
    }

    public static SVNRevisionRange[] convertRevisionRange(List<RevisionRange> jhlRange) {
        SVNRevisionRange[] range = new SVNRevisionRange[jhlRange.size()];
        int i = 0;
        for (RevisionRange item : jhlRange) {
            range[i] = JhlConverter.convert(item);
            ++i;
        }
        return range;
    }

    public static List<RevisionRange> convert(SVNRevisionRange[] range) {
        ArrayList<RevisionRange> jhlRange = new ArrayList<RevisionRange>(range.length);
        int i = 0;
        while (i < range.length) {
            jhlRange.add(JhlConverter.convert(range[i]));
            ++i;
        }
        return jhlRange;
    }

    public static SVNRevision convert(Revision rev) {
        if (rev == null) {
            return null;
        }
        switch (rev.getKind()) {
            case base: {
                return SVNRevision.BASE;
            }
            case committed: {
                return SVNRevision.COMMITTED;
            }
            case number: {
                Revision.Number n = (Revision.Number)rev;
                if (n.getNumber() == -1L) {
                    return null;
                }
                return new SVNRevision.Number(n.getNumber());
            }
            case previous: {
                return SVNRevision.PREVIOUS;
            }
            case working: {
                return SVNRevision.WORKING;
            }
        }
        return SVNRevision.HEAD;
    }

    static SVNRevision.Number convertRevisionNumber(long revisionNumber) {
        if (revisionNumber == -1L) {
            return null;
        }
        return new SVNRevision.Number(revisionNumber);
    }

    public static SVNNodeKind convertNodeKind(NodeKind javahlNodeKind) {
        if (javahlNodeKind == null) {
            return null;
        }
        switch (javahlNodeKind) {
            case dir: {
                return SVNNodeKind.DIR;
            }
            case file: {
                return SVNNodeKind.FILE;
            }
            case none: {
                return SVNNodeKind.NONE;
            }
            case unknown: {
                return SVNNodeKind.UNKNOWN;
            }
        }
        log.severe("unknown node kind :" + (Object)((Object)javahlNodeKind));
        return SVNNodeKind.UNKNOWN;
    }

    public static JhlStatus convert(Status status, ISVNClient client) {
        return new JhlStatus(status, client);
    }

    public static SVNStatusKind convertStatusKind(Status.Kind kind) {
        if (kind == null) {
            return null;
        }
        switch (kind) {
            case none: {
                return SVNStatusKind.NONE;
            }
            case normal: {
                return SVNStatusKind.NORMAL;
            }
            case added: {
                return SVNStatusKind.ADDED;
            }
            case missing: {
                return SVNStatusKind.MISSING;
            }
            case incomplete: {
                return SVNStatusKind.INCOMPLETE;
            }
            case deleted: {
                return SVNStatusKind.DELETED;
            }
            case replaced: {
                return SVNStatusKind.REPLACED;
            }
            case modified: {
                return SVNStatusKind.MODIFIED;
            }
            case merged: {
                return SVNStatusKind.MERGED;
            }
            case conflicted: {
                return SVNStatusKind.CONFLICTED;
            }
            case obstructed: {
                return SVNStatusKind.OBSTRUCTED;
            }
            case ignored: {
                return SVNStatusKind.IGNORED;
            }
            case external: {
                return SVNStatusKind.EXTERNAL;
            }
            case unversioned: {
                return SVNStatusKind.UNVERSIONED;
            }
        }
        log.severe("unknown status kind :" + (Object)((Object)kind));
        return SVNStatusKind.NONE;
    }

    static JhlDirEntry convert(DirEntry dirEntry) {
        return new JhlDirEntry(dirEntry);
    }

    public static JhlStatus[] convertStatus(List<Status> status, ISVNClient client) {
        JhlStatus[] jhlStatus = new JhlStatus[status.size()];
        int i = 0;
        for (Status stat : status) {
            jhlStatus[i] = new JhlStatus(stat, client);
            ++i;
        }
        return jhlStatus;
    }

    static ISVNLogMessageChangePath[] convertChangePaths(Set<ChangePath> changePaths) {
        if (changePaths == null) {
            return new SVNLogMessageChangePath[0];
        }
        SVNLogMessageChangePath[] jhlChangePaths = new SVNLogMessageChangePath[changePaths.size()];
        int i = 0;
        for (ChangePath path : changePaths) {
            jhlChangePaths[i] = new JhlLogMessageChangePath(path);
            ++i;
        }
        return jhlChangePaths;
    }

    public static SVNScheduleKind convertScheduleKind(Info.ScheduleKind kind) {
        if (kind == null) {
            return null;
        }
        switch (kind) {
            case normal: {
                return SVNScheduleKind.NORMAL;
            }
            case delete: {
                return SVNScheduleKind.DELETE;
            }
            case add: {
                return SVNScheduleKind.ADD;
            }
            case replace: {
                return SVNScheduleKind.REPLACE;
            }
        }
        log.severe("unknown schedule kind :" + (Object)((Object)kind));
        return SVNScheduleKind.NORMAL;
    }

    public static JhlLock convertLock(Lock lock) {
        return new JhlLock(lock);
    }

    public static SVNConflictDescriptor convertConflictDescriptor(ConflictDescriptor d) {
        if (d == null) {
            return null;
        }
        SVNConflictVersion srcLeftVersion = null;
        if (d.getSrcLeftVersion() != null) {
            srcLeftVersion = new SVNConflictVersion(d.getSrcLeftVersion().getReposURL(), d.getSrcLeftVersion().getPegRevision(), d.getSrcLeftVersion().getPathInRepos(), d.getSrcLeftVersion().getNodeKind().ordinal());
        }
        SVNConflictVersion srcRightVersion = null;
        if (d.getSrcRightVersion() != null) {
            srcRightVersion = new SVNConflictVersion(d.getSrcRightVersion().getReposURL(), d.getSrcRightVersion().getPegRevision(), d.getSrcRightVersion().getPathInRepos(), d.getSrcRightVersion().getNodeKind().ordinal());
        }
        return new SVNConflictDescriptor(d.getPath(), d.getKind().ordinal(), d.getNodeKind().ordinal(), d.getPropertyName(), d.isBinary(), d.getMIMEType(), d.getAction().ordinal(), d.getReason().ordinal(), d.getOperation().ordinal(), srcLeftVersion, srcRightVersion, d.getBasePath(), d.getTheirPath(), d.getMyPath(), d.getMergedPath());
    }

    public static SVNConflictResult convertConflictResult(ConflictResult r) {
        return new SVNConflictResult(r.getChoice().ordinal(), r.getMergedPath());
    }

    public static SVNDiffSummary convert(DiffSummary d) {
        return new SVNDiffSummary(d.getPath(), JhlConverter.convert(d.getDiffKind()), d.propsChanged(), d.getNodeKind().ordinal());
    }

    public static SVNDiffSummary.SVNDiffKind convert(DiffSummary.DiffKind d) {
        if (d == DiffSummary.DiffKind.added) {
            return SVNDiffSummary.SVNDiffKind.ADDED;
        }
        if (d == DiffSummary.DiffKind.modified) {
            return SVNDiffSummary.SVNDiffKind.MODIFIED;
        }
        if (d == DiffSummary.DiffKind.deleted) {
            return SVNDiffSummary.SVNDiffKind.DELETED;
        }
        return SVNDiffSummary.SVNDiffKind.NORMAL;
    }

    public static ConflictResult.Choice convert(SVNConflictResult result) {
        if (result == null) {
            return null;
        }
        switch (result.getChoice()) {
            case 1: {
                return ConflictResult.Choice.chooseBase;
            }
            case 6: {
                return ConflictResult.Choice.chooseMerged;
            }
            case 5: {
                return ConflictResult.Choice.chooseMineConflict;
            }
            case 3: {
                return ConflictResult.Choice.chooseMineFull;
            }
            case 4: {
                return ConflictResult.Choice.chooseTheirsConflict;
            }
            case 2: {
                return ConflictResult.Choice.chooseTheirsFull;
            }
            case 0: {
                return ConflictResult.Choice.postpone;
            }
        }
        return ConflictResult.Choice.postpone;
    }

    public static char convert(ChangePath.Action action) {
        switch (action) {
            case add: {
                return 'A';
            }
            case delete: {
                return 'D';
            }
            case modify: {
                return 'M';
            }
            case replace: {
                return 'R';
            }
        }
        return '?';
    }

    public static Depth depth(int depthValue) {
        switch (depthValue) {
            case 2: {
                return Depth.empty;
            }
            case 3: {
                return Depth.files;
            }
            case 4: {
                return Depth.immediates;
            }
            case 5: {
                return Depth.infinity;
            }
            case 1: {
                return Depth.exclude;
            }
        }
        return Depth.unknown;
    }
}

