/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.livexp.core;

import com.google.common.base.Function;
import org.eclipse.core.runtime.ListenerList;
import org.springsource.ide.eclipse.commons.livexp.core.DisposeListener;
import org.springsource.ide.eclipse.commons.livexp.core.OnDispose;
import org.springsource.ide.eclipse.commons.livexp.core.ValueListener;
import org.springsource.ide.eclipse.commons.livexp.ui.Disposable;

public abstract class LiveExpression<V>
implements Disposable,
OnDispose {
    public static final LiveExpression<Boolean> TRUE = LiveExpression.constant(true);
    public static final LiveExpression<Boolean> FALSE = LiveExpression.constant(false);
    private ListenerList fListeners = new ListenerList();
    private ListenerList fDisposeHandlers = new ListenerList();
    protected Object owner = null;
    protected V value;

    public LiveExpression(V initialValue, Object owner) {
        this.value = initialValue;
        this.owner = owner;
    }

    public LiveExpression(V initialValue) {
        this(initialValue, null);
    }

    public LiveExpression() {
        this(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        boolean changed = false;
        LiveExpression liveExpression = this;
        synchronized (liveExpression) {
            V newValue = this.compute();
            if (!LiveExpression.equals(newValue, this.value)) {
                this.value = newValue;
                changed = true;
            }
        }
        if (changed) {
            this.changed();
        }
    }

    private static <V> boolean equals(V a, V b) {
        if (a == null || b == null) {
            return a == b;
        }
        return a.equals(b);
    }

    public <O> LiveExpression<V> dependsOn(final LiveExpression<O> other) {
        final ValueListener listener = new ValueListener<O>(){

            @Override
            public void gotValue(LiveExpression<O> exp, O value) {
                LiveExpression.this.refresh();
            }
        };
        other.addListener(listener);
        this.onDispose(new DisposeListener(){

            @Override
            public void disposed(Disposable disposed) {
                other.removeListener(listener);
            }
        });
        return this;
    }

    protected abstract V compute();

    protected void changed() {
        if (this.fListeners != null) {
            Object[] listeners;
            Object[] objectArray = listeners = this.fListeners.getListeners();
            int n = listeners.length;
            int n2 = 0;
            while (n2 < n) {
                Object _l = objectArray[n2];
                ValueListener l = (ValueListener)_l;
                l.gotValue(this, this.value);
                ++n2;
            }
        }
    }

    public V getValue() {
        return this.value;
    }

    public void addListener(ValueListener<V> l) {
        this.fListeners.add(l);
        l.gotValue(this, this.value);
    }

    public void removeListener(ValueListener<V> l) {
        if (this.fListeners != null) {
            this.fListeners.remove(l);
        }
    }

    public static <V> LiveExpression<V> constant(V value) {
        return new LiveExpression<V>((Object)value){

            @Override
            protected V compute() {
                return this.value;
            }

            @Override
            public void addListener(ValueListener<V> l) {
                l.gotValue(this, this.value);
            }

            @Override
            public void removeListener(ValueListener<V> l) {
            }

            @Override
            public void refresh() {
            }
        };
    }

    public <T> LiveExpression<T> filter(final Class<T> klass) {
        final LiveExpression target = this;
        return new LiveExpression<T>(){
            {
                this.dependsOn(liveExpression2);
            }

            @Override
            protected T compute() {
                Object input = target.getValue();
                if (klass.isInstance(input)) {
                    return input;
                }
                return null;
            }
        };
    }

    public <R> LiveExpression<R> apply(final Function<V, R> fun) {
        final LiveExpression target = this;
        LiveExpression result = new LiveExpression<R>(){
            {
                this.dependsOn(liveExpression2);
            }

            @Override
            protected R compute() {
                return fun.apply(target.getValue());
            }
        };
        return result;
    }

    public Object getOwner() {
        return this.owner;
    }

    public <T> T getOwner(Class<T> cls) {
        if (this.owner != null && cls.isAssignableFrom(this.owner.getClass())) {
            return (T)this.owner;
        }
        return null;
    }

    @Override
    public void dispose() {
        if (this.fDisposeHandlers != null) {
            Object[] objectArray = this.fDisposeHandlers.getListeners();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object _handler = objectArray[n2];
                DisposeListener handler = (DisposeListener)_handler;
                handler.disposed(this);
                ++n2;
            }
            this.fDisposeHandlers = null;
        }
        this.fListeners = null;
    }

    @Override
    public void onDispose(DisposeListener listener) {
        this.fDisposeHandlers.add((Object)listener);
    }

    public void setOwner(Object owner) {
        this.owner = owner;
    }
}

