/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.livexp.core;

import com.google.common.collect.ImmutableSet;
import java.util.concurrent.Callable;
import org.eclipse.core.runtime.Assert;
import org.springsource.ide.eclipse.commons.livexp.Activator;
import org.springsource.ide.eclipse.commons.livexp.core.AsyncLiveExpression;
import org.springsource.ide.eclipse.commons.livexp.core.ValueListener;

public abstract class ObservableSet<T>
extends AsyncLiveExpression<ImmutableSet<T>> {
    public ObservableSet() {
        this(ImmutableSet.of(), AsyncLiveExpression.AsyncMode.SYNC, AsyncLiveExpression.AsyncMode.SYNC);
    }

    public ObservableSet(ImmutableSet<T> initialValue, AsyncLiveExpression.AsyncMode refreshMode, AsyncLiveExpression.AsyncMode eventsMode) {
        super(initialValue, refreshMode, eventsMode);
    }

    public static <T> ObservableSet<T> constant(ImmutableSet<T> value) {
        return new ObservableSet<T>((ImmutableSet)value, AsyncLiveExpression.AsyncMode.SYNC, AsyncLiveExpression.AsyncMode.SYNC){

            @Override
            protected ImmutableSet<T> compute() {
                return (ImmutableSet)this.value;
            }

            @Override
            public void addListener(ValueListener<ImmutableSet<T>> l) {
                l.gotValue(this, (ImmutableSet)this.value);
            }

            @Override
            public void removeListener(ValueListener<ImmutableSet<T>> l) {
            }

            @Override
            public void syncRefresh() {
            }
        };
    }

    public ImmutableSet<T> getValues() {
        return (ImmutableSet)this.getValue();
    }

    public boolean contains(T e) {
        return this.getValues().contains(e);
    }

    public static <T> ObservableSet<T> create(Callable<ImmutableSet<T>> computer) {
        Builder<T> bldr = ObservableSet.builder();
        return bldr.compute(computer).build();
    }

    public static <T> Builder<T> builder() {
        return new Builder();
    }

    public static class Builder<T> {
        private ImmutableSet<T> initialValue = ImmutableSet.of();
        private AsyncLiveExpression.AsyncMode refreshMode = AsyncLiveExpression.AsyncMode.SYNC;
        private AsyncLiveExpression.AsyncMode eventsMode = AsyncLiveExpression.AsyncMode.SYNC;
        private Callable<ImmutableSet<T>> computer = null;

        public Builder<T> events(AsyncLiveExpression.AsyncMode eventsMode) {
            this.eventsMode = eventsMode;
            return this;
        }

        public Builder<T> refresh(AsyncLiveExpression.AsyncMode refreshMode) {
            this.refreshMode = refreshMode;
            return this;
        }

        public ObservableSet<T> build() {
            Assert.isNotNull(this.computer, (String)"'compute' function must be specified");
            return new ObservableSet<T>(this.initialValue, this.refreshMode, this.eventsMode){

                @Override
                protected ImmutableSet<T> compute() {
                    try {
                        return (ImmutableSet)computer.call();
                    }
                    catch (Exception e) {
                        Activator.log(e);
                        return this.getValues();
                    }
                }
            };
        }

        public Builder<T> compute(Callable<ImmutableSet<T>> computer) {
            this.computer = computer;
            return this;
        }
    }
}

