/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.livexp.core.validators;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.springsource.ide.eclipse.commons.livexp.core.LiveExpression;
import org.springsource.ide.eclipse.commons.livexp.core.LiveVariable;
import org.springsource.ide.eclipse.commons.livexp.core.StringFieldModel;
import org.springsource.ide.eclipse.commons.livexp.core.ValidationResult;

public class UrlValidator
extends LiveExpression<ValidationResult> {
    private String fieldName;
    private LiveExpression<String> url;
    private boolean nullable;
    private Set<String> allowedSchemes = null;

    public UrlValidator(String fieldName, LiveVariable<String> url) {
        this(fieldName, url, false);
    }

    public UrlValidator(String fieldName, LiveExpression<String> url, boolean nullable) {
        this.fieldName = fieldName;
        this.url = url;
        this.nullable = nullable;
        this.dependsOn(url);
    }

    public UrlValidator(StringFieldModel field) {
        this(field.getLabel(), field.getVariable());
    }

    @Override
    protected ValidationResult compute() {
        String str = this.url.getValue();
        str = str == null ? "" : str.trim();
        if (this.nullable && str.equals("")) {
            return ValidationResult.OK;
        }
        if (!this.nullable && "".equals(str)) {
            return ValidationResult.error(String.valueOf(this.fieldName) + " needs to be provided");
        }
        try {
            URI uri = new URI(str);
            if (this.allowedSchemes != null && !this.allowedSchemes.contains(uri.getScheme())) {
                return ValidationResult.error(String.valueOf(this.fieldName) + " url scheme should be one of: " + this.allowedSchemes);
            }
        }
        catch (URISyntaxException e) {
            return ValidationResult.error(String.valueOf(this.fieldName) + " is not a valid URL: URISyntaxException " + e.getMessage());
        }
        return ValidationResult.OK;
    }

    public UrlValidator allowedSchemes(String ... schemes) {
        this.allowedSchemes = Collections.unmodifiableSet(new LinkedHashSet<String>(Arrays.asList(schemes)));
        return this;
    }
}

