/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.livexp.ui;

import java.util.concurrent.Callable;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.springsource.ide.eclipse.commons.livexp.Activator;
import org.springsource.ide.eclipse.commons.livexp.ui.IPageWithSections;
import org.springsource.ide.eclipse.commons.livexp.ui.WizardPageSection;

public class ButtonSection
extends WizardPageSection {
    private String label;
    private String tooltip;
    private Callable<Void> clickHandler;

    public ButtonSection(IPageWithSections owner, String label, Runnable clickHandler) {
        this(owner, label, () -> {
            clickHandler.run();
            return null;
        });
    }

    public ButtonSection(IPageWithSections owner, String label, Callable<Void> clickHandler) {
        super(owner);
        this.label = label;
        this.clickHandler = clickHandler;
    }

    @Override
    public void createContents(Composite page) {
        Button button = new Button(page, 8);
        button.setText(this.label);
        if (this.tooltip != null) {
            button.setToolTipText(this.tooltip);
        }
        this.applyLayoutData(button);
        button.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent arg0) {
                try {
                    ButtonSection.this.clickHandler.call();
                }
                catch (Exception e) {
                    Activator.log(e);
                }
            }

            public void widgetDefaultSelected(SelectionEvent arg0) {
                this.widgetSelected(arg0);
            }
        });
    }

    public ButtonSection tooltip(String tooltip) {
        this.tooltip = tooltip;
        return this;
    }

    protected void applyLayoutData(Button button) {
        GridDataFactory.fillDefaults().align(0x1000008, 0x1000000).applyTo((Control)button);
    }
}

