/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.livexp.ui;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.springsource.ide.eclipse.commons.livexp.core.LiveExpression;
import org.springsource.ide.eclipse.commons.livexp.core.LiveSet;
import org.springsource.ide.eclipse.commons.livexp.core.ValidationResult;
import org.springsource.ide.eclipse.commons.livexp.ui.IPageWithSections;
import org.springsource.ide.eclipse.commons.livexp.ui.Ilabelable;
import org.springsource.ide.eclipse.commons.livexp.ui.UIConstants;
import org.springsource.ide.eclipse.commons.livexp.ui.WizardPageSection;

public class ChooseMultipleSection<T extends Ilabelable>
extends WizardPageSection {
    private static final boolean DEBUG = false;
    private String labelText;
    private Ilabelable[] validChoices;
    private LiveSet<T> chosen;
    private LiveExpression<ValidationResult> validator;

    public ChooseMultipleSection(IPageWithSections owner, String labelText, T[] validChoices, LiveSet<T> chosen, LiveExpression<ValidationResult> validator) {
        super(owner);
        this.labelText = labelText;
        this.validChoices = validChoices;
        this.chosen = chosen;
        this.validator = validator;
    }

    @Override
    public LiveExpression<ValidationResult> getValidator() {
        return this.validator;
    }

    @Override
    public void createContents(Composite page) {
        Composite composite = new Composite(page, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        GridDataFactory grab = GridDataFactory.fillDefaults().grab(true, true).hint(-1, 200);
        grab.applyTo((Control)composite);
        composite.setLayoutData((Object)new GridData(768));
        Label label = new Label(composite, 0);
        label.setText(this.labelText);
        GridDataFactory.fillDefaults().align(0x1000000, 1).hint(UIConstants.fieldLabelWidthHint((Control)label), -1).applyTo((Control)label);
        CheckboxTableViewer tv = CheckboxTableViewer.newCheckList((Composite)composite, (int)2048);
        grab.applyTo((Control)tv.getTable());
        tv.setContentProvider((IContentProvider)new ContentProvider());
        tv.setLabelProvider((IBaseLabelProvider)new LabelProvider());
        tv.setInput((Object)this.validChoices);
        tv.setCheckedElements(this.chosen.getValues().toArray());
        tv.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Ilabelable e = (Ilabelable)event.getElement();
                boolean checked = event.getChecked();
                if (checked) {
                    ChooseMultipleSection.this.chosen.add(e);
                } else {
                    ChooseMultipleSection.this.chosen.remove(e);
                }
            }
        });
    }

    class ContentProvider
    implements IStructuredContentProvider {
        ContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return ChooseMultipleSection.this.validChoices;
        }
    }

    public class LabelProvider
    implements ILabelProvider {
        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }

        public Image getImage(Object element) {
            return null;
        }

        public String getText(Object element) {
            if (element instanceof Ilabelable) {
                return ((Ilabelable)element).getLabel();
            }
            return "" + element;
        }
    }
}

