/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.livexp.ui;

import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.springsource.ide.eclipse.commons.livexp.core.LiveExpression;
import org.springsource.ide.eclipse.commons.livexp.core.LiveVariable;
import org.springsource.ide.eclipse.commons.livexp.core.ValidationResult;
import org.springsource.ide.eclipse.commons.livexp.core.ValueListener;
import org.springsource.ide.eclipse.commons.livexp.ui.IPageWithOkButton;
import org.springsource.ide.eclipse.commons.livexp.ui.IPageWithSections;
import org.springsource.ide.eclipse.commons.livexp.ui.Ilabelable;
import org.springsource.ide.eclipse.commons.livexp.ui.SimpleLabelProvider;
import org.springsource.ide.eclipse.commons.livexp.ui.UIConstants;
import org.springsource.ide.eclipse.commons.livexp.ui.WizardPageSection;

public class ChooseOneSection<T extends Ilabelable>
extends WizardPageSection {
    private static final boolean DEBUG = ("" + Platform.getLocation()).contains("kdvolder");
    private String labelText;
    private Ilabelable[] validChoices;
    private LiveVariable<T> chosen;
    private LiveExpression<ValidationResult> validator;
    private boolean vertical = false;

    public ChooseOneSection(IPageWithSections owner, String labelText, T[] validChoices, LiveVariable<T> chosen, LiveExpression<ValidationResult> validator) {
        super(owner);
        this.labelText = labelText;
        this.validChoices = validChoices;
        this.chosen = chosen;
        this.validator = validator;
    }

    @Override
    public LiveExpression<ValidationResult> getValidator() {
        return this.validator;
    }

    private T getSingleSelection(ListViewer lv) {
        ISelection sel;
        if (lv != null && (sel = lv.getSelection()) instanceof IStructuredSelection) {
            return (T)((Ilabelable)((IStructuredSelection)sel).getFirstElement());
        }
        return null;
    }

    @Override
    public void createContents(Composite page) {
        Composite composite = new Composite(page, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = this.labelText == null || this.vertical ? 1 : 2;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        GridDataFactory grab = GridDataFactory.fillDefaults().grab(true, true);
        grab.applyTo((Control)composite);
        composite.setLayoutData((Object)new GridData(768));
        if (this.labelText != null) {
            Label label = new Label(composite, 0);
            label.setText(this.labelText);
            if (!this.vertical) {
                GridDataFactory.fillDefaults().align(0x1000000, 1).hint(UIConstants.fieldLabelWidthHint((Control)label), -1).applyTo((Control)label);
            }
        }
        final ListViewer tv = new ListViewer(composite, 2564);
        grab.applyTo((Control)tv.getList());
        tv.setContentProvider((IContentProvider)new ContentProvider());
        tv.setLabelProvider((IBaseLabelProvider)new SimpleLabelProvider());
        tv.setInput((Object)this.validChoices);
        this.chosen.addListener(new ValueListener<T>(){

            @Override
            public void gotValue(LiveExpression<T> exp, T value) {
                if (value == null) {
                    tv.setSelection((ISelection)StructuredSelection.EMPTY);
                } else {
                    tv.setSelection((ISelection)new StructuredSelection(value));
                }
            }
        });
        if (DEBUG) {
            this.chosen.addListener(new ValueListener<T>(){

                @Override
                public void gotValue(LiveExpression<T> exp, T value) {
                    System.out.println("starter: " + value);
                }
            });
        }
        tv.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ChooseOneSection.this.chosen.setValue(ChooseOneSection.this.getSingleSelection(tv));
            }
        });
        if (this.owner instanceof IPageWithOkButton) {
            tv.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    ((IPageWithOkButton)ChooseOneSection.this.owner).clickOk();
                }
            });
        }
    }

    public ChooseOneSection<T> vertical() {
        this.vertical = true;
        return this;
    }

    class ContentProvider
    implements IStructuredContentProvider {
        ContentProvider() {
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getElements(Object inputElement) {
            return ChooseOneSection.this.validChoices;
        }
    }
}

