/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.livexp.ui;

import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.springsource.ide.eclipse.commons.livexp.core.FieldModel;
import org.springsource.ide.eclipse.commons.livexp.core.LiveExpression;
import org.springsource.ide.eclipse.commons.livexp.core.LiveVariable;
import org.springsource.ide.eclipse.commons.livexp.core.UIValueListener;
import org.springsource.ide.eclipse.commons.livexp.core.ValidationResult;
import org.springsource.ide.eclipse.commons.livexp.core.Validator;
import org.springsource.ide.eclipse.commons.livexp.ui.IPageWithSections;
import org.springsource.ide.eclipse.commons.livexp.ui.UIConstants;
import org.springsource.ide.eclipse.commons.livexp.ui.WizardPageSection;

public class StringFieldSection
extends WizardPageSection {
    private String labelText;
    private String tooltip = null;
    private final LiveVariable<String> variable;
    private final LiveExpression<ValidationResult> validator;
    private LiveExpression<Boolean> enabler = LiveExpression.constant(true);
    private Text text;
    private boolean password = false;

    public StringFieldSection(IPageWithSections owner, String labelText, LiveVariable<String> variable, LiveExpression<ValidationResult> validator) {
        super(owner);
        this.labelText = labelText;
        this.variable = variable;
        this.validator = validator;
    }

    public StringFieldSection(IPageWithSections owner, FieldModel<String> f) {
        this(owner, f.getLabel(), f.getVariable(), f.getValidator());
    }

    public StringFieldSection(IPageWithSections owner, String label, LiveVariable<String> variable) {
        this(owner, label, variable, Validator.OK);
    }

    @Override
    public LiveExpression<ValidationResult> getValidator() {
        return this.validator;
    }

    public StringFieldSection setPassword(boolean enablePasswordBehavior) {
        this.password = enablePasswordBehavior;
        return this;
    }

    @Override
    public void createContents(Composite page) {
        Composite projectGroup = new Composite(page, 0);
        GridLayout layout = GridLayoutFactory.fillDefaults().numColumns(2).margins(0, 2).create();
        projectGroup.setLayout((Layout)layout);
        projectGroup.setLayoutData((Object)new GridData(768));
        Label label = new Label(projectGroup, 0);
        label.setText(this.labelText);
        GridDataFactory.fillDefaults().hint(UIConstants.fieldLabelWidthHint((Control)label), -1).align(1, 0x1000000).applyTo((Control)label);
        this.text = new Text(projectGroup, 0x800 | (this.password ? 0x400000 : 0));
        GridData data = new GridData(768);
        data.widthHint = 250;
        this.text.setLayoutData((Object)data);
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                StringFieldSection.this.variable.setValue(StringFieldSection.this.text.getText());
            }
        });
        this.variable.addListener(UIValueListener.from((exp, value) -> {
            if (this.text != null && !this.text.isDisposed()) {
                String oldText;
                if (value == null) {
                    value = "";
                }
                if (!(oldText = this.text.getText()).equals(value)) {
                    this.text.setText(value);
                }
            }
        }));
        this.enabler.addListener(UIValueListener.from((exp, enable) -> this.text.setEnabled(enable.booleanValue())));
        if (this.tooltip != null) {
            label.setToolTipText(this.tooltip);
            this.text.setToolTipText(this.tooltip);
        }
    }

    public StringFieldSection tooltip(String string) {
        this.tooltip = string;
        return this;
    }

    public StringFieldSection setEnabler(LiveExpression<Boolean> enable) {
        this.enabler = enable;
        return this;
    }
}

