/*
 * Decompiled with CFR 0.152.
 */
package org.springsource.ide.eclipse.commons.livexp.util;

import org.springsource.ide.eclipse.commons.livexp.core.LiveExpression;
import org.springsource.ide.eclipse.commons.livexp.util.Filter;

public class Filters {
    private static final Filter ACCEPT_ALL = new Filter(){

        public boolean accept(Object t) {
            return true;
        }
    };

    public static <T> Filter<T> acceptAll() {
        return ACCEPT_ALL;
    }

    public static <T> Filter<T> compose(final Filter<T> f1, final Filter<T> f2) {
        if (f1 == ACCEPT_ALL) {
            return f2;
        }
        if (f2 == ACCEPT_ALL) {
            return f1;
        }
        return new Filter<T>(){

            @Override
            public boolean accept(T t) {
                return f1.accept(t) && f2.accept(t);
            }
        };
    }

    public static <T> LiveExpression<Filter<T>> compose(final LiveExpression<Filter<T>> f1, final LiveExpression<Filter<T>> f2) {
        Filter<T> initial = Filters.acceptAll();
        return new LiveExpression<Filter<T>>(initial){
            {
                super($anonymous0);
                this.dependsOn(liveExpression);
                this.dependsOn(liveExpression2);
            }

            @Override
            protected Filter<T> compute() {
                return Filters.compose((Filter)f1.getValue(), (Filter)f2.getValue());
            }
        };
    }
}

