/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter.javahl;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import org.tigris.subversion.svnclientadapter.ISVNProperty;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class JhlPropertyData
implements ISVNProperty {
    private String key;
    private byte[] data;
    private String path;
    private boolean isForUrl;

    public static JhlPropertyData newForFile(String path, String key, byte[] data) {
        return new JhlPropertyData(path, key, data, false);
    }

    public static JhlPropertyData newForUrl(String path, String key, byte[] data) {
        return new JhlPropertyData(path, key, data, true);
    }

    private JhlPropertyData(String path, String key, byte[] data, boolean isForUrl) {
        this.path = path;
        this.key = key;
        this.data = data;
        this.isForUrl = isForUrl;
    }

    public String getName() {
        return this.key;
    }

    public String getValue() {
        try {
            return new String(this.data, "UTF8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return new String(this.data);
        }
    }

    public File getFile() {
        return this.isForUrl ? null : new File(this.path).getAbsoluteFile();
    }

    public SVNUrl getUrl() {
        try {
            return this.isForUrl ? new SVNUrl(this.path) : null;
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public byte[] getData() {
        return this.data;
    }
}

