/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.completions;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaProject;
import org.springframework.ide.eclipse.boot.completions.SpringBootTypeDiscovery;
import org.springframework.ide.eclipse.boot.core.BootActivator;
import org.springframework.ide.eclipse.boot.core.BootPropertyTester;
import org.springframework.ide.eclipse.boot.core.ISpringBootProject;
import org.springframework.ide.eclipse.boot.core.SpringBootCore;
import org.springsource.ide.eclipse.commons.completions.externaltype.ExternalTypeDiscovery;
import org.springsource.ide.eclipse.commons.completions.externaltype.ExternalTypeDiscoveryFactory;
import org.springsource.ide.eclipse.commons.core.SpringCoreUtils;

public class SpringBootTypeDiscoveryFactory
implements ExternalTypeDiscoveryFactory {
    private Map<String, SpringBootTypeDiscovery> instances;

    public ExternalTypeDiscovery discoveryFor(IJavaProject jproject) {
        if (this.isApplicable(jproject)) {
            try {
                ISpringBootProject project = SpringBootCore.create(jproject);
                if (project != null) {
                    return this.discoveryFor(project.getBootVersion());
                }
            }
            catch (Exception e) {
                BootActivator.log(e);
            }
            return this.discoveryFor(SpringBootCore.getDefaultBootVersion());
        }
        return null;
    }

    private synchronized ExternalTypeDiscovery discoveryFor(String bootVersion) {
        SpringBootTypeDiscovery existing;
        if (this.instances == null) {
            this.instances = new HashMap<String, SpringBootTypeDiscovery>();
        }
        if ((existing = this.instances.get(bootVersion)) == null) {
            existing = new SpringBootTypeDiscovery(bootVersion);
            this.instances.put(bootVersion, existing);
        }
        return existing;
    }

    private boolean isApplicable(IJavaProject javaProject) {
        IProject project = javaProject.getProject();
        return SpringCoreUtils.hasNature((IResource)project, (String)"org.springframework.ide.eclipse.core.springnature") && BootPropertyTester.isBootProject(project);
    }
}

