/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.core;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.springframework.ide.eclipse.boot.util.Log;
import org.springsource.ide.eclipse.commons.frameworks.core.downloadmanager.URLConnectionFactory;

public class BootActivator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.springframework.ide.eclipse.boot";
    private static BootActivator plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static BootActivator getDefault() {
        return plugin;
    }

    public static IStatus createErrorStatus(Throwable exception) {
        String message = exception.getMessage();
        if (message == null) {
            message = "";
        }
        return new Status(4, PLUGIN_ID, 0, message, exception);
    }

    public static IStatus createInfoStatus(String msg) {
        return new Status(1, PLUGIN_ID, msg);
    }

    @Deprecated
    public static void log(Throwable e) {
        Log.log(e);
    }

    @Deprecated
    public static void info(String msg) {
        Log.info(msg);
    }

    public static URLConnectionFactory getUrlConnectionFactory() {
        final String userAgent = "STS/" + BootActivator.getDefault().getBundle().getVersion();
        return new URLConnectionFactory(){

            public URLConnection createConnection(URL url) throws IOException {
                URLConnection conn = super.createConnection(url);
                conn.addRequestProperty("User-Agent", userAgent);
                return conn;
            }
        };
    }
}

