/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.core;

import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.springframework.ide.eclipse.boot.core.BootActivator;
import org.springframework.ide.eclipse.boot.util.Log;
import org.springsource.ide.eclipse.commons.livexp.core.LiveExpression;

public class BootPreferences
implements IEclipsePreferences.IPreferenceChangeListener {
    public static final String PREF_BOOT_PROJECT_EXCLUDE = "org.springframework.ide.eclipse.boot.project.exclude";
    public static final Pattern DEFAULT_BOOT_PROJECT_EXCLUDE = Pattern.compile("^$");
    public static final String PREF_IGNORE_SILENT_EXIT = "org.springframework.ide.eclipse.boot.ignore.silent.exit";
    public static final boolean DEFAULT_PREF_IGNORE_SILENT_EXIT = true;
    public static final String PREF_INITIALIZR_URL = "org.springframework.ide.eclipse.boot.wizard.initializr.url";
    public static final String BOOT_PREFERENCE_PAGE_ID = "org.springframework.ide.eclipse.boot.ui.preferences.BootPreferencePage";
    private static BootPreferences INSTANCE = null;
    private IEclipsePreferences prefs;
    private final LiveExpression<Pattern> projectExclude = new LiveExpression<Pattern>(DEFAULT_BOOT_PROJECT_EXCLUDE){

        protected Pattern compute() {
            return BootPreferences.this.compileProjectExclude();
        }
    };

    private BootPreferences() {
        this.prefs = this.getPrefs();
        this.prefs.addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        this.projectExclude.refresh();
    }

    public static synchronized BootPreferences getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new BootPreferences();
        }
        return INSTANCE;
    }

    protected IEclipsePreferences getPrefs() {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode("org.springframework.ide.eclipse.boot");
        return prefs;
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        if (event.getKey().equals(PREF_BOOT_PROJECT_EXCLUDE)) {
            this.projectExclude.refresh();
        }
    }

    public boolean isIgnoreSilentExit() {
        try {
            return this.prefs.getBoolean(PREF_IGNORE_SILENT_EXIT, true);
        }
        catch (Exception e) {
            Log.log(e);
            return true;
        }
    }

    public Pattern getProjectExclusion() {
        return (Pattern)this.projectExclude.getValue();
    }

    private Pattern compileProjectExclude() {
        try {
            String patternString;
            if (this.prefs != null && StringUtils.isNotBlank((CharSequence)(patternString = this.prefs.get(PREF_BOOT_PROJECT_EXCLUDE, null)))) {
                return Pattern.compile(patternString);
            }
        }
        catch (Exception e) {
            Log.log(e);
        }
        return Pattern.compile("^$");
    }

    public LiveExpression<Pattern> getProjectExclusionExp() {
        return this.projectExclude;
    }

    public static String getInitializrUrl() {
        return BootActivator.getDefault().getPreferenceStore().getString(PREF_INITIALIZR_URL);
    }

    public static String getDefaultInitializrUrl() {
        return BootActivator.getDefault().getPreferenceStore().getDefaultString(PREF_INITIALIZR_URL);
    }
}

