/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.core;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.osgi.framework.Bundle;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;
import org.springframework.ide.eclipse.boot.core.BootActivator;
import org.springframework.ide.eclipse.boot.core.BootPreferences;
import org.springframework.ide.eclipse.boot.util.Log;
import org.springsource.ide.eclipse.commons.internal.core.CorePlugin;

public class BootPropertyTester
extends PropertyTester {
    private static final Pattern JAR_VERSION_REGEXP = Pattern.compile(".*\\-([^.]+\\.[^.]+\\.[^.]+\\.[^.]+)\\.jar");

    public boolean test(Object rsrc, String property, Object[] args, Object expectedValue) {
        if (expectedValue == null) {
            expectedValue = true;
        }
        if (rsrc instanceof IProject && "isBootProject".equals(property)) {
            return expectedValue.equals(BootPropertyTester.isBootProject((IProject)rsrc));
        }
        if (rsrc instanceof IResource && "isBootResource".equals(property)) {
            return expectedValue.equals(BootPropertyTester.isBootResource((IResource)rsrc));
        }
        return false;
    }

    public static boolean isDevtoolsJar(IClasspathEntry e) {
        if (e.getEntryKind() == 1) {
            IPath path = e.getPath();
            String name = path.lastSegment();
            return name.endsWith(".jar") && name.startsWith("spring-boot-devtools");
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean hasDevtools(IProject p) {
        try {
            if (p == null) return false;
            if (!p.isAccessible()) return false;
            IJavaProject jp = JavaCore.create((IProject)p);
            if (!jp.exists()) return false;
            IClasspathEntry[] classpath = jp.getResolvedClasspath(true);
            if (classpath == null) return false;
            IClasspathEntry[] iClasspathEntryArray = classpath;
            int n = classpath.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IClasspathEntry e = iClasspathEntryArray[n2];
                if (BootPropertyTester.isDevtoolsJar(e)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (Exception e) {
            Log.log(e);
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isBootProject(IProject project) {
        if (project == null) return false;
        if (!project.isAccessible()) {
            return false;
        }
        try {
            IClasspathEntry[] classpath;
            if (!project.hasNature("org.eclipse.jdt.core.javanature")) return false;
            if (BootPropertyTester.isExcludedProject(project)) return false;
            IJavaProject jp = JavaCore.create((IProject)project);
            IClasspathEntry[] iClasspathEntryArray = classpath = jp.getResolvedClasspath(true);
            int n = classpath.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IClasspathEntry e = iClasspathEntryArray[n2];
                if (BootPropertyTester.isBootJar(e)) return true;
                if (BootPropertyTester.isBootProject(e)) {
                    return true;
                }
                ++n2;
            }
        }
        catch (Exception e) {
            CorePlugin.log((Throwable)e);
        }
        return false;
    }

    private static boolean isExcludedProject(IProject project) {
        Pattern exclusion = BootPreferences.getInstance().getProjectExclusion();
        return exclusion.matcher(project.getName()).matches();
    }

    public static boolean isBootResource(IResource rsrc) {
        if (rsrc == null || !rsrc.isAccessible()) {
            return false;
        }
        boolean result = BootPropertyTester.isBootProject(rsrc.getProject());
        return result;
    }

    public static boolean isBootProject(IClasspathEntry e) {
        if (e.getEntryKind() == 2) {
            IPath path = e.getPath();
            String name = path.lastSegment();
            return name.startsWith("spring-boot");
        }
        return false;
    }

    public static boolean isBootJar(IClasspathEntry e) {
        if (e.getEntryKind() == 1) {
            IPath path = e.getPath();
            String name = path.lastSegment();
            return name.endsWith(".jar") && name.startsWith("spring-boot");
        }
        return false;
    }

    public static Version getBootVersion(IProject p) {
        try {
            if (p.isAccessible() && p.hasNature("org.eclipse.jdt.core.javanature")) {
                IClasspathEntry[] cp;
                IJavaProject jp = JavaCore.create((IProject)p);
                IClasspathEntry[] iClasspathEntryArray = cp = jp.getResolvedClasspath(true);
                int n = cp.length;
                int n2 = 0;
                while (n2 < n) {
                    String version;
                    IClasspathEntry e = iClasspathEntryArray[n2];
                    if (BootPropertyTester.isBootJar(e) && (version = BootPropertyTester.getJarVersion(e)) != null) {
                        return new Version(version);
                    }
                    ++n2;
                }
            }
        }
        catch (Exception error) {
            BootActivator.log(error);
        }
        return null;
    }

    private static String getJarVersion(IClasspathEntry e) {
        Pattern regexp = JAR_VERSION_REGEXP;
        String name = e.getPath().lastSegment();
        Matcher matcher = regexp.matcher(name);
        if (matcher.matches()) {
            String versionStr = matcher.group(1);
            return versionStr;
        }
        return null;
    }

    public static boolean supportsLifeCycleManagement(IProject project) {
        Version version = BootPropertyTester.getBootVersion(project);
        if (version != null) {
            return new VersionRange("1.3.0").includes(version);
        }
        return false;
    }

    public static boolean workaroundMavenBundleInitializationIssue(IProject project) {
        try {
            Bundle bundle;
            if (project.hasNature("org.eclipse.m2e.core.maven2Nature") && (bundle = Platform.getBundle((String)"org.eclipse.m2e.jdt")) != null && bundle.getState() != 32) {
                return true;
            }
        }
        catch (CoreException coreException) {}
        return false;
    }
}

