/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.core;

import java.util.Collection;
import org.eclipse.core.runtime.Assert;
import org.springframework.ide.eclipse.boot.core.MavenCoordinates;
import org.springsource.ide.eclipse.commons.completions.externaltype.ExternalType;
import org.springsource.ide.eclipse.commons.livexp.core.BooleanFieldModel;
import org.springsource.ide.eclipse.commons.livexp.core.LiveExpression;
import org.springsource.ide.eclipse.commons.livexp.core.LiveVariable;
import org.springsource.ide.eclipse.commons.livexp.core.ValidationResult;
import org.springsource.ide.eclipse.commons.livexp.core.Validator;
import org.springsource.ide.eclipse.commons.livexp.ui.OkButtonHandler;

public class ChooseDependencyModel
implements OkButtonHandler {
    public final MavenCoordinates[] availableChoices;
    public final LiveVariable<MavenCoordinates> selected = new LiveVariable();
    public final LiveExpression<ValidationResult> validator = Validator.notNull(this.selected, (String)"No dependency selected");
    public final BooleanFieldModel disableJarTypeAssist = new BooleanFieldModel("disableJarTypeAssist", false);
    public final LiveExpression<String> previewText;
    private boolean okPerformed;
    private String dependencyFileName;
    private ExternalType type;

    public ChooseDependencyModel(Collection<MavenCoordinates> availableChoices, String dependencyFileName, ExternalType type) {
        this.disableJarTypeAssist.label("Don't ask again (disables Jar Type Search content assistant)");
        this.previewText = new LiveExpression<String>(""){
            {
                this.dependsOn((LiveExpression)ChooseDependencyModel.this.selected);
            }

            protected String compute() {
                MavenCoordinates d = (MavenCoordinates)ChooseDependencyModel.this.selected.getValue();
                if (d != null) {
                    return d.toXmlString();
                }
                return "";
            }
        };
        this.okPerformed = false;
        this.type = type;
        this.dependencyFileName = dependencyFileName;
        Assert.isLegal((!availableChoices.isEmpty() ? 1 : 0) != 0);
        this.availableChoices = availableChoices.toArray(new MavenCoordinates[availableChoices.size()]);
        this.selected.setValue((Object)this.availableChoices[0]);
    }

    public MavenCoordinates getResult() {
        if (this.okPerformed && !((Boolean)this.disableJarTypeAssist.getValue()).booleanValue()) {
            return (MavenCoordinates)this.selected.getValue();
        }
        return null;
    }

    public void performOk() throws Exception {
        this.okPerformed = true;
    }

    public void performDisable() {
        this.disableJarTypeAssist.setValue((Object)true);
    }

    public String getTitle() {
        return "Confirm Changes to '" + this.dependencyFileName + "'";
    }

    public String getDependencyFileName() {
        return this.dependencyFileName;
    }

    public boolean isShowChoices() {
        return this.availableChoices.length > 1;
    }

    public String getTypeName() {
        return this.type.getFullyQualifiedName();
    }
}

