/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.core;

import org.apache.commons.lang3.StringUtils;
import org.springframework.ide.eclipse.boot.core.IMavenCoordinates;
import org.springframework.ide.eclipse.boot.core.initializr.InitializrDependencySpec;
import org.springsource.ide.eclipse.commons.livexp.ui.Ilabelable;

public class MavenCoordinates
implements IMavenCoordinates,
Ilabelable {
    private final String group;
    private final String artifact;
    private final String version;
    private final String classifier;

    public MavenCoordinates(String group, String artifact, String classifier, String version) {
        this.group = group;
        this.artifact = artifact;
        this.version = version;
        this.classifier = classifier;
    }

    public MavenCoordinates(String group, String artifact, String version) {
        this.group = group;
        this.artifact = artifact;
        this.version = version;
        this.classifier = null;
    }

    public MavenCoordinates(InitializrDependencySpec.DependencyInfo dep) {
        this(dep.getGroupId(), dep.getArtifactId(), dep.getClassifier(), dep.getVersion());
    }

    @Override
    public String getGroupId() {
        return this.group;
    }

    @Override
    public String getArtifactId() {
        return this.artifact;
    }

    @Override
    public String getClassifier() {
        return this.classifier;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public String toString() {
        return String.valueOf(this.group) + ":" + this.artifact + ":" + (this.classifier != null ? String.valueOf(this.classifier) + ":" : "") + this.version;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.artifact == null ? 0 : this.artifact.hashCode());
        result = 31 * result + (this.classifier == null ? 0 : this.classifier.hashCode());
        result = 31 * result + (this.group == null ? 0 : this.group.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MavenCoordinates other = (MavenCoordinates)obj;
        if (this.artifact == null ? other.artifact != null : !this.artifact.equals(other.artifact)) {
            return false;
        }
        if (this.classifier == null ? other.classifier != null : !this.classifier.equals(other.classifier)) {
            return false;
        }
        if (this.group == null ? other.group != null : !this.group.equals(other.group)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }

    public String getLabel() {
        return this.artifact;
    }

    public String toXmlString() {
        StringBuilder xml = new StringBuilder();
        xml.append("<dependency>\n");
        xml.append("   <artifactId>" + this.artifact + "</artifactId>\n");
        xml.append("   <groupId>" + this.artifact + "</groupId>\n");
        if (StringUtils.isNotBlank((CharSequence)this.version)) {
            xml.append("   <version>" + this.version + "</version>\n");
        }
        if (StringUtils.isNotBlank((CharSequence)this.classifier)) {
            xml.append("   <classifier>" + this.classifier + "</classifier>\n");
        }
        xml.append("</dependency>");
        return xml.toString();
    }
}

