/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.core;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.springframework.ide.eclipse.boot.core.ISpringBootProject;
import org.springframework.ide.eclipse.boot.core.initializr.InitializrService;
import org.springframework.ide.eclipse.boot.core.internal.MavenSpringBootProject;
import org.springsource.ide.eclipse.commons.core.preferences.StsProperties;

public class SpringBootCore {
    public static final String M2E_NATURE = "org.eclipse.m2e.core.maven2Nature";
    private static final StsProperties stsProps = StsProperties.getInstance();
    private InitializrService initializr;
    private static SpringBootCore instance;

    public SpringBootCore(InitializrService initializr) {
        this.initializr = initializr;
    }

    @Deprecated
    public static ISpringBootProject create(IProject project) throws CoreException {
        return SpringBootCore.getDefault().project(project);
    }

    @Deprecated
    public static ISpringBootProject create(IJavaProject project) throws CoreException {
        return SpringBootCore.getDefault().project(project);
    }

    public static SpringBootCore getDefault() {
        if (instance == null) {
            instance = new SpringBootCore(InitializrService.CACHING);
        }
        return instance;
    }

    public ISpringBootProject project(IJavaProject project) throws CoreException {
        return this.project(project.getProject());
    }

    public ISpringBootProject project(IProject project) throws CoreException {
        if (project.hasNature(M2E_NATURE)) {
            return new MavenSpringBootProject(project, this.initializr);
        }
        return null;
    }

    public static String getDefaultBootVersion() {
        return stsProps.get("spring.boot.default.version");
    }
}

