/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.core;

import org.springframework.ide.eclipse.boot.core.Bom;
import org.springframework.ide.eclipse.boot.core.IMavenCoordinates;
import org.springframework.ide.eclipse.boot.core.MavenId;
import org.springframework.ide.eclipse.boot.core.Repo;

public class SpringBootStarter {
    private String id;
    private IMavenCoordinates dep;
    private String scope;
    private Bom bom;
    private Repo repo;

    public SpringBootStarter(String id, IMavenCoordinates dep, String scope, Bom bom, Repo repo) {
        this.id = id;
        this.dep = dep;
        this.scope = scope;
        this.bom = bom;
        this.repo = repo;
    }

    public String getId() {
        return this.id;
    }

    public String getArtifactId() {
        return this.dep.getArtifactId();
    }

    public String getGroupId() {
        return this.dep.getGroupId();
    }

    public String getVersion() {
        return this.dep.getVersion();
    }

    public IMavenCoordinates getDependency() {
        return this.dep;
    }

    public String getScope() {
        return this.scope;
    }

    public Bom getBom() {
        return this.bom;
    }

    public Repo getRepo() {
        return this.repo;
    }

    public MavenId getMavenId() {
        return new MavenId(this.dep.getGroupId(), this.dep.getArtifactId());
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SpringBootStarter other = (SpringBootStarter)obj;
        return !(this.id == null ? other.id != null : !this.id.equals(other.id));
    }

    public String toString() {
        return "SpringBootStarter(" + this.id + ")";
    }
}

