/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.core;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.ide.eclipse.boot.core.Bom;
import org.springframework.ide.eclipse.boot.core.MavenCoordinates;
import org.springframework.ide.eclipse.boot.core.MavenId;
import org.springframework.ide.eclipse.boot.core.Repo;
import org.springframework.ide.eclipse.boot.core.SpringBootStarter;
import org.springframework.ide.eclipse.boot.core.initializr.InitializrDependencySpec;
import org.springframework.ide.eclipse.boot.core.initializr.InitializrServiceSpec;
import org.springsource.ide.eclipse.commons.frameworks.core.downloadmanager.URLConnectionFactory;

public class SpringBootStarters {
    private InitializrDependencySpec dependencySpec;
    private InitializrServiceSpec initializrSpec;
    private HashMap<String, SpringBootStarter> byId;
    private HashMap<MavenId, SpringBootStarter> byMavenId;

    public SpringBootStarters(InitializrServiceSpec initializrSpec, InitializrDependencySpec dependencySpec) {
        this.dependencySpec = dependencySpec;
        this.initializrSpec = initializrSpec;
    }

    public SpringBootStarters(URL initializerUrl, URL dependencyUrl, URLConnectionFactory urlConnectionFactory) throws Exception {
        this(InitializrServiceSpec.parseFrom(urlConnectionFactory, initializerUrl), InitializrDependencySpec.parseFrom(urlConnectionFactory, dependencyUrl));
    }

    public InitializrServiceSpec.DependencyGroup[] getDependencyGroups() {
        return this.initializrSpec.getDependencies();
    }

    public MavenId getMavenId(String findId) {
        this.ensureIndexes();
        SpringBootStarter starter = this.byId.get(findId);
        if (starter != null) {
            return starter.getMavenId();
        }
        return null;
    }

    private synchronized void ensureIndexes() {
        String id;
        HashMap<String, Repo> reposById = new HashMap<String, Repo>();
        for (Map.Entry<String, InitializrDependencySpec.RepoInfo> e : this.dependencySpec.getRepositories().entrySet()) {
            String id2 = e.getKey();
            InitializrDependencySpec.RepoInfo repo = e.getValue();
            reposById.put(id2, new Repo(id2, repo));
        }
        HashMap<String, Bom> bomsById = new HashMap<String, Bom>();
        for (Map.Entry<String, InitializrDependencySpec.BomInfo> entry : this.dependencySpec.getBoms().entrySet()) {
            id = entry.getKey();
            InitializrDependencySpec.BomInfo bomInfo = entry.getValue();
            ArrayList<Repo> repos = new ArrayList<Repo>();
            String[] repoIds = bomInfo.getRepositories();
            if (repoIds != null) {
                String[] stringArray = repoIds;
                int n = repoIds.length;
                int n2 = 0;
                while (n2 < n) {
                    String repoId = stringArray[n2];
                    Repo repo = (Repo)reposById.get(repoId);
                    if (repo != null) {
                        repos.add(repo);
                    }
                    ++n2;
                }
            }
            Bom bom = new Bom(id, new MavenCoordinates(bomInfo.getGroupId(), bomInfo.getArtifactId(), bomInfo.getClassifier(), bomInfo.getVersion()), repos);
            bomsById.put(entry.getKey(), bom);
        }
        if (this.byId == null) {
            this.byId = new HashMap();
            this.byMavenId = new HashMap();
            for (Map.Entry<String, Object> entry : this.dependencySpec.getDependencies().entrySet()) {
                id = entry.getKey();
                InitializrDependencySpec.DependencyInfo dep = (InitializrDependencySpec.DependencyInfo)entry.getValue();
                String groupId = dep.getGroupId();
                String artifactId = dep.getArtifactId();
                String scope = dep.getScope();
                String bom = dep.getBom();
                String repo = dep.getRepository();
                if (id == null || groupId == null || artifactId == null) continue;
                SpringBootStarter starter = new SpringBootStarter(id, new MavenCoordinates(dep), scope, (Bom)bomsById.get(bom), (Repo)reposById.get(repo));
                this.byId.put(id, starter);
                this.byMavenId.put(new MavenId(groupId, artifactId), starter);
            }
        }
    }

    public String getBootVersion() {
        return this.dependencySpec.getBootVersion();
    }

    public boolean contains(String id) {
        return this.getMavenId(id) != null;
    }

    public List<String> getStarterIds() {
        this.ensureIndexes();
        return Collections.unmodifiableList(new ArrayList<String>(this.byId.keySet()));
    }

    public synchronized String getId(MavenId mavenId) {
        this.ensureIndexes();
        SpringBootStarter starter = this.byMavenId.get(mavenId);
        if (starter != null) {
            return starter.getId();
        }
        return null;
    }

    public SpringBootStarter getStarter(MavenId mavenId) {
        this.ensureIndexes();
        return this.byMavenId.get(mavenId);
    }

    public SpringBootStarter getStarter(String id) {
        this.ensureIndexes();
        return this.byId.get(id);
    }

    public Map<String, InitializrDependencySpec.RepoInfo> getRepos() {
        return this.dependencySpec.getRepositories();
    }
}

