/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.core.initializr;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Map;
import org.springframework.ide.eclipse.boot.util.Log;
import org.springsource.ide.eclipse.commons.frameworks.core.downloadmanager.URLConnectionFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class InitializrDependencySpec {
    private static final String JSON_CONTENT_TYPE_HEADER = "application/json";
    private String bootVersion;
    private Map<String, DependencyInfo> dependencies;
    private Map<String, BomInfo> boms;
    private Map<String, RepoInfo> repositories;

    public static InitializrDependencySpec parseFrom(InputStream input) throws JsonParseException, JsonMappingException, IOException {
        ObjectMapper mapper = new ObjectMapper();
        return (InitializrDependencySpec)mapper.readValue(input, InitializrDependencySpec.class);
    }

    public Map<String, DependencyInfo> getDependencies() {
        return this.dependencies;
    }

    public void setDependencies(Map<String, DependencyInfo> dependencies) {
        this.dependencies = dependencies;
    }

    public String toString() {
        try {
            ObjectMapper mapper = new ObjectMapper();
            mapper.configure(SerializationFeature.INDENT_OUTPUT, true);
            return mapper.writeValueAsString((Object)this);
        }
        catch (Exception e) {
            Log.log(e);
            return super.toString();
        }
    }

    public static InitializrDependencySpec parseFrom(URLConnectionFactory urlConnectionFactory, URL url) throws Exception {
        InitializrDependencySpec initializrDependencySpec;
        block7: {
            URLConnection conn = null;
            InputStream input = null;
            try {
                conn = urlConnectionFactory.createConnection(url);
                conn.addRequestProperty("Accept", JSON_CONTENT_TYPE_HEADER);
                conn.connect();
                input = conn.getInputStream();
                initializrDependencySpec = InitializrDependencySpec.parseFrom(input);
                if (input == null) break block7;
            }
            catch (Throwable throwable) {
                if (input != null) {
                    try {
                        input.close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                input.close();
            }
            catch (IOException iOException) {}
        }
        return initializrDependencySpec;
    }

    public static InitializrDependencySpec parseFrom(URLConnectionFactory urlConnectionFactory, String url) throws Exception {
        Exception exception = null;
        int i = 0;
        while (i < 5) {
            try {
                return InitializrDependencySpec.parseFrom(urlConnectionFactory, new URL(url));
            }
            catch (Exception e) {
                exception = e;
                ++i;
            }
        }
        throw exception;
    }

    public Map<String, BomInfo> getBoms() {
        return this.boms;
    }

    public void setBoms(Map<String, BomInfo> boms) {
        this.boms = boms;
    }

    public Map<String, RepoInfo> getRepositories() {
        return this.repositories;
    }

    public void setRepositories(Map<String, RepoInfo> repositories) {
        this.repositories = repositories;
    }

    public String getBootVersion() {
        return this.bootVersion;
    }

    public void setBootVersion(String bootVersion) {
        this.bootVersion = bootVersion;
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class BomInfo {
        private String groupId;
        private String artifactId;
        private String version;
        private String scope;
        private String classifier;
        private String[] repositories;

        public String getGroupId() {
            return this.groupId;
        }

        public void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public void setArtifactId(String artifactId) {
            this.artifactId = artifactId;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String getScope() {
            return this.scope;
        }

        public void setScope(String scope) {
            this.scope = scope;
        }

        public String getClassifier() {
            return this.classifier;
        }

        public void setClassifier(String classifier) {
            this.classifier = classifier;
        }

        public String[] getRepositories() {
            return this.repositories;
        }

        public void setRepositories(String[] repositories) {
            this.repositories = repositories;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class DependencyInfo {
        private String groupId;
        private String artifactId;
        private String version;
        private String scope;
        private String bom;
        private String classifier;
        private String repository;

        public String getGroupId() {
            return this.groupId;
        }

        public void setGroupId(String groupId) {
            this.groupId = groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public void setArtifactId(String artifactId) {
            this.artifactId = artifactId;
        }

        public String getVersion() {
            return this.version;
        }

        public void setVersion(String version) {
            this.version = version;
        }

        public String getScope() {
            return this.scope;
        }

        public void setScope(String scope) {
            this.scope = scope;
        }

        public String getBom() {
            return this.bom;
        }

        public void setBom(String bom) {
            this.bom = bom;
        }

        public String getClassifier() {
            return this.classifier;
        }

        public void setClassifier(String classifier) {
            this.classifier = classifier;
        }

        public String getRepository() {
            return this.repository;
        }

        public void setRepository(String repository) {
            this.repository = repository;
        }
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class RepoInfo {
        private String name;
        private String url;
        private Boolean snapshotEnabled;

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public Boolean getSnapshotEnabled() {
            return this.snapshotEnabled;
        }

        public void setSnapshotEnabled(Boolean snapshotEnabled) {
            this.snapshotEnabled = snapshotEnabled;
        }
    }
}

