/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.core.initializr;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.springframework.ide.eclipse.boot.core.BootActivator;
import org.springframework.ide.eclipse.boot.core.BootPreferences;
import org.springframework.ide.eclipse.boot.core.SimpleUriBuilder;
import org.springframework.ide.eclipse.boot.core.SpringBootStarters;
import org.springframework.ide.eclipse.boot.util.Log;

public interface InitializrService {
    public static final InitializrService DEFAULT = new InitializrService(){

        @Override
        public SpringBootStarters getStarters(String bootVersion) {
            try {
                URL initializrUrl = new URL(BootPreferences.getInitializrUrl());
                URL dependencyUrl = this.dependencyUrl(bootVersion, initializrUrl);
                return new SpringBootStarters(initializrUrl, dependencyUrl, BootActivator.getUrlConnectionFactory());
            }
            catch (Exception e) {
                Log.log(e);
                return null;
            }
        }

        private URL dependencyUrl(String bootVersion, URL initializerUrl) throws MalformedURLException {
            SimpleUriBuilder builder = new SimpleUriBuilder(String.valueOf(initializerUrl.toString()) + "/dependencies");
            builder.addParameter("bootVersion", bootVersion);
            return new URL(builder.toString());
        }
    };
    public static final InitializrService CACHING = new InitializrService(){
        private SpringBootStarters cached = null;
        {
            BootActivator.getDefault().getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    if ("org.springframework.ide.eclipse.boot.wizard.initializr.url".equals(event.getProperty())) {
                        cached = null;
                    }
                }
            });
        }

        @Override
        public SpringBootStarters getStarters(String bootVersion) {
            if (this.cached == null) {
                this.cached = DEFAULT.getStarters(bootVersion);
            }
            return this.cached;
        }
    };

    public SpringBootStarters getStarters(String var1);
}

