/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.core.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.project.MavenProject;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.IStreamListener;
import org.eclipse.debug.ui.RefreshTab;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.m2e.actions.MavenLaunchConstants;
import org.eclipse.m2e.core.MavenPlugin;
import org.eclipse.m2e.core.project.IMavenProjectFacade;
import org.eclipse.m2e.core.project.IMavenProjectRegistry;
import org.eclipse.m2e.core.project.ResolverConfiguration;
import org.eclipse.m2e.core.ui.internal.UpdateMavenProjectJob;
import org.eclipse.m2e.core.ui.internal.editing.PomEdits;
import org.eclipse.m2e.core.ui.internal.editing.PomHelper;
import org.springframework.ide.eclipse.boot.core.Bom;
import org.springframework.ide.eclipse.boot.core.BootActivator;
import org.springframework.ide.eclipse.boot.core.IMavenCoordinates;
import org.springframework.ide.eclipse.boot.core.MavenCoordinates;
import org.springframework.ide.eclipse.boot.core.MavenId;
import org.springframework.ide.eclipse.boot.core.Repo;
import org.springframework.ide.eclipse.boot.core.SpringBootCore;
import org.springframework.ide.eclipse.boot.core.SpringBootStarter;
import org.springframework.ide.eclipse.boot.core.initializr.InitializrService;
import org.springframework.ide.eclipse.boot.core.internal.SpringBootProject;
import org.springframework.ide.eclipse.boot.util.DumpOutput;
import org.springframework.ide.eclipse.boot.util.Log;
import org.springsource.ide.eclipse.commons.livexp.util.ExceptionUtil;
import org.springsource.ide.eclipse.commons.ui.launch.LaunchUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class MavenSpringBootProject
extends SpringBootProject {
    public static boolean DUMP_MAVEN_OUTPUT = false;
    private static final String MVN_LAUNCH_MODE = "run";
    private static final boolean DEBUG = ("" + Platform.getLocation()).contains("kdvolder");
    private static final String REPOSITORIES = "repositories";
    private static final String REPOSITORY = "repository";
    private static final String SNAPSHOTS = "snapshots";
    private static final String ENABLED = "enabled";
    private IProject project;

    public MavenSpringBootProject(IProject project, InitializrService initializr) {
        super(initializr);
        Assert.isNotNull((Object)project);
        this.project = project;
    }

    @Override
    public IProject getProject() {
        return this.project;
    }

    private MavenProject getMavenProject() throws CoreException {
        IMavenProjectFacade mpf = this.getMavenProjectFacade();
        if (mpf != null) {
            return mpf.getMavenProject((IProgressMonitor)new NullProgressMonitor());
        }
        return null;
    }

    private IMavenProjectFacade getMavenProjectFacade() {
        IMavenProjectRegistry pr = MavenPlugin.getMavenProjectRegistry();
        IMavenProjectFacade mpf = pr.getProject(this.project);
        return mpf;
    }

    private IFile getPomFile() {
        return this.project.getFile((IPath)new Path("pom.xml"));
    }

    @Override
    public List<IMavenCoordinates> getDependencies() throws CoreException {
        MavenProject mp = this.getMavenProject();
        if (mp != null) {
            return this.toMavenCoordinates(mp.getDependencies());
        }
        return Collections.emptyList();
    }

    private List<IMavenCoordinates> toMavenCoordinates(List<Dependency> dependencies) {
        ArrayList<IMavenCoordinates> converted = new ArrayList<IMavenCoordinates>(dependencies.size());
        for (Dependency d : dependencies) {
            converted.add(new MavenCoordinates(d.getGroupId(), d.getArtifactId(), d.getClassifier(), d.getVersion()));
        }
        return converted;
    }

    private String getManagedVersion(IMavenCoordinates dep) {
        try {
            List deps;
            DependencyManagement managedDeps;
            MavenProject mp = this.getMavenProject();
            if (mp != null && (managedDeps = mp.getDependencyManagement()) != null && (deps = managedDeps.getDependencies()) != null && !deps.isEmpty()) {
                for (Dependency d : deps) {
                    if (!"jar".equals(d.getType()) || !dep.getArtifactId().equals(d.getArtifactId()) || !dep.getGroupId().equals(d.getGroupId())) continue;
                    return d.getVersion();
                }
            }
        }
        catch (Exception e) {
            BootActivator.log(e);
        }
        return null;
    }

    private void debug(String string) {
        if (DEBUG) {
            System.out.println(string);
        }
    }

    @Override
    public void addMavenDependency(IMavenCoordinates dep, boolean preferManagedVersion) throws CoreException {
        this.addMavenDependency(dep, preferManagedVersion, false);
    }

    @Override
    public void addMavenDependency(final IMavenCoordinates dep, final boolean preferManagedVersion, final boolean optional) throws CoreException {
        try {
            IFile file = this.getPomFile();
            PomEdits.performOnDOMDocument((PomEdits.OperationTuple[])new PomEdits.OperationTuple[]{new PomEdits.OperationTuple(file, new PomEdits.Operation(){

                public void process(Document document) {
                    Element depsEl = PomEdits.getChild((Element)document.getDocumentElement(), (String[])new String[]{"dependencies"});
                    if (depsEl != null) {
                        String version = dep.getVersion();
                        String managedVersion = MavenSpringBootProject.this.getManagedVersion(dep);
                        if (managedVersion != null && (preferManagedVersion || managedVersion.equals(version))) {
                            version = null;
                        }
                        Element xmlDep = PomHelper.createDependency((Element)depsEl, (String)dep.getGroupId(), (String)dep.getArtifactId(), (String)version);
                        if (optional) {
                            PomEdits.createElementWithText((Element)xmlDep, (String)"optional", (String)"true");
                            PomEdits.format((Node)xmlDep);
                        }
                    }
                }
            })});
        }
        catch (Throwable e) {
            throw ExceptionUtil.coreException((Throwable)e);
        }
    }

    @Override
    public void setStarters(Collection<SpringBootStarter> _starters) throws CoreException {
        try {
            final HashSet<MavenId> starters = new HashSet<MavenId>();
            for (SpringBootStarter s : _starters) {
                starters.add(s.getMavenId());
            }
            IFile file = this.getPomFile();
            PomEdits.performOnDOMDocument((PomEdits.OperationTuple[])new PomEdits.OperationTuple[]{new PomEdits.OperationTuple(file, new PomEdits.Operation(){

                public void process(Document pom) {
                    Element depsEl = PomEdits.getChild((Element)pom.getDocumentElement(), (String[])new String[]{"dependencies"});
                    List children = PomEdits.findChilds((Element)depsEl, (String)"dependency");
                    for (Element c : children) {
                        MavenId id;
                        boolean keep;
                        String aid = PomEdits.getTextValue((Node)PomEdits.findChild((Element)c, (String)"artifactId"));
                        String gid = PomEdits.getTextValue((Node)PomEdits.findChild((Element)c, (String)"groupId"));
                        if (aid == null || gid == null || !MavenSpringBootProject.this.isKnownStarter(new MavenId(gid, aid)) || (keep = starters.remove(id = new MavenId(gid, aid)))) continue;
                        depsEl.removeChild(c);
                    }
                    for (MavenId mid : starters) {
                        SpringBootStarter starter = MavenSpringBootProject.this.getStarter(mid);
                        MavenSpringBootProject.this.createDependency(depsEl, starter.getDependency(), starter.getScope());
                        MavenSpringBootProject.this.createBomIfNeeded(pom, starter.getBom());
                        MavenSpringBootProject.this.createRepoIfNeeded(pom, starter.getRepo());
                    }
                }
            })});
        }
        catch (Throwable e) {
            throw ExceptionUtil.coreException((Throwable)e);
        }
    }

    @Override
    public void removeMavenDependency(final MavenId mavenId) {
        IFile file = this.getPomFile();
        try {
            PomEdits.performOnDOMDocument((PomEdits.OperationTuple[])new PomEdits.OperationTuple[]{new PomEdits.OperationTuple(file, new PomEdits.Operation(){

                public void process(Document pom) {
                    Element dep;
                    Element depsEl = PomEdits.getChild((Element)pom.getDocumentElement(), (String[])new String[]{"dependencies"});
                    if (depsEl != null && (dep = PomEdits.findChild((Element)depsEl, (String)"dependency", (PomEdits.Matcher[])new PomEdits.Matcher[]{PomEdits.childEquals((String)"groupId", (String)mavenId.getGroupId()), PomEdits.childEquals((String)"artifactId", (String)mavenId.getArtifactId())})) != null) {
                        depsEl.removeChild(dep);
                    }
                }
            })});
        }
        catch (Exception e) {
            BootActivator.log(e);
        }
    }

    @Override
    public Job updateProjectConfiguration() {
        UpdateMavenProjectJob job = new UpdateMavenProjectJob(new IProject[]{this.getProject()});
        job.schedule();
        return job;
    }

    @Override
    public String getBootVersion() {
        try {
            MavenProject mp = this.getMavenProject();
            if (mp != null) {
                return this.getBootVersion(mp.getDependencies());
            }
        }
        catch (Exception e) {
            BootActivator.log(e);
        }
        return SpringBootCore.getDefaultBootVersion();
    }

    private String getBootVersion(List<Dependency> dependencies) {
        for (Dependency dep : dependencies) {
            if (!dep.getArtifactId().startsWith("spring-boot") || !dep.getGroupId().equals("org.springframework.boot")) continue;
            return dep.getVersion();
        }
        return SpringBootCore.getDefaultBootVersion();
    }

    private void createRepoIfNeeded(Document pom, Repo repo) {
        if (repo != null) {
            this.addReposIfNeeded(pom, Collections.singletonList(repo));
        }
    }

    private void createBomIfNeeded(Document pom, Bom bom) {
        if (bom != null) {
            Element bomList = this.ensureDependencyMgmtSection(pom);
            Element existing = PomEdits.findChild((Element)bomList, (String)"dependency", (PomEdits.Matcher[])new PomEdits.Matcher[]{PomEdits.childEquals((String)"groupId", (String)bom.getGroupId()), PomEdits.childEquals((String)"artifactId", (String)bom.getArtifactId())});
            if (existing == null) {
                MavenSpringBootProject.createBom(bomList, bom);
                this.addReposIfNeeded(pom, bom.getRepos());
            }
        }
    }

    private Element ensureDependencyMgmtSection(Document pom) {
        Element deplist;
        boolean needFormatting = false;
        Element doc = pom.getDocumentElement();
        Element depman = PomEdits.findChild((Element)doc, (String)"dependencyManagement");
        if (depman == null) {
            depman = PomEdits.createElement((Element)doc, (String)"dependencyManagement");
            needFormatting = true;
        }
        if ((deplist = PomEdits.findChild((Element)depman, (String)"dependencies")) == null) {
            deplist = PomEdits.createElement((Element)depman, (String)"dependencies");
        }
        if (needFormatting) {
            PomEdits.format((Node)depman);
        }
        return deplist;
    }

    private static Element createBom(Element parentList, Bom bom) {
        String groupId = bom.getGroupId();
        String artifactId = bom.getArtifactId();
        String version = bom.getVersion();
        String classifier = bom.getClassifier();
        String type = "pom";
        String scope = "import";
        Element dep = PomEdits.createElement((Element)parentList, (String)"dependency");
        if (groupId != null) {
            PomEdits.createElementWithText((Element)dep, (String)"groupId", (String)groupId);
        }
        PomEdits.createElementWithText((Element)dep, (String)"artifactId", (String)artifactId);
        if (version != null) {
            PomEdits.createElementWithText((Element)dep, (String)"version", (String)version);
        }
        PomEdits.createElementWithText((Element)dep, (String)"type", (String)type);
        if (scope != null && !scope.equals("compile")) {
            PomEdits.createElementWithText((Element)dep, (String)"scope", (String)scope);
        }
        if (classifier != null) {
            PomEdits.createElementWithText((Element)dep, (String)"classifier", (String)classifier);
        }
        PomEdits.format((Node)dep);
        return dep;
    }

    private Element createDependency(Element parentList, IMavenCoordinates info, String scope) {
        Element dep = PomEdits.createElement((Element)parentList, (String)"dependency");
        String groupId = info.getGroupId();
        String artifactId = info.getArtifactId();
        String version = info.getVersion();
        String classifier = info.getClassifier();
        if (groupId != null) {
            PomEdits.createElementWithText((Element)dep, (String)"groupId", (String)groupId);
        }
        PomEdits.createElementWithText((Element)dep, (String)"artifactId", (String)artifactId);
        if (version != null) {
            PomEdits.createElementWithText((Element)dep, (String)"version", (String)version);
        }
        if (classifier != null) {
            PomEdits.createElementWithText((Element)dep, (String)"classifier", (String)classifier);
        }
        if (scope != null && !scope.equals("compile")) {
            PomEdits.createElementWithText((Element)dep, (String)"scope", (String)scope);
        }
        PomEdits.format((Node)dep);
        return dep;
    }

    private void addReposIfNeeded(Document pom, List<Repo> repos) {
        if (repos != null && !repos.isEmpty()) {
            Element doc = pom.getDocumentElement();
            Element repoList = PomEdits.findChild((Element)doc, (String)REPOSITORIES);
            if (repoList == null) {
                repoList = PomEdits.createElement((Element)doc, (String)REPOSITORIES);
                PomEdits.format((Node)repoList);
            }
            for (Repo repo : repos) {
                String id = repo.getId();
                Element repoEl = PomEdits.findChild((Element)repoList, (String)REPOSITORY, (PomEdits.Matcher[])new PomEdits.Matcher[]{PomEdits.childEquals((String)"id", (String)id)});
                if (repoEl != null) continue;
                repoEl = PomEdits.createElement((Element)repoList, (String)REPOSITORY);
                this.createElementWithTextMaybe(repoEl, "id", id);
                this.createElementWithTextMaybe(repoEl, "name", repo.getName());
                this.createElementWithTextMaybe(repoEl, "url", repo.getUrl());
                Boolean isSnapshot = repo.getSnapshotEnabled();
                if (isSnapshot != null) {
                    Element snapshot = PomEdits.createElement((Element)repoEl, (String)SNAPSHOTS);
                    PomEdits.createElementWithText((Element)snapshot, (String)ENABLED, (String)isSnapshot.toString());
                }
                PomEdits.format((Node)repoEl);
            }
        }
    }

    private void createElementWithTextMaybe(Element parent, String name, String text) {
        if (StringUtils.isNotBlank((CharSequence)text)) {
            PomEdits.createElementWithText((Element)parent, (String)name, (String)text);
        }
    }

    @Override
    public String getDependencyFileName() {
        return "pom.xml";
    }

    @Override
    public String getPackaging() throws CoreException {
        MavenProject mp = this.getMavenProject();
        if (mp != null) {
            return mp.getPackaging();
        }
        return null;
    }

    @Override
    public File executePackagingScript(IProgressMonitor monitor) throws CoreException {
        monitor.beginTask("Building War file", 100);
        try {
            ILaunchConfiguration launchConf = this.createLaunchConfiguration((IContainer)this.project, "package");
            ILaunch launch = launchConf.launch(MVN_LAUNCH_MODE, (IProgressMonitor)SubMonitor.convert((IProgressMonitor)monitor, (int)10), true, true);
            if (DUMP_MAVEN_OUTPUT) {
                launch.getProcesses()[0].getStreamsProxy().getOutputStreamMonitor().addListener((IStreamListener)new DumpOutput("%mvn-out"));
                launch.getProcesses()[0].getStreamsProxy().getErrorStreamMonitor().addListener((IStreamListener)new DumpOutput("%mvn-err"));
            }
            LaunchUtils.whenTerminated((ILaunch)launch).get();
            int exitValue = launch.getProcesses()[0].getExitValue();
            if (exitValue != 0) {
                throw ExceptionUtil.coreException((String)("Non-zero exit-code(" + exitValue + ") from maven war packaging. Check maven console for errors!"));
            }
            File file = this.findWarFile();
            return file;
        }
        catch (InterruptedException | ExecutionException e) {
            throw ExceptionUtil.coreException((Throwable)e);
        }
        finally {
            monitor.done();
        }
    }

    private File findWarFile() throws CoreException {
        File warFile = this.getWarFile();
        if (warFile == null) {
            throw ExceptionUtil.coreException((String)"Couldn't determine where to find the war file after 'mvn package'");
        }
        if (!warFile.isFile()) {
            throw ExceptionUtil.coreException((String)("Couldn't find file to deploy at '" + warFile + "' after running 'mvn package'"));
        }
        return warFile;
    }

    private File getWarFile() throws CoreException {
        MavenProject mpf = this.getMavenProject();
        if (mpf != null) {
            String buildDir = mpf.getBuild().getDirectory();
            String fName = mpf.getBuild().getFinalName();
            String type = mpf.getPackaging();
            if (buildDir != null && fName != null && type != null) {
                return new File(new File(buildDir), String.valueOf(fName) + "." + type);
            }
        }
        return null;
    }

    private ILaunchConfiguration createLaunchConfiguration(IContainer basedir, String goal) {
        try {
            ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
            ILaunchConfigurationType launchConfigurationType = launchManager.getLaunchConfigurationType("org.eclipse.m2e.Maven2LaunchConfigurationType");
            String rawConfigName = String.valueOf(basedir.getName()) + "-build-war";
            String safeConfigName = launchManager.generateLaunchConfigurationName(rawConfigName);
            ILaunchConfigurationWorkingCopy workingCopy = launchConfigurationType.newInstance(null, safeConfigName);
            workingCopy.setAttribute(MavenLaunchConstants.ATTR_POM_DIR, basedir.getLocation().toOSString());
            workingCopy.setAttribute("M2_GOALS", goal);
            workingCopy.setAttribute("M2_SKIP_TESTS", true);
            workingCopy.setAttribute("org.eclipse.debug.ui.private", true);
            workingCopy.setAttribute(RefreshTab.ATTR_REFRESH_SCOPE, "${project}");
            workingCopy.setAttribute(RefreshTab.ATTR_REFRESH_RECURSIVE, true);
            this.setProjectConfiguration(workingCopy, basedir);
            IPath path = this.getJREContainerPath(basedir);
            if (path != null) {
                workingCopy.setAttribute(IJavaLaunchConfigurationConstants.ATTR_JRE_CONTAINER_PATH, path.toPortableString());
            }
            return workingCopy;
        }
        catch (CoreException ex) {
            Log.log(ex);
            return null;
        }
    }

    private IPath getJREContainerPath(IContainer basedir) throws CoreException {
        IProject project = basedir.getProject();
        if (project != null && project.hasNature("org.eclipse.jdt.core.javanature")) {
            IJavaProject javaProject = JavaCore.create((IProject)project);
            IClasspathEntry[] entries = javaProject.getRawClasspath();
            int i = 0;
            while (i < entries.length) {
                IClasspathEntry entry = entries[i];
                if (JavaRuntime.JRE_CONTAINER.equals(entry.getPath().segment(0))) {
                    return entry.getPath();
                }
                ++i;
            }
        }
        return null;
    }

    private void setProjectConfiguration(ILaunchConfigurationWorkingCopy workingCopy, IContainer basedir) {
        ResolverConfiguration configuration;
        String selectedProfiles;
        IFile pomFile;
        IMavenProjectRegistry projectManager = MavenPlugin.getMavenProjectRegistry();
        IMavenProjectFacade projectFacade = projectManager.create(pomFile = basedir.getFile((IPath)new Path("pom.xml")), false, (IProgressMonitor)new NullProgressMonitor());
        if (projectFacade != null && (selectedProfiles = (configuration = projectFacade.getResolverConfiguration()).getSelectedProfiles()) != null && selectedProfiles.length() > 0) {
            workingCopy.setAttribute("M2_PROFILES", selectedProfiles);
        }
    }
}

