/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.core.internal;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.springframework.ide.eclipse.boot.core.IMavenCoordinates;
import org.springframework.ide.eclipse.boot.core.ISpringBootProject;
import org.springframework.ide.eclipse.boot.core.MavenId;
import org.springframework.ide.eclipse.boot.core.SpringBootStarter;
import org.springframework.ide.eclipse.boot.core.SpringBootStarters;
import org.springframework.ide.eclipse.boot.core.initializr.InitializrService;
import org.springframework.ide.eclipse.boot.util.Log;

public abstract class SpringBootProject
implements ISpringBootProject {
    static final List<SpringBootStarter> NO_STARTERS = Collections.emptyList();
    private final InitializrService initializr;

    public SpringBootProject(InitializrService initializr) {
        this.initializr = initializr;
    }

    @Override
    public List<SpringBootStarter> getKnownStarters() {
        SpringBootStarters infos = this.getStarterInfos();
        if (infos != null) {
            List<String> knownIds = infos.getStarterIds();
            ArrayList<SpringBootStarter> starters = new ArrayList<SpringBootStarter>(knownIds.size());
            for (String id : knownIds) {
                SpringBootStarter starter = infos.getStarter(id);
                starters.add(starter);
            }
            return starters;
        }
        return NO_STARTERS;
    }

    @Override
    public SpringBootStarters getStarterInfos() {
        try {
            String bootVersion = this.getBootVersion();
            if (bootVersion != null) {
                return this.initializr.getStarters(bootVersion);
            }
        }
        catch (Exception e) {
            Log.log(e);
        }
        return null;
    }

    @Override
    public List<SpringBootStarter> getBootStarters() throws CoreException {
        SpringBootStarters infos = this.getStarterInfos();
        List<IMavenCoordinates> deps = this.getDependencies();
        ArrayList<SpringBootStarter> starters = new ArrayList<SpringBootStarter>();
        for (IMavenCoordinates dep : deps) {
            MavenId mavenId;
            SpringBootStarter starter;
            String aid = dep.getArtifactId();
            String gid = dep.getGroupId();
            if (aid == null || gid == null || (starter = infos.getStarter(mavenId = new MavenId(gid, aid))) == null) continue;
            starters.add(starter);
        }
        return starters;
    }

    public boolean isKnownStarter(MavenId mavenId) {
        return this.getStarter(mavenId) != null;
    }

    protected SpringBootStarter getStarter(MavenId mavenId) {
        SpringBootStarters infos = this.getStarterInfos();
        if (infos != null) {
            return infos.getStarter(mavenId);
        }
        return null;
    }
}

