/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.refactoring;

import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.corext.refactoring.tagging.ITextUpdating;
import org.eclipse.jdt.ui.refactoring.RenameSupport;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameParticipant;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.UIJob;
import org.springframework.ide.eclipse.boot.util.Log;
import org.springsource.ide.eclipse.commons.livexp.util.ExceptionUtil;

public class TypeRenameParticipant
extends RenameParticipant {
    private static final String[] POSTFIXES = new String[]{"Test", "Tests"};
    private IType renamedType;
    private IType companionType;

    protected boolean initialize(Object element) {
        try {
            if (element instanceof IType) {
                this.renamedType = (IType)element;
                this.companionType = this.findCompanion(this.renamedType);
                return this.companionType != null;
            }
        }
        catch (Exception e) {
            Log.log(e);
        }
        return false;
    }

    private IType findCompanion(IType renamedType) throws Exception {
        if (!renamedType.isMember() && !renamedType.isAnonymous()) {
            IJavaProject project = renamedType.getJavaProject();
            String[] stringArray = POSTFIXES;
            int n = POSTFIXES.length;
            int n2 = 0;
            while (n2 < n) {
                String postfix = stringArray[n2];
                String baseName = renamedType.getFullyQualifiedName();
                String companionName = String.valueOf(baseName) + postfix;
                IType companion = project.findType(companionName);
                if (companion != null && !companion.isBinary()) {
                    return companion;
                }
                ++n2;
            }
        }
        return null;
    }

    public String getName() {
        return "Rename Type Participant";
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        return RefactoringStatus.create((IStatus)Status.OK_STATUS);
    }

    private void schedulePromptForCompanionTypeRename() {
        System.out.println("DDDD");
        UIJob job = new UIJob("Prompt for Companion Type Rename"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                try {
                    String oldName = TypeRenameParticipant.this.renamedType.getElementName();
                    String oldCompanionName = TypeRenameParticipant.this.companionType.getElementName();
                    String newName = TypeRenameParticipant.this.getArguments().getNewName();
                    Assert.isLegal((boolean)oldCompanionName.startsWith(oldName));
                    String postfix = oldCompanionName.substring(oldName.length());
                    String newCompanionName = String.valueOf(newName) + postfix;
                    boolean answeredYes = MessageDialog.openQuestion((Shell)this.getShell(), (String)("Also Rename '" + TypeRenameParticipant.this.companionType.getElementName() + "'?"), (String)("Type '" + oldName + "' was renamed to '" + newName + "'." + "Do you also want to rename '" + TypeRenameParticipant.this.companionType.getElementName() + "' from package '" + TypeRenameParticipant.this.companionType.getPackageFragment().getElementName() + "' " + "to '" + newCompanionName + "'?"));
                    if (answeredYes) {
                        int options = 0;
                        if (TypeRenameParticipant.this.getArguments().getUpdateReferences()) {
                            options |= 1;
                        }
                        if (TypeRenameParticipant.this.getUpdateTextualMatches()) {
                            options |= 0x40;
                        }
                        RenameSupport renameSupport = RenameSupport.create((IType)TypeRenameParticipant.this.companionType, (String)newCompanionName, (int)options);
                        renameSupport.perform(this.getShell(), (IRunnableContext)PlatformUI.getWorkbench().getProgressService());
                    }
                    return Status.OK_STATUS;
                }
                catch (Exception e) {
                    return ExceptionUtil.status((Throwable)e);
                }
            }

            private Shell getShell() {
                try {
                    return PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
                }
                catch (Exception exception) {
                    return null;
                }
            }
        };
        job.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().buildRule());
        job.schedule();
    }

    private boolean getUpdateTextualMatches() {
        RefactoringProcessor processor = this.getProcessor();
        if (processor instanceof ITextUpdating) {
            return ((ITextUpdating)processor).getUpdateTextualMatches();
        }
        return false;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        return new Change(){

            public Change perform(IProgressMonitor pm) throws CoreException {
                TypeRenameParticipant.this.schedulePromptForCompanionTypeRename();
                return new NullChange();
            }

            public String getName() {
                return "Prompt rename companion: '" + TypeRenameParticipant.this.companionType.getElementName() + "'";
            }

            public void initializeValidationData(IProgressMonitor pm) {
            }

            public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException, OperationCanceledException {
                return new RefactoringStatus();
            }

            public Object getModifiedElement() {
                return null;
            }
        };
    }
}

