/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.ui;

import org.eclipse.core.resources.IProject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.springframework.ide.eclipse.boot.core.BootPropertyTester;

public class BootProjectDecorator
implements ILightweightLabelDecorator {
    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public void decorate(Object element, IDecoration decoration) {
        IProject project = this.getProject(element);
        if (project != null) {
            if (BootPropertyTester.workaroundMavenBundleInitializationIssue(project)) {
                return;
            }
            if (BootPropertyTester.isBootProject(project)) {
                decoration.addSuffix(" [boot]");
                if (BootPropertyTester.hasDevtools(project)) {
                    decoration.addSuffix(" [devtools]");
                }
            }
        }
    }

    private IProject getProject(Object element) {
        if (element instanceof IProject) {
            return (IProject)element;
        }
        if (element instanceof IJavaProject) {
            return ((IJavaProject)element).getProject();
        }
        return null;
    }
}

