/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.ui;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.springframework.ide.eclipse.boot.core.ChooseDependencyModel;
import org.springframework.ide.eclipse.boot.core.MavenCoordinates;
import org.springframework.ide.eclipse.boot.util.Log;
import org.springsource.ide.eclipse.commons.livexp.ui.ChooseOneSection;
import org.springsource.ide.eclipse.commons.livexp.ui.CommentSection;
import org.springsource.ide.eclipse.commons.livexp.ui.DescriptionSection;
import org.springsource.ide.eclipse.commons.livexp.ui.DialogWithSections;
import org.springsource.ide.eclipse.commons.livexp.ui.HLineSection;
import org.springsource.ide.eclipse.commons.livexp.ui.IPageWithSections;
import org.springsource.ide.eclipse.commons.livexp.ui.Ilabelable;
import org.springsource.ide.eclipse.commons.livexp.ui.OkButtonHandler;
import org.springsource.ide.eclipse.commons.livexp.ui.StyledCommentSection;
import org.springsource.ide.eclipse.commons.livexp.ui.WizardPageSection;

public class ChooseDependencyDialog
extends DialogWithSections {
    private static final int DISABLE_BUTTON_ID = 100;
    private ChooseDependencyModel model;

    public ChooseDependencyDialog(ChooseDependencyModel model, Shell shell) {
        super(model.getTitle(), (OkButtonHandler)model, shell);
        this.model = model;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.createButton(parent, 100, "Disable", false);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 100) {
            this.model.performDisable();
            this.close();
        }
        super.buttonPressed(buttonId);
    }

    protected List<WizardPageSection> createSections() throws CoreException {
        ArrayList<WizardPageSection> sections = new ArrayList<WizardPageSection>();
        sections.add((WizardPageSection)new StyledCommentSection((IPageWithSections)this, "Type <b>" + this.model.getTypeName() + "</b> is not yet on the project classpath."));
        if (this.model.isShowChoices()) {
            sections.add((WizardPageSection)new HLineSection((IPageWithSections)this));
            sections.add((WizardPageSection)new ChooseOneSection((IPageWithSections)this, "Choose a depenency to add it:", (Ilabelable[])this.model.availableChoices, this.model.selected, this.model.validator).vertical());
        }
        sections.add((WizardPageSection)new HLineSection((IPageWithSections)this));
        sections.add((WizardPageSection)new CommentSection((IPageWithSections)this, "Add this to your'" + this.model.getDependencyFileName() + "'?"));
        sections.add((WizardPageSection)new DescriptionSection((IPageWithSections)this, this.model.previewText){

            protected void configureTextWidget(Text text) {
                text.setFont(JFaceResources.getFont((String)"org.eclipse.jdt.ui.editors.textfont"));
            }
        });
        return sections;
    }

    public static MavenCoordinates openOn(ChooseDependencyModel model) {
        try {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            return ChooseDependencyDialog.openOn(model, shell);
        }
        catch (Exception e) {
            Log.log(e);
            return null;
        }
    }

    public static MavenCoordinates openOn(ChooseDependencyModel model, Shell shell) {
        ChooseDependencyDialog dialog = new ChooseDependencyDialog(model, shell);
        dialog.setBlockOnOpen(true);
        dialog.open();
        return model.getResult();
    }
}

