/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.ui;

import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.core.resources.IProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;
import org.springframework.ide.eclipse.boot.core.BootActivator;
import org.springframework.ide.eclipse.boot.core.BootPropertyTester;
import org.springframework.ide.eclipse.boot.core.IMavenCoordinates;
import org.springframework.ide.eclipse.boot.core.ISpringBootProject;
import org.springframework.ide.eclipse.boot.core.MavenCoordinates;
import org.springframework.ide.eclipse.boot.core.SpringBootCore;
import org.springframework.ide.eclipse.boot.core.SpringBootStarter;
import org.springsource.ide.eclipse.commons.livexp.util.ExceptionUtil;

public class EnableDisableBootDevtools
implements IObjectActionDelegate {
    private static final VersionRange DEVTOOLS_SUPPORTED = new VersionRange("1.3.0");
    public static final String SPRING_BOOT_DEVTOOLS_AID = "spring-boot-devtools";
    public static final String SPRING_BOOT_DEVTOOLS_GID = "org.springframework.boot";
    private static final SpringBootStarter DEVTOOLS_STARTER = new SpringBootStarter("devtools", new MavenCoordinates("org.springframework.boot", "spring-boot-devtools", null), "compile", null, null);
    private SpringBootCore springBootCore;
    private IProject project;
    private IWorkbenchPart activePart;
    private ISpringBootProject bootProject;

    public EnableDisableBootDevtools() {
        this(SpringBootCore.getDefault());
    }

    public EnableDisableBootDevtools(SpringBootCore springBootCore) {
        this.springBootCore = springBootCore;
    }

    public void run(IAction action) {
        try {
            SpringBootStarter devtools = this.getAvaibleDevtools(this.bootProject);
            if (this.hasDevTools(this.bootProject)) {
                this.bootProject.removeMavenDependency(devtools.getMavenId());
            } else if (devtools != null) {
                this.bootProject.addMavenDependency(devtools.getDependency(), true);
            } else {
                MessageDialog.openError((Shell)this.activePart.getSite().getShell(), (String)"Boot Devtools Dependency could not be added", (String)this.explainFailure());
            }
        }
        catch (Exception e) {
            BootActivator.log(e);
            MessageDialog.openError((Shell)this.activePart.getSite().getShell(), (String)"Unexpected failure", (String)("The action to add/remove devtools unexpectedly failed with an error:\n" + ExceptionUtil.getMessage((Throwable)e) + "\n" + "The error log may contain further information."));
        }
    }

    private String explainFailure() throws Exception {
        if (this.project == null) {
            return "No project selected";
        }
        if (!BootPropertyTester.isBootProject(this.project)) {
            return "Project '" + this.project.getProject().getName() + "' does not seem to be a Spring Boot project";
        }
        if (!this.project.hasNature("org.eclipse.m2e.core.maven2Nature")) {
            return "Project '" + this.project.getProject().getName() + "' is not an Maven/m2e enabled project. This action's implementation requires m2e to add/remove " + "the Devtools as a dependency to your project.";
        }
        String version = this.bootProject.getBootVersion();
        return "Boot Devtools are provided by Spring Boot version 1.3.0 or later. Project '" + this.project.getProject().getName() + "' uses Boot Version " + version;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        try {
            this.project = this.getProject(selection);
            this.bootProject = this.getBootProject(this.project);
        }
        catch (Exception e) {
            BootActivator.log(e);
        }
        action.setEnabled(this.project != null);
        if (this.bootProject != null) {
            action.setText(this.hasDevTools(this.bootProject) ? "Remove Boot Devtools" : "Add Boot Devtools");
        } else if (this.project != null) {
            action.setText("Add/Remove Boot Devtools");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean hasDevTools(ISpringBootProject bootProject) {
        try {
            IMavenCoordinates d;
            List<IMavenCoordinates> deps = bootProject.getDependencies();
            if (deps == null) return false;
            Iterator<IMavenCoordinates> iterator = deps.iterator();
            do {
                if (iterator.hasNext()) continue;
                return false;
            } while (!SPRING_BOOT_DEVTOOLS_AID.equals((d = iterator.next()).getArtifactId()));
            return true;
        }
        catch (Exception e) {
            BootActivator.log(e);
        }
        return false;
    }

    private SpringBootStarter getAvaibleDevtools(ISpringBootProject project) {
        try {
            String versionString = project.getBootVersion();
            if (StringUtils.isNotBlank((CharSequence)versionString) && DEVTOOLS_SUPPORTED.includes(new Version(versionString))) {
                return DEVTOOLS_STARTER;
            }
        }
        catch (Exception e) {
            BootActivator.log(e);
        }
        return null;
    }

    private IProject getProject(ISelection selection) {
        try {
            IProject p;
            Object el;
            IStructuredSelection ss;
            if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1 && (el = ss.getFirstElement()) instanceof IProject && (p = (IProject)el).isAccessible() && p.hasNature("org.springframework.ide.eclipse.core.springnature")) {
                return p;
            }
        }
        catch (Exception e) {
            BootActivator.log(e);
        }
        return null;
    }

    private ISpringBootProject getBootProject(IProject project) {
        block3: {
            try {
                if (project != null) {
                    return this.springBootCore.project(project);
                }
            }
            catch (Exception e) {
                if (this.isExpected(e)) break block3;
                BootActivator.log(e);
            }
        }
        return null;
    }

    private boolean isExpected(Exception e) {
        String msg = ExceptionUtil.getMessage((Throwable)e);
        return msg != null && msg.contains("only implemented for m2e");
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.activePart = targetPart;
    }
}

