/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.ui.preferences;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.springframework.ide.eclipse.boot.core.BootActivator;

public class InitializrPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final String LABEL_INITIALIZR_URL = "Initializr URL";
    private static final String TOOLTIP_INITIALIZR_URL = "Spring Initializr server URL";
    private static final String MSG_INVALID_URL_FORMAT = "Invalid URL format";

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(BootActivator.getDefault().getPreferenceStore());
    }

    protected void createFieldEditors() {
        Composite parent = this.getFieldEditorParent();
        StringFieldEditor initializrUrl = new StringFieldEditor("org.springframework.ide.eclipse.boot.wizard.initializr.url", LABEL_INITIALIZR_URL, parent){

            protected boolean checkState() {
                Text text = this.getTextControl();
                if (text == null) {
                    return false;
                }
                try {
                    new URL(text.getText());
                    this.clearErrorMessage();
                    return true;
                }
                catch (MalformedURLException malformedURLException) {
                    this.setErrorMessage(InitializrPreferencePage.MSG_INVALID_URL_FORMAT);
                    this.showErrorMessage();
                    return false;
                }
            }
        };
        initializrUrl.getLabelControl(parent).setToolTipText(TOOLTIP_INITIALIZR_URL);
        initializrUrl.getTextControl(parent).setToolTipText(TOOLTIP_INITIALIZR_URL);
        this.addField((FieldEditor)initializrUrl);
    }
}

