/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.ui.preferences;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.springframework.ide.eclipse.boot.core.BootActivator;
import org.springframework.ide.eclipse.boot.core.cli.BootInstallManager;
import org.springframework.ide.eclipse.boot.core.cli.install.IBootInstall;
import org.springframework.ide.eclipse.boot.ui.preferences.BootInstallDialog;
import org.springframework.ide.eclipse.boot.util.SWTFactory;

public class InstalledBootInstallBlock
implements ISelectionProvider {
    private static final int[] defaultColumnWidth = new int[]{150, 300};
    private Composite fControl;
    private final List<IBootInstall> fVMs = new ArrayList<IBootInstall>();
    private CheckboxTableViewer fVMList;
    private Button fAddButton;
    private Button fRemoveButton;
    private Button fEditButton;
    private int fSortColumn = 0;
    private final ListenerList fSelectionListeners = new ListenerList();
    private ISelection fPrevSelection = new StructuredSelection();
    private Table fTable;
    private BootInstallManager installManager;

    public InstalledBootInstallBlock(BootInstallManager installManager) {
        this.installManager = installManager;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.fSelectionListeners.add((Object)listener);
    }

    public void createControl(Composite ancestor) {
        Composite parent;
        Font font = ancestor.getFont();
        this.fControl = parent = SWTFactory.createComposite(ancestor, font, 2, 1, 1808);
        SWTFactory.createLabel(parent, "Boot Installations:", 2);
        this.fTable = new Table(parent, 67618);
        GridData gd = new GridData(1808);
        gd.heightHint = 250;
        gd.widthHint = 350;
        this.fTable.setLayoutData((Object)gd);
        this.fTable.setFont(font);
        this.fTable.setHeaderVisible(true);
        this.fTable.setLinesVisible(true);
        TableColumn column = new TableColumn(this.fTable, 0);
        column.setText("Name");
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InstalledBootInstallBlock.this.sortByName();
            }
        });
        column = new TableColumn(this.fTable, 0);
        column.setText("Location");
        column.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InstalledBootInstallBlock.this.sortByLocation();
            }
        });
        this.fVMList = new CheckboxTableViewer(this.fTable);
        this.fVMList.setLabelProvider((IBaseLabelProvider)new VMLabelProvider());
        this.fVMList.setContentProvider((IContentProvider)new JREsContentProvider());
        this.sortByName();
        this.fVMList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent evt) {
                InstalledBootInstallBlock.this.enableButtons();
            }
        });
        this.fVMList.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                if (event.getChecked()) {
                    InstalledBootInstallBlock.this.setCheckedJRE((IBootInstall)event.getElement());
                } else {
                    InstalledBootInstallBlock.this.setCheckedJRE(null);
                }
            }
        });
        this.fVMList.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent e) {
                if (!InstalledBootInstallBlock.this.fVMList.getSelection().isEmpty()) {
                    InstalledBootInstallBlock.this.editVM();
                }
            }
        });
        this.fTable.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent event) {
                if (event.character == '\u007f' && event.stateMask == 0 && InstalledBootInstallBlock.this.fRemoveButton.isEnabled()) {
                    InstalledBootInstallBlock.this.removeVMs();
                }
            }
        });
        Composite buttons = SWTFactory.createComposite(parent, font, 1, 1, 2, 0, 0);
        this.fAddButton = SWTFactory.createPushButton(buttons, "Add...", null);
        this.fAddButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                InstalledBootInstallBlock.this.addVM();
            }
        });
        this.fEditButton = SWTFactory.createPushButton(buttons, "Edit...", null);
        this.fEditButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                InstalledBootInstallBlock.this.editVM();
            }
        });
        this.fRemoveButton = SWTFactory.createPushButton(buttons, "Remove...", null);
        this.fRemoveButton.addListener(13, new Listener(){

            public void handleEvent(Event evt) {
                InstalledBootInstallBlock.this.removeVMs();
            }
        });
        SWTFactory.createVerticalSpacer(parent, 1);
        this.fillWithWorkspaceJREs();
        this.enableButtons();
        this.fAddButton.setEnabled(JavaRuntime.getVMInstallTypes().length > 0);
    }

    public String generateName(String name, IBootInstall install) {
        if (!this.isDuplicateName(name, install)) {
            return name;
        }
        if (name.matches(".*\\(\\d*\\)")) {
            int start = name.lastIndexOf(40);
            int end = name.lastIndexOf(41);
            String stringInt = name.substring(start + 1, end);
            int numericValue = Integer.parseInt(stringInt);
            String newName = String.valueOf(name.substring(0, start + 1)) + (numericValue + 1) + ")";
            return this.generateName(newName, install);
        }
        return this.generateName(String.valueOf(name) + " (1)", install);
    }

    public IBootInstall getCheckedJRE() {
        Object[] objects = this.fVMList.getCheckedElements();
        if (objects.length == 0) {
            return null;
        }
        return (IBootInstall)objects[0];
    }

    public Control getControl() {
        return this.fControl;
    }

    public IBootInstall[] getJREs() {
        return this.fVMs.toArray(new IBootInstall[this.fVMs.size()]);
    }

    public ISelection getSelection() {
        return new StructuredSelection(this.fVMList.getCheckedElements());
    }

    public boolean isDuplicateName(String name, IBootInstall install) {
        if (install != null && install.getName() != null && install.getName().equals(name)) {
            return false;
        }
        int i = 0;
        while (i < this.fVMs.size()) {
            IBootInstall vm = this.fVMs.get(i);
            if (vm.getName().equals(name)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void removeJREs(IBootInstall[] vms) {
        IStructuredSelection prev = (IStructuredSelection)this.getSelection();
        IBootInstall[] iBootInstallArray = vms;
        int n = vms.length;
        int n2 = 0;
        while (n2 < n) {
            IBootInstall vm = iBootInstallArray[n2];
            this.fVMs.remove(vm);
            ++n2;
        }
        this.fVMList.refresh();
        IStructuredSelection curr = (IStructuredSelection)this.getSelection();
        if (!curr.equals(prev)) {
            IBootInstall[] installs = this.getJREs();
            if (curr.size() == 0 && installs.length == 1) {
                this.setSelection((ISelection)new StructuredSelection((Object)installs[0]));
            } else {
                this.fireSelectionChanged();
            }
        }
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.fSelectionListeners.remove((Object)listener);
    }

    public void restoreColumnSettings(IDialogSettings settings, String qualifier) {
        this.fVMList.getTable().layout(true);
        this.restoreColumnWidths(settings, qualifier);
        try {
            this.fSortColumn = settings.getInt(String.valueOf(qualifier) + ".sortColumn");
        }
        catch (NumberFormatException numberFormatException) {
            this.fSortColumn = 1;
        }
        switch (this.fSortColumn) {
            case 1: {
                this.sortByName();
                break;
            }
            case 2: {
                this.sortByLocation();
            }
        }
    }

    public void saveColumnSettings(IDialogSettings settings, String qualifier) {
        int columnCount = this.fTable.getColumnCount();
        int i = 0;
        while (i < columnCount) {
            settings.put(String.valueOf(qualifier) + ".columnWidth" + i, this.fTable.getColumn(i).getWidth());
            ++i;
        }
        settings.put(String.valueOf(qualifier) + ".sortColumn", this.fSortColumn);
    }

    public void setCheckedJRE(IBootInstall vm) {
        if (vm == null) {
            this.setSelection((ISelection)new StructuredSelection());
        } else {
            this.setSelection((ISelection)new StructuredSelection((Object)vm));
        }
    }

    public void setSelection(ISelection selection) {
        if (selection instanceof IStructuredSelection && !selection.equals(this.fPrevSelection)) {
            this.fPrevSelection = selection;
            Object jre = ((IStructuredSelection)selection).getFirstElement();
            if (jre == null) {
                this.fVMList.setCheckedElements(new Object[0]);
            } else {
                this.fVMList.setCheckedElements(new Object[]{jre});
                this.fVMList.reveal(jre);
            }
            this.fireSelectionChanged();
        }
    }

    public void vmAdded(IBootInstall vm) {
        this.fVMs.add(vm);
        this.fVMList.refresh();
    }

    private void addVM() {
        try {
            IBootInstall result;
            BootInstallDialog wizard = new BootInstallDialog(this.getShell(), this.installManager.newInstall("", null), this, this.installManager);
            if (wizard.open() == 0 && (result = wizard.getResult()) != null) {
                this.fVMs.add(result);
                this.fVMList.refresh();
                this.fVMList.setSelection((ISelection)new StructuredSelection((Object)result));
                this.setSelection((ISelection)new StructuredSelection((Object)result));
            }
        }
        catch (Exception e) {
            BootActivator.log(e);
        }
    }

    private void editVM() {
        IBootInstall result;
        IStructuredSelection selection = (IStructuredSelection)this.fVMList.getSelection();
        IBootInstall vm = (IBootInstall)selection.getFirstElement();
        if (vm == null) {
            return;
        }
        BootInstallDialog wizard = new BootInstallDialog(this.getShell(), vm, this, this.installManager);
        if (wizard.open() == 0 && (result = wizard.getResult()) != null) {
            int index = this.fVMs.indexOf(vm);
            this.fVMs.remove(index);
            this.fVMs.add(index, result);
            this.fVMList.refresh();
            this.fVMList.setSelection((ISelection)new StructuredSelection((Object)result));
        }
    }

    private void enableButtons() {
        IStructuredSelection selection = (IStructuredSelection)this.fVMList.getSelection();
        int selectionCount = selection.size();
        this.fEditButton.setEnabled(selectionCount == 1);
        if (selectionCount > 0 && selectionCount < this.fVMList.getTable().getItemCount()) {
            this.fRemoveButton.setEnabled(true);
        } else {
            this.fRemoveButton.setEnabled(false);
        }
    }

    private void fireSelectionChanged() {
        Object[] listeners;
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
        Object[] objectArray = listeners = this.fSelectionListeners.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener2 = objectArray[n2];
            ISelectionChangedListener listener = (ISelectionChangedListener)listener2;
            listener.selectionChanged(event);
            ++n2;
        }
    }

    private void removeVMs() {
        IStructuredSelection selection = (IStructuredSelection)this.fVMList.getSelection();
        IBootInstall[] vms = new IBootInstall[selection.size()];
        Iterator iter = selection.iterator();
        int i = 0;
        while (iter.hasNext()) {
            vms[i] = (IBootInstall)iter.next();
            ++i;
        }
        this.removeJREs(vms);
    }

    private void restoreColumnWidths(IDialogSettings settings, String qualifier) {
        int columnCount = this.fTable.getColumnCount();
        int i = 0;
        while (i < columnCount) {
            int width = -1;
            try {
                width = settings.getInt(String.valueOf(qualifier) + ".columnWidth" + i);
            }
            catch (NumberFormatException numberFormatException) {}
            if (width <= 0) {
                this.fTable.getColumn(i).setWidth(defaultColumnWidth[i]);
            } else {
                this.fTable.getColumn(i).setWidth(width);
            }
            ++i;
        }
    }

    private void sortByLocation() {
        this.fVMList.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof IBootInstall && e2 instanceof IBootInstall) {
                    IBootInstall left = (IBootInstall)e1;
                    IBootInstall right = (IBootInstall)e2;
                    return left.getUrl().compareToIgnoreCase(right.getUrl());
                }
                return super.compare(viewer, e1, e2);
            }

            public boolean isSorterProperty(Object element, String property) {
                return true;
            }
        });
        this.fSortColumn = 2;
    }

    private void sortByName() {
        this.fVMList.setComparator(new ViewerComparator(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof IBootInstall && e2 instanceof IBootInstall) {
                    IBootInstall left = (IBootInstall)e1;
                    IBootInstall right = (IBootInstall)e2;
                    return left.getName().compareToIgnoreCase(right.getName());
                }
                return super.compare(viewer, e1, e2);
            }

            public boolean isSorterProperty(Object element, String property) {
                return true;
            }
        });
        this.fSortColumn = 1;
    }

    protected void fillWithWorkspaceJREs() {
        Collection<IBootInstall> installs = this.installManager.getInstalls();
        IBootInstall deflt = null;
        try {
            deflt = this.installManager.getDefaultInstall();
        }
        catch (Exception e) {
            BootActivator.log(e);
        }
        this.setJREs(installs.toArray(new IBootInstall[installs.size()]), deflt);
    }

    protected Shell getShell() {
        return this.getControl().getShell();
    }

    protected void setJREs(IBootInstall[] vms, IBootInstall dflt) {
        this.fVMs.clear();
        IBootInstall[] iBootInstallArray = vms;
        int n = vms.length;
        int n2 = 0;
        while (n2 < n) {
            IBootInstall vm = iBootInstallArray[n2];
            this.fVMs.add(vm);
            ++n2;
        }
        this.fVMList.setInput(this.fVMs);
        this.fVMList.refresh();
        iBootInstallArray = vms;
        n = vms.length;
        n2 = 0;
        while (n2 < n) {
            IBootInstall install = iBootInstallArray[n2];
            if (install.equals(dflt)) {
                this.setCheckedJRE(install);
            }
            ++n2;
        }
    }

    class JREsContentProvider
    implements IStructuredContentProvider {
        JREsContentProvider() {
        }

        public void dispose() {
        }

        public Object[] getElements(Object input) {
            return InstalledBootInstallBlock.this.fVMs.toArray();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class VMLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        VMLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof IBootInstall) {
                IBootInstall vm = (IBootInstall)element;
                switch (columnIndex) {
                    case 0: {
                        return vm.getName();
                    }
                    case 1: {
                        return vm.getUrl();
                    }
                }
            }
            return element.toString();
        }
    }
}

