/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.JavaRuntime;
import org.springframework.ide.eclipse.boot.core.BootActivator;
import org.springframework.ide.eclipse.boot.util.FileUtil;

public class JavaProjectUtil {
    public static List<File> getNonSystemJarDependencies(IJavaProject jp, boolean reverse) {
        try {
            String[] paths = JavaRuntime.computeDefaultRuntimeClassPath((IJavaProject)jp);
            if (paths != null && paths.length > 0) {
                LinkedList<File> jars = new LinkedList<File>();
                String[] stringArray = paths;
                int n = paths.length;
                int n2 = 0;
                while (n2 < n) {
                    File jar;
                    String path = stringArray[n2];
                    if (path != null && FileUtil.isJarFile(jar = new File(path))) {
                        if (reverse) {
                            jars.addFirst(jar);
                        } else {
                            jars.add(jar);
                        }
                    }
                    ++n2;
                }
                return jars;
            }
        }
        catch (Exception e) {
            BootActivator.log(e);
        }
        return Collections.emptyList();
    }

    public static IFile getOutputFile(IJavaProject jp, String relativePath) {
        return JavaProjectUtil.getOutputFile(jp, (IPath)new Path(relativePath));
    }

    public static IFile getOutputFile(IJavaProject jp, IPath relativePath) {
        try {
            IPath loc = jp.getOutputLocation().append(relativePath);
            String pname = loc.segment(0);
            return ResourcesPlugin.getWorkspace().getRoot().getProject(pname).getFile(loc.removeFirstSegments(1));
        }
        catch (Exception e) {
            BootActivator.log(e);
            return null;
        }
    }

    public static IContainer[] getSourceFolders(IProject p) {
        try {
            if (p != null && p.isAccessible() && p.hasNature("org.eclipse.jdt.core.javanature")) {
                return JavaProjectUtil.getSourceFolders(JavaCore.create((IProject)p), true);
            }
        }
        catch (Exception e) {
            BootActivator.log(e);
        }
        return new IContainer[0];
    }

    public static IContainer[] getSourceFolders(IJavaProject jp, boolean includeDerived) {
        try {
            IClasspathEntry[] cp;
            ArrayList<IContainer> sourceFolders = new ArrayList<IContainer>();
            IClasspathEntry[] iClasspathEntryArray = cp = jp.getResolvedClasspath(true);
            int n = cp.length;
            int n2 = 0;
            while (n2 < n) {
                IClasspathEntry cpe = iClasspathEntryArray[n2];
                try {
                    IContainer sf;
                    if (cpe.getEntryKind() == 3 && (sf = JavaProjectUtil.getProjectOrFolder(cpe.getPath())) != null && sf.exists() && (includeDerived || !sf.isDerived())) {
                        sourceFolders.add(sf);
                    }
                }
                catch (Exception e) {
                    BootActivator.log(e);
                }
                ++n2;
            }
            return sourceFolders.toArray(new IContainer[sourceFolders.size()]);
        }
        catch (Exception e) {
            BootActivator.log(e);
            return new IContainer[0];
        }
    }

    public static IContainer getProjectOrFolder(IPath path) {
        if (path.segmentCount() > 1) {
            return ResourcesPlugin.getWorkspace().getRoot().getFolder(path);
        }
        if (path.segmentCount() == 1) {
            return ResourcesPlugin.getWorkspace().getRoot().getProject(path.segment(0));
        }
        return null;
    }

    public static Set<IContainer> getOutputFolders(IJavaProject jp) {
        IContainer defaultOutput = JavaProjectUtil.getDefaultOutputFolder(jp);
        if (defaultOutput != null) {
            return Collections.singleton(JavaProjectUtil.getDefaultOutputFolder(jp));
        }
        return Collections.emptySet();
    }

    public static IContainer getDefaultOutputFolder(IJavaProject jp) {
        try {
            IPath loc = jp.getOutputLocation();
            String pname = loc.segment(0);
            if (loc.segmentCount() == 1) {
                return ResourcesPlugin.getWorkspace().getRoot().getProject(pname);
            }
            return ResourcesPlugin.getWorkspace().getRoot().getProject(pname).getFolder(loc.removeFirstSegments(1));
        }
        catch (Exception e) {
            BootActivator.log(e);
            return null;
        }
    }
}

