/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ide.eclipse.boot.util;

import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.springsource.ide.eclipse.commons.livexp.ui.Disposable;

public class ProcessTracker
implements Disposable {
    private IDebugEventSetListener debugListener;
    private ProcessListener listener;

    public ProcessTracker(ProcessListener listener) {
        this.listener = listener;
        this.debugListener = new IDebugEventSetListener(){

            public void handleDebugEvents(DebugEvent[] events) {
                if (events != null) {
                    DebugEvent[] debugEventArray = events;
                    int n = events.length;
                    int n2 = 0;
                    while (n2 < n) {
                        DebugEvent debugEvent = debugEventArray[n2];
                        ProcessTracker.this.handleDebugEvent(debugEvent);
                        ++n2;
                    }
                }
            }
        };
        DebugPlugin.getDefault().addDebugEventListener(this.debugListener);
        ILaunch[] launches = DebugPlugin.getDefault().getLaunchManager().getLaunches();
        if (launches != null) {
            ILaunch[] iLaunchArray = launches;
            int n = launches.length;
            int n2 = 0;
            while (n2 < n) {
                ILaunch launch = iLaunchArray[n2];
                IProcess[] iProcessArray = launch.getProcesses();
                int n3 = iProcessArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IProcess process = iProcessArray[n4];
                    this.processCreated(process);
                    ++n4;
                }
                ++n2;
            }
        }
    }

    protected final void handleDebugEvent(DebugEvent debugEvent) {
        int kind = debugEvent.getKind();
        Object source = debugEvent.getSource();
        switch (kind) {
            case 4: {
                if (source instanceof IProcess) {
                    this.processCreated((IProcess)source);
                    break;
                }
                if (!(source instanceof IDebugTarget)) break;
                this.debugTargetCreated((IDebugTarget)source);
                break;
            }
            case 8: {
                if (source instanceof IProcess) {
                    this.processTerminated((IProcess)source);
                    break;
                }
                if (!(source instanceof IDebugTarget)) break;
                this.debugTargetTerminated((IDebugTarget)source);
                break;
            }
        }
    }

    private void debugTargetCreated(IDebugTarget source) {
        this.listener.debugTargetCreated(this, source);
    }

    private void debugTargetTerminated(IDebugTarget source) {
        this.listener.debugTargetTerminated(this, source);
    }

    private void processCreated(IProcess process) {
        this.listener.processCreated(this, process);
    }

    private void processTerminated(IProcess process) {
        this.listener.processTerminated(this, process);
    }

    public void dispose() {
        if (this.debugListener != null) {
            DebugPlugin.getDefault().removeDebugEventListener(this.debugListener);
            this.debugListener = null;
            this.listener = null;
        }
    }

    public static interface ProcessListener {
        public void debugTargetCreated(ProcessTracker var1, IDebugTarget var2);

        public void debugTargetTerminated(ProcessTracker var1, IDebugTarget var2);

        public void processTerminated(ProcessTracker var1, IProcess var2);

        public void processCreated(ProcessTracker var1, IProcess var2);
    }
}

